/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.storage;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.machines.Machine;
import binnie.core.machines.storage.CompartmentTab;
import binnie.core.machines.storage.ComponentCompartmentInventory;
import binnie.core.machines.storage.ControlColourSelector;
import binnie.core.machines.transfer.TransferRequest;
import binnie.craftgui.controls.ControlCheckbox;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextEdit;
import binnie.craftgui.controls.button.ControlButton;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.page.ControlPage;
import binnie.craftgui.controls.page.ControlPages;
import binnie.craftgui.controls.scroll.ControlScrollableContent;
import binnie.craftgui.controls.tab.ControlTab;
import binnie.craftgui.controls.tab.ControlTabBar;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.IBorder;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventTextEdit;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.genetics.machine.WindowMachine;
import binnie.craftgui.minecraft.Dialog;
import binnie.craftgui.minecraft.EnumColor;
import binnie.craftgui.minecraft.IWindowAffectsShiftClick;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.minecraft.control.ControlItemDisplay;
import binnie.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.craftgui.minecraft.control.ControlSlide;
import binnie.craftgui.minecraft.control.ControlSlot;
import binnie.craftgui.minecraft.control.ControlSlotArray;
import binnie.craftgui.minecraft.control.ControlTabIcon;
import binnie.craftgui.resource.Texture;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.craftgui.window.Panel;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WindowCompartment
extends WindowMachine
implements IWindowAffectsShiftClick {
    private final Map<Panel, Integer> panels = new HashMap<Panel, Integer>();
    private ControlTextEdit tabName;
    private ControlItemDisplay tabIcon;
    private ControlColourSelector tabColour;
    boolean dueUpdate;
    private int currentTab = 0;

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowCompartment(player, inventory, side);
    }

    public WindowCompartment(EntityPlayer player, IInventory inventory, Side side) {
        super(320, 226, player, inventory, side);
    }

    @Override
    public void initialiseClient() {
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        int x = 16;
        int y = 32;
        ComponentCompartmentInventory inv = Machine.getMachine(this.getInventory()).getInterface(ComponentCompartmentInventory.class);
        Integer[] tabs1 = new Integer[]{};
        Integer[] tabs2 = new Integer[]{};
        if (inv.getTabNumber() == 4) {
            tabs1 = new Integer[]{0, 1};
            tabs2 = new Integer[]{2, 3};
        }
        if (inv.getTabNumber() == 6) {
            tabs1 = new Integer[]{0, 1, 2};
            tabs2 = new Integer[]{3, 4, 5};
        }
        if (inv.getTabNumber() == 8) {
            tabs1 = new Integer[]{0, 1, 2, 3};
            tabs2 = new Integer[]{4, 5, 6, 7};
        }
        boolean doubleTabbed = tabs2.length > 0;
        int compartmentPageWidth = 16 + 18 * inv.getPageSize() / 5;
        int compartmentPageHeight = 106;
        int compartmentWidth = compartmentPageWidth + (doubleTabbed ? 48 : 24);
        int compartmentHeight = compartmentPageHeight;
        Control controlCompartment = new Control(this, x, y, compartmentWidth, compartmentHeight);
        final ControlTabBar<Integer> tab = new ControlTabBar<Integer>((IWidget)controlCompartment, 0.0f, 0.0f, 24.0f, (float)compartmentPageHeight, Position.Left){

            @Override
            public ControlTab<Integer> createTab(float x, float y, float w, float h, Integer value) {
                return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public ItemStack getItemStack() {
                        return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                    }

                    @Override
                    public String getName() {
                        return WindowCompartment.this.getTab((Integer)this.value).getName();
                    }

                    @Override
                    public int getOutlineColour() {
                        return WindowCompartment.this.getTab((Integer)this.value).getColor().getColour();
                    }

                    @Override
                    public boolean hasOutline() {
                        return true;
                    }
                };
            }
        };
        String[] tabHelp = new String[]{"Compartment Tab", "Tabs that divide the inventory into sections. Each one can be labelled seperately."};
        tab.addHelp(tabHelp);
        tab.setValues(Arrays.asList(tabs1));
        tab.setValue(0);
        tab.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                NBTTagCompound nbt = new NBTTagCompound();
                int i = (Integer)event.getValue();
                nbt.func_74774_a("i", (byte)i);
                ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                WindowCompartment.this.currentTab = i;
            }
        }.setOrigin(EventHandler.Origin.DirectChild, tab));
        x += 24;
        ControlPages compartmentPages = new ControlPages(controlCompartment, 24.0f, 0.0f, compartmentPageWidth, compartmentPageHeight);
        ControlPage[] page = new ControlPage[inv.getTabNumber()];
        for (int p = 0; p < inv.getTabNumber(); ++p) {
            page[p] = new ControlPage<Integer>(compartmentPages, p);
        }
        CraftGUIUtil.linkWidgets(tab, compartmentPages);
        int i = 0;
        for (int p = 0; p < inv.getTabNumber(); ++p) {
            ControlPage thisPage = page[p];
            Panel panel = new Panel(thisPage, 0.0f, 0.0f, thisPage.w(), thisPage.h(), MinecraftGUI.PanelType.Black){

                @Override
                public void onRenderForeground() {
                    Texture iTexture = CraftGUI.Render.getTexture((Object)CraftGUITexture.TabOutline);
                    CraftGUI.Render.colour(WindowCompartment.this.getTab((Integer)WindowCompartment.this.panels.get(this)).getColor().getColour());
                    CraftGUI.Render.texture(iTexture, this.getArea().inset(3));
                }
            };
            this.panels.put(panel, p);
            int[] slotsIDs = new int[inv.getPageSize()];
            for (int k = 0; k < inv.getPageSize(); ++k) {
                slotsIDs[k] = i++;
            }
            new ControlSlotArray((IWidget)thisPage, 8, 8, inv.getPageSize() / 5, 5).create(slotsIDs);
        }
        x += compartmentPageWidth;
        if (tabs2.length > 0) {
            ControlTabBar<Integer> tab2 = new ControlTabBar<Integer>((IWidget)controlCompartment, (float)(24 + compartmentPageWidth), 0.0f, 24.0f, (float)compartmentPageHeight, Position.Right){

                @Override
                public ControlTab<Integer> createTab(float x, float y, float w, float h, Integer value) {
                    return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                        @Override
                        public ItemStack getItemStack() {
                            return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                        }

                        @Override
                        public String getName() {
                            return WindowCompartment.this.getTab((Integer)this.value).getName();
                        }

                        @Override
                        public int getOutlineColour() {
                            return WindowCompartment.this.getTab((Integer)this.value).getColor().getColour();
                        }

                        @Override
                        public boolean hasOutline() {
                            return true;
                        }
                    };
                }
            };
            tab2.setValues(Arrays.asList(tabs2));
            tab2.setValue(0);
            tab2.addHelp(tabHelp);
            tab2.addEventHandler(new EventValueChanged.Handler(){

                @Override
                public void onEvent(EventValueChanged event) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    int i = (Integer)event.getValue();
                    nbt.func_74774_a("i", (byte)i);
                    ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                    WindowCompartment.this.currentTab = i;
                }
            }.setOrigin(EventHandler.Origin.DirectChild, tab2));
            CraftGUIUtil.linkWidgets(tab2, compartmentPages);
            x += 24;
        }
        x += 16;
        this.setSize(new IPoint(Math.max(32 + compartmentWidth, 252), this.h()));
        controlCompartment.setPosition(new IPoint((this.w() - controlCompartment.w()) / 2.0f, controlCompartment.y()));
        ControlPlayerInventory invent = new ControlPlayerInventory((IWidget)this, true);
        ControlSlide slide = new ControlSlide(this, 0.0f, 134.0f, 136.0f, 92.0f, Position.Left);
        slide.setLabel("Tab Properties");
        slide.setSlide(false);
        slide.addHelp("Tab Properties");
        slide.addHelp("The label, colour and icon of the Tab can be altered here. Clicking on the icon with a held item will change it.");
        Panel tabPropertyPanel = new Panel(slide, 16.0f, 8.0f, 112.0f, 76.0f, MinecraftGUI.PanelType.Gray);
        int y2 = 4;
        new ControlText((IWidget)tabPropertyPanel, new IPoint(4.0f, y2), "Tab Name:");
        this.tabName = new ControlTextEdit(tabPropertyPanel, 4.0f, y2 += 12, 104.0f, 12.0f);
        this.tabName.addSelfEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                tab.setName((String)event.getValue());
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        }.setOrigin(EventHandler.Origin.Self, this.tabName));
        new ControlText((IWidget)tabPropertyPanel, new IPoint(4.0f, y2 += 20), "Tab Icon: ");
        this.tabIcon = new ControlItemDisplay(tabPropertyPanel, 58.0f, y2 - 4);
        this.tabIcon.setItemStack(new ItemStack(Items.field_151121_aF));
        this.tabIcon.addAttribute(Attribute.MouseOver);
        this.tabIcon.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (WindowCompartment.this.getHeldItemStack() == null) {
                    return;
                }
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                ItemStack stack = WindowCompartment.this.getHeldItemStack().func_77946_l();
                stack.field_77994_a = 1;
                tab.setIcon(stack);
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        });
        this.tabColour = new ControlColourSelector(tabPropertyPanel, 82.0f, y2 - 4, 16.0f, 16.0f, EnumColor.White);
        this.tabIcon.addHelp("Icon for Current Tab");
        this.tabIcon.addHelp("Click here with an item to change");
        new ControlText((IWidget)tabPropertyPanel, new IPoint(4.0f, y2 += 20), "Colour: ");
        int cw = 8;
        Panel panelColour = new Panel(tabPropertyPanel, 40.0f, y2 - 4, cw * 8 + 2, cw * 2 + 1, MinecraftGUI.PanelType.Gray);
        for (int cc = 0; cc < 16; ++cc) {
            final ControlColourSelector color = new ControlColourSelector(panelColour, 1 + cw * (cc % 8), 1 + cw * (cc / 8), cw, cw, EnumColor.values()[cc]);
            color.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                @Override
                public void onEvent(EventMouse.Down event) {
                    CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                    tab.setColor(color.getValue());
                    NBTTagCompound nbt = new NBTTagCompound();
                    tab.writeToNBT(nbt);
                    WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
                }
            });
            color.addHelp("Colour Selector");
            color.addHelp("Select a colour to highlight the current tab");
        }
        y2 += 20;
        ControlButton searchButton = new ControlButton(controlCompartment, compartmentWidth - 24 - 64 - 8, compartmentPageHeight, 64.0f, 16.0f, "Search"){

            @Override
            protected void onMouseClick(EventMouse.Down event) {
                WindowCompartment.this.createSearchDialog();
            }

            @Override
            public void onRenderBackground() {
                CraftGUITexture texture = this.isMouseOver() ? CraftGUITexture.TabHighlighted : CraftGUITexture.Tab;
                CraftGUI.Render.texture(CraftGUI.Render.getTexture((Object)texture).crop(Position.Bottom, 8.0f), this.getArea());
            }
        };
        searchButton.addHelp("Search Button");
        searchButton.addHelp("Clicking this will open the Search dialog. This allows you to search the inventory for specific items.");
    }

    public void createSearchDialog() {
        new Dialog(this, 252.0f, 192.0f){
            Control slotGrid;
            String textSearch;
            boolean sortByName;
            boolean includeItems;
            boolean includeBlocks;
            {
                this.textSearch = "";
                this.sortByName = false;
                this.includeItems = true;
                this.includeBlocks = true;
            }

            @Override
            public void onClose() {
            }

            @Override
            public void initialise() {
                ControlScrollableContent<IWidget> scroll = new ControlScrollableContent<IWidget>((IWidget)this, 124.0f, 16.0f, 116.0f, 92.0f, 6.0f){

                    @Override
                    public void onRenderBackground() {
                        CraftGUI.Render.colour(0xAAAAAA);
                        CraftGUI.Render.texture((Object)CraftGUITexture.Outline, this.getArea().inset(new IBorder(0.0f, 6.0f, 0.0f, 0.0f)));
                    }
                };
                this.slotGrid = new Control(scroll, 1.0f, 1.0f, 108.0f, 18.0f);
                scroll.setScrollableContent(this.slotGrid);
                new ControlPlayerInventory((IWidget)this, true);
                new ControlTextEdit(this, 16.0f, 16.0f, 100.0f, 14.0f).addEventHandler((EventHandler)new EventTextEdit.Handler(){

                    @Override
                    public void onEvent(EventTextEdit event) {
                        textSearch = (String)event.value;
                        this.updateSearch();
                    }
                });
                this.includeItems = true;
                this.includeBlocks = true;
                new ControlCheckbox(this, 16.0f, 40.0f, 100.0f, "Sort A-Z", this.sortByName){

                    @Override
                    protected void onValueChanged(boolean value) {
                        sortByName = value;
                        this.updateSearch();
                    }
                };
                new ControlCheckbox(this, 16.0f, 64.0f, 100.0f, "Include Items", this.includeItems){

                    @Override
                    protected void onValueChanged(boolean value) {
                        includeItems = value;
                        this.updateSearch();
                    }
                };
                new ControlCheckbox(this, 16.0f, 88.0f, 100.0f, "Include Blocks", this.includeBlocks){

                    @Override
                    protected void onValueChanged(boolean value) {
                        includeBlocks = value;
                        this.updateSearch();
                    }
                };
                this.updateSearch();
            }

            private void updateSearch() {
                HashMap<Integer, String> slotIds = new HashMap<Integer, String>();
                IInventory inv = WindowCompartment.this.getInventory();
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null) continue;
                    String name = stack.func_82833_r().toLowerCase();
                    if (this.textSearch != null && !name.contains(this.textSearch) || !this.includeBlocks && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a || !this.includeItems && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) continue;
                    slotIds.put(i, name);
                }
                if (this.sortByName) {
                    LinkedList list = new LinkedList(slotIds.entrySet());
                    Collections.sort(list, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return -((Comparable)((Map.Entry)o2).getValue()).compareTo(((Map.Entry)o1).getValue());
                        }
                    });
                    LinkedHashMap result = new LinkedHashMap();
                    for (Map.Entry entry : list) {
                        result.put(entry.getKey(), entry.getValue());
                    }
                    slotIds = result;
                }
                int y = 0;
                int x = 0;
                int width = 108;
                int n = 2 + 18 * (1 + (slotIds.size() - 1) / 6);
                this.slotGrid.deleteAllChildren();
                this.slotGrid.setSize(new IPoint(width, n));
                Iterator i$ = slotIds.keySet().iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    new ControlSlot(this.slotGrid, x, y).assign(k);
                    if ((x += 18) < 108) continue;
                    x = 0;
                    y += 18;
                }
                while (y < 108 || x != 0) {
                    new ControlSlot(this.slotGrid, x, y);
                    if ((x += 18) < 108) continue;
                    x = 0;
                    y += 18;
                }
            }
        };
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        this.updateTabs();
    }

    public void updateTabs() {
        this.tabName.setValue(this.getCurrentTab().getName());
        this.tabIcon.setItemStack(this.getCurrentTab().getIcon());
        this.tabColour.setValue(this.getCurrentTab().getColor());
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        super.recieveGuiNBT(side, player, name, action);
        if (name.equals("tab-change")) {
            this.currentTab = action.func_74771_c("i");
        }
    }

    @Override
    public String getTitle() {
        return "Compartment";
    }

    @Override
    protected AbstractMod getMod() {
        return BinnieCore.instance;
    }

    @Override
    protected String getName() {
        return "compartment";
    }

    @Override
    public void alterRequest(TransferRequest request) {
        if (request.getDestination() == this.getInventory()) {
            ComponentCompartmentInventory inv = Machine.getMachine(this.getInventory()).getInterface(ComponentCompartmentInventory.class);
            request.setTargetSlots(inv.getSlotsForTab(this.currentTab));
        }
    }

    public CompartmentTab getTab(int i) {
        return Machine.getInterface(ComponentCompartmentInventory.class, this.getInventory()).getTab(i);
    }

    public CompartmentTab getCurrentTab() {
        return this.getTab(this.currentTab);
    }
}

