/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.TileEntityMachine;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.scroll.IControlScrollable;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.TopLevelWidget;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.extratrees.dictionary.WindowWoodworker;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignCategory;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.machines.Designer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ControlTileSelect
extends Control
implements IControlValue<IDesign>,
IControlScrollable {
    IDesign value = EnumDesign.Blank;
    float shownHeight = 92.0f;

    protected ControlTileSelect(IWidget parent, float x, float y) {
        super(parent, x, y, 102.0f, 20 * (CarpentryManager.carpentryInterface.getSortedDesigns().size() / 4) + 22);
        this.refresh("");
    }

    @Override
    public float getPercentageIndex() {
        return 0.0f;
    }

    @Override
    public float getPercentageShown() {
        return 0.0f;
    }

    @Override
    public IDesign getValue() {
        return this.value;
    }

    @Override
    public void movePercentage(float percentage) {
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        TileEntityMachine tile = (TileEntityMachine)((Window)Window.get(this)).getInventory();
        if (tile == null) {
            return;
        }
        Designer.ComponentWoodworkerRecipe recipe = tile.getMachine().getComponent(Designer.ComponentWoodworkerRecipe.class);
        this.setValue(recipe.getDesign());
    }

    public void refresh(String filterText) {
        this.deleteAllChildren();
        int cx = 2;
        int cy = 2;
        HashMap designs = new HashMap();
        for (IDesignCategory category : CarpentryManager.carpentryInterface.getAllDesignCategories()) {
            designs.put(category, new ArrayList());
            for (IDesign tile : category.getDesigns()) {
                if (filterText != "" && !tile.getName().toLowerCase().contains(filterText)) continue;
                ((List)designs.get(category)).add(tile);
            }
            if (!((List)designs.get(category)).isEmpty()) continue;
            designs.remove(category);
        }
        for (IDesignCategory category : designs.keySet()) {
            cx = 2;
            new ControlText((IWidget)this, new IPoint(cx, cy + 3), category.getName());
            cy += 16;
            for (IDesign tile : (List)designs.get(category)) {
                if (cx > 90) {
                    cx = 2;
                    cy += 20;
                }
                new ControlTile(this, cx, cy, tile);
                cx += 20;
            }
            cy += 20;
        }
        int height = cy;
        this.setSize(new IPoint(this.getSize().x(), height));
    }

    @Override
    public void setPercentageIndex(float index) {
    }

    @Override
    public void setValue(IDesign value) {
        this.value = value;
    }

    @Override
    public float getMovementRange() {
        return 0.0f;
    }

    public static class ControlTile
    extends Control
    implements IControlValue<IDesign>,
    ITooltip {
        IDesign value;

        protected ControlTile(IWidget parent, float x, float y, IDesign value) {
            super(parent, x, y, 18.0f, 18.0f);
            this.setValue(value);
            this.addAttribute(Attribute.MouseOver);
            this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                @Override
                public void onEvent(EventMouse.Down event) {
                    TileEntityMachine tile = (TileEntityMachine)((Window)Window.get(ControlTile.this.getWidget())).getInventory();
                    if (tile == null) {
                        return;
                    }
                    Designer.ComponentWoodworkerRecipe recipe = tile.getMachine().getComponent(Designer.ComponentWoodworkerRecipe.class);
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74777_a("d", (short)CarpentryManager.carpentryInterface.getDesignIndex(ControlTile.this.getValue()));
                    ((Window)Window.get(ControlTile.this.getWidget())).sendClientAction("design", nbt);
                }
            });
        }

        @Override
        public void getTooltip(Tooltip tooltip) {
            tooltip.add(Binnie.Language.localise(BinnieCore.instance, "gui.designer.pattern", this.getValue().getName()));
        }

        @Override
        public IDesign getValue() {
            return this.value;
        }

        @Override
        public void onRenderBackground() {
            CraftGUI.Render.texture((Object)CraftGUITexture.Slot, IPoint.ZERO);
        }

        @Override
        public void onRenderForeground() {
            ItemStack image = ((WindowWoodworker)this.getSuperParent()).getDesignerType().getDisplayStack(this.getValue());
            CraftGUI.Render.item(new IPoint(1.0f, 1.0f), image);
            if (((IControlValue)this.getParent()).getValue() != this.getValue()) {
                if (((TopLevelWidget)Window.get(this)).getMousedOverWidget() == this) {
                    CraftGUI.Render.gradientRect(this.getArea().inset(1), 0x44FFFFFF, 0x44FFFFFF);
                } else {
                    CraftGUI.Render.gradientRect(this.getArea().inset(1), -1433892728, -1433892728);
                }
            }
        }

        @Override
        public void setValue(IDesign value) {
            this.value = value;
        }
    }
}

