/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft.control;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.minecraft.control.ControlItemDisplay;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraft.item.ItemStack;

public abstract class ControlSlotBase
extends Control
implements ITooltip {
    private ControlItemDisplay itemDisplay;

    public ControlSlotBase(IWidget parent, float x, float y) {
        this(parent, x, y, 18);
    }

    public ControlSlotBase(IWidget parent, float x, float y, int size) {
        super(parent, x, y, size, size);
        this.addAttribute(Attribute.MouseOver);
        this.itemDisplay = new ControlItemDisplay(this, 1.0f, 1.0f, size - 2);
        this.addSelfEventHandler((EventHandler)new EventWidget.ChangeSize.Handler(){

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                if (ControlSlotBase.this.itemDisplay != null) {
                    ControlSlotBase.this.itemDisplay.setSize(ControlSlotBase.this.getSize().sub(new IPoint(2.0f, 2.0f)));
                }
            }
        });
    }

    protected void setRotating() {
        this.itemDisplay.setRotating();
    }

    @Override
    public void onRenderBackground() {
        int size = (int)this.getSize().x();
        CraftGUI.Render.texture((Object)CraftGUITexture.Slot, this.getArea());
        if (this.getSuperParent().getMousedOverWidget() == this) {
            CraftGUI.Render.gradientRect(new IArea(new IPoint(1.0f, 1.0f), this.getArea().size().sub(new IPoint(2.0f, 2.0f))), -2130706433, -2130706433);
        }
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        this.itemDisplay.setItemStack(this.getItemStack());
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        ItemStack item = this.getItemStack();
        if (item == null) {
            return;
        }
        tooltip.add(item.func_82840_a(((Window)this.getSuperParent()).getPlayer(), false));
    }

    public abstract ItemStack getItemStack();
}

