/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.window;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.resource.minecraft.CraftGUITexture;

public class Panel
extends Control {
    IPanelType type;

    public Panel(IWidget parent, float x, float y, float width, float height, IPanelType type) {
        super(parent, x, y, width, height);
        this.type = type;
    }

    public Panel(IWidget parent, IArea area, IPanelType type) {
        this(parent, area.x(), area.y(), area.w(), area.h(), type);
    }

    public IPanelType getType() {
        return this.type;
    }

    @Override
    public void onRenderBackground() {
        IPanelType panelType = this.getType();
        if (panelType instanceof MinecraftGUI.PanelType) {
            switch ((MinecraftGUI.PanelType)panelType) {
                case Black: {
                    CraftGUI.Render.texture((Object)CraftGUITexture.PanelBlack, this.getArea());
                    break;
                }
                case Gray: {
                    CraftGUI.Render.texture((Object)CraftGUITexture.PanelGray, this.getArea());
                    break;
                }
                case Tinted: {
                    CraftGUI.Render.texture((Object)CraftGUITexture.PanelTinted, this.getArea());
                    break;
                }
                case Outline: {
                    CraftGUI.Render.texture((Object)CraftGUITexture.Outline, this.getArea());
                    break;
                }
                case TabOutline: {
                    CraftGUI.Render.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                    break;
                }
            }
        }
    }

    public static interface IPanelType {
    }
}

