/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.core.genetics.Gene;
import binnie.genetics.CreativeTabGenetics;
import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemAnalysable;
import binnie.genetics.api.IItemChargable;
import binnie.genetics.genetics.GeneItem;
import binnie.genetics.genetics.SequencerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemSequence
extends Item
implements IItemAnalysable,
IItemChargable {
    public ItemSequence() {
        this.func_77625_d(1);
        this.func_77656_e(5);
        this.func_77655_b("sequence");
        this.func_77637_a(CreativeTabGenetics.instance);
    }

    public String func_77653_i(ItemStack itemstack) {
        GeneItem gene = new GeneItem(itemstack);
        if (gene.isCorrupted()) {
            return "Corrupted Sequence";
        }
        return gene.getBreedingSystem().getDescriptor() + " DNA Sequence";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemstack, entityPlayer, list, par4);
        list.add(Genetics.proxy.localise("item.sequence." + (5 - itemstack.func_77960_j() % 6)));
        SequencerItem gene = new SequencerItem(itemstack);
        if (gene.isCorrupted()) {
            return;
        }
        if (gene.analysed) {
            gene.getInfo(list);
        } else {
            list.add("<Unknown>");
        }
        int seq = gene.sequenced;
        if (seq == 0) {
            list.add("Unsequenced");
        } else if (seq < 100) {
            list.add("Partially Sequenced (" + seq + "%)");
        } else {
            list.add("Fully Sequenced");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = Genetics.proxy.getIcon(register, "sequencer");
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMeadows");
        itemList.add(ItemSequence.create(new Gene((IAllele)species, (IChromosomeType)EnumBeeChromosome.SPECIES, (ISpeciesRoot)Binnie.Genetics.getBeeRoot()), false));
    }

    @Override
    public boolean isAnalysed(ItemStack stack) {
        SequencerItem seq = new SequencerItem(stack);
        return seq.isCorrupted() || seq.analysed;
    }

    @Override
    public ItemStack analyse(ItemStack stack) {
        SequencerItem seq = new SequencerItem(stack);
        seq.analysed = true;
        seq.writeToItem(stack);
        return stack;
    }

    @Override
    public float getAnalyseTimeMult(ItemStack stack) {
        return 1.0f;
    }

    public static ItemStack create(IGene gene) {
        return ItemSequence.create(gene, false);
    }

    public static ItemStack create(IGene gene, boolean sequenced) {
        ItemStack item = new ItemStack(Genetics.itemSequencer);
        item.func_77964_b(sequenced ? 0 : item.func_77958_k());
        SequencerItem seq = new SequencerItem(gene);
        seq.writeToItem(item);
        return item;
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77973_b().func_77612_l() - stack.func_77960_j();
    }
}

