/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.resource.BinnieIcon;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.GeneTracker;
import binnie.genetics.genetics.SequencerItem;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Sequencer {
    public static final int slotDye = 0;
    public static final int[] slotReserve = new int[]{1, 2, 3, 4};
    public static final int slotTarget = 5;
    public static final int slotDone = 6;
    public static BinnieIcon fxSeqA;
    public static BinnieIcon fxSeqG;
    public static BinnieIcon fxSeqT;
    public static BinnieIcon fxSeqC;

    public static class SlotValidatorUnsequenced
    extends SlotValidator {
        public SlotValidatorUnsequenced() {
            super(ModuleMachine.IconSequencer);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            if (itemStack.func_77973_b() == Genetics.itemSequencer) {
                SequencerItem seq = new SequencerItem(itemStack);
                return seq.sequenced < 100;
            }
            return false;
        }

        @Override
        public String getTooltip() {
            return "Unsequenced DNA";
        }
    }

    public static class ComponentSequencerFX
    extends MachineComponent
    implements IRender.RandomDisplayTick,
    IRender.DisplayTick {
        public ComponentSequencerFX(IMachine machine) {
            super(machine);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRandomDisplayTick(World world, int x, int y, int z, Random rand) {
            if (!this.getUtil().getProcess().isInProgress()) {
                return;
            }
            BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.5, (double)y + 1.2 + rand.nextDouble() * 0.2, (double)z + 0.5, 0.0, 0.0, 0.0){
                double axisX;
                double axisZ;
                double angle;
                {
                    this.axisX = 0.0;
                    this.axisZ = 0.0;
                    this.angle = 0.0;
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70547_e = 200;
                    this.axisX = this.field_70165_t;
                    this.axisZ = this.field_70161_v;
                    this.field_70545_g = 0.0f;
                    this.angle = this.field_70146_Z.nextDouble() * 2.0 * 3.1415;
                    this.field_70145_X = true;
                    this.func_70538_b(0.6f + this.field_70146_Z.nextFloat() * 0.2f, 1.0f, 0.8f * this.field_70146_Z.nextFloat() * 0.2f);
                }

                public void func_70071_h_() {
                    super.func_70071_h_();
                    this.angle += 0.03;
                    this.func_70107_b(this.axisX + 0.4 * Math.sin(this.angle), this.field_70163_u, this.axisZ + 0.4 * Math.cos(this.angle));
                    this.field_70181_x = 0.0;
                    this.func_82338_g((float)Math.sin(3.14 * (double)this.field_70546_d / (double)this.field_70547_e));
                }

                public int func_70537_b() {
                    return 0;
                }
            });
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onDisplayTick(World world, int x, int y, int z, Random rand) {
            int ticks = (int)(world.func_82737_E() % 16L);
            if (ticks == 0 && this.getUtil().getProcess().isInProgress()) {
                BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.5, y + 1, (double)z + 0.5, 0.0, 0.0, 0.0){
                    double axisX;
                    double axisZ;
                    double angle;
                    {
                        this.axisX = 0.0;
                        this.axisZ = 0.0;
                        this.angle = 0.0;
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.012;
                        this.field_70547_e = 50;
                        this.field_70545_g = 0.0f;
                        this.field_70145_X = true;
                        this.field_70544_f = 2.0f;
                        this.func_110125_a((new BinnieIcon[]{fxSeqA, fxSeqG, fxSeqC, fxSeqT})[this.field_70146_Z.nextInt(4)].getIcon());
                    }

                    public void func_70071_h_() {
                        super.func_70071_h_();
                        this.field_70181_x = 0.012;
                        if (this.field_70546_d > 40) {
                            this.func_82338_g((float)(50 - this.field_70546_d) / 10.0f);
                        }
                    }

                    public int func_70537_b() {
                        return 1;
                    }
                });
            }
        }
    }

    public static class ComponentSequencerLogic
    extends ComponentProcess
    implements IProcess {
        public ComponentSequencerLogic(Machine machine) {
            super(machine);
        }

        public float getSequenceStrength() {
            ItemStack stack = this.getUtil().getStack(5);
            if (stack == null) {
                return 1.0f;
            }
            float mult = 1.0f - (float)(stack.func_77960_j() % 6) / 5.0f;
            return 1.0f - mult * mult * 0.75f;
        }

        @Override
        public int getProcessLength() {
            return (int)(19200.0f * this.getSequenceStrength());
        }

        @Override
        public int getProcessEnergy() {
            return this.getProcessLength() * 20;
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(5)) {
                return new ErrorState.NoItem("No DNA sequence", 5);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (this.getMachine().getOwner() == null) {
                return new ErrorState("No Owner", "Replace this block to claim this machine");
            }
            if (this.getUtil().getSlotCharge(0) == 0.0f) {
                return new ErrorState.NoItem("Insufficient Dye", 0);
            }
            if (this.getUtil().getStack(6) != null && this.getUtil().getStack((int)6).field_77994_a >= 64) {
                return new ErrorState.NoSpace("No space for empty sequences", new int[]{6});
            }
            return super.canProgress();
        }

        @Override
        protected void onStartTask() {
            super.onStartTask();
            ItemStack item = this.getUtil().getStack(5);
            SequencerItem seqItem = new SequencerItem(item);
            int seq = seqItem.sequenced;
            if (seq != 0) {
                this.setProgress(seq);
            }
        }

        @Override
        protected void onFinishTask() {
            super.onFinishTask();
            this.updateSequence();
            SequencerItem seqItem = new SequencerItem(this.getUtil().getStack(5));
            GeneTracker.getTracker(this.getMachine().getWorld(), this.getMachine().getOwner()).registerGene(seqItem.getGene());
            this.getUtil().decreaseStack(5, 1);
            if (this.getUtil().getStack(6) == null) {
                this.getUtil().setStack(6, GeneticsItems.EmptySequencer.get(1));
            } else {
                this.getUtil().decreaseStack(6, -1);
            }
        }

        @Override
        protected void onTickTask() {
            this.updateSequence();
            this.getUtil().useCharge(0, 0.4f * this.getProgressPerTick() / 100.0f);
        }

        private void updateSequence() {
            int prog = (int)this.getProgress();
            ItemStack item = this.getUtil().getStack(5);
            SequencerItem seqItem = new SequencerItem(item);
            int seq = seqItem.sequenced;
            if (prog != seq) {
                seqItem.sequenced = prog;
                seqItem.writeToItem(item);
            }
        }
    }

    public static class PackageSequencer
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackageSequencer() {
            super("sequencer", GeneticsTexture.Sequencer, 12058418, true);
            fxSeqA = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.a");
            fxSeqG = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.g");
            fxSeqT = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.t");
            fxSeqC = Binnie.Resource.getBlockIcon(Genetics.instance, "fx/sequencer.c");
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Sequencer);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(0, "dye");
            inventory.getSlot(0).setValidator((Validator)new SlotValidator.Item(GeneticsItems.FluorescentDye.get(1), ModuleMachine.IconDye));
            inventory.getSlot(0).forbidExtraction();
            inventory.addSlotArray(slotReserve, "input");
            for (InventorySlot slot : inventory.getSlots(slotReserve)) {
                slot.setValidator((Validator)new SlotValidatorUnsequenced());
                slot.forbidExtraction();
            }
            inventory.addSlot(5, "process");
            inventory.getSlot(5).setValidator((Validator)new SlotValidatorUnsequenced());
            inventory.getSlot(5).setReadOnly();
            inventory.getSlot(5).forbidInteraction();
            inventory.addSlot(6, "output");
            inventory.getSlot(6).setReadOnly();
            ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
            transfer.addRestock(slotReserve, 5, 1);
            new ComponentChargedSlots(machine).addCharge(0);
            new ComponentPowerReceptor(machine, 10000);
            new ComponentSequencerLogic(machine);
            new ComponentSequencerFX(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

