/*
 * Decompiled with CFR 0.152.
 */
package com.jadarstudios.developercapes.user;

import com.jadarstudios.developercapes.DevCapes;
import com.jadarstudios.developercapes.cape.CapeManager;
import com.jadarstudios.developercapes.user.Group;
import com.jadarstudios.developercapes.user.User;
import com.jadarstudios.developercapes.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public enum GroupManager {
    INSTANCE;

    private HashMap<String, Group> groups = new HashMap();

    public void addGroup(Group group) {
        this.groups.put(group.name, group);
        try {
            UserManager.INSTANCE.addUsers(new HashSet<User>(group.users.values()));
            CapeManager.INSTANCE.addCape(group.cape);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Group getGroup(String capeName) {
        return this.groups.get(capeName);
    }

    public Group newInstance(String name) {
        if (this.getGroup(name) != null) {
            return this.getGroup(name);
        }
        Group group = new Group(name);
        return group;
    }

    public Group parse(String name, Map<String, Object> data) {
        Group group = new Group(name);
        Object usersObj = data.get("users");
        Object capeUrlObj = data.get("capeUrl");
        if (!(usersObj instanceof ArrayList) || !(capeUrlObj instanceof String)) {
            DevCapes.logger.error(String.format("Group %s could not be parsed because it either is invalid or missing elements.", name));
            return null;
        }
        ArrayList users = (ArrayList)usersObj;
        String capeUrl = (String)capeUrlObj;
        group.cape = CapeManager.INSTANCE.parse(name, capeUrl);
        for (Object obj : users) {
            User user = UserManager.INSTANCE.parse(obj, group.cape);
            if (user == null) continue;
            group.addUser(user);
        }
        return group;
    }
}

