/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import ic2.api.item.IC2Items;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.core.Ic2Items;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.items.ItemSensorKitBase;
import shedar.mods.ic2.nuclearcontrol.utils.ItemStackUtils;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearHelper;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

public class ItemKitReactorSensor
extends ItemSensorKitBase {
    public ItemKitReactorSensor() {
        super("kitReactor");
    }

    @Override
    protected ChunkCoordinates getTargetCoordinates(World world, int x, int y, int z, ItemStack stack) {
        IReactorChamber chamber;
        IReactor reactor = NuclearHelper.getReactorAt(world, x, y, z);
        if (reactor == null && (chamber = NuclearHelper.getReactorChamberAt(world, x, y, z)) != null) {
            reactor = chamber.getReactor();
        }
        if (reactor != null) {
            return reactor.getPosition();
        }
        return null;
    }

    @Override
    protected ItemStack getItemStackByDamage(int cardID) {
        if (cardID == 0) {
            return new ItemStack(IC2NuclearControl.itemSensorLocationCard, 1, 0);
        }
        if (cardID == 1) {
            return new ItemStack(IC2NuclearControl.item55ReactorCard, 1, 0);
        }
        return null;
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block check;
        if (player == null) {
            return false;
        }
        boolean isServer = player instanceof EntityPlayerMP;
        if (!isServer) {
            return false;
        }
        ChunkCoordinates position = this.getTargetCoordinates(world, x, y, z, stack);
        int sendInt = 0;
        if (position != null) {
            ItemStack sensorLocationCard = this.getItemStackByDamage(sendInt);
            this.setCoordinates(sensorLocationCard, position.field_71574_a, position.field_71572_b, position.field_71573_c);
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = sensorLocationCard;
            if (!world.field_72995_K) {
                NuclearNetworkHelper.chatMessage(player, "SensorKit");
            }
            return true;
        }
        if (position == null && ((check = world.func_147439_a(x, y, z)) == Block.func_149634_a((Item)IC2Items.getItem((String)"reactorRedstonePort").func_77973_b()) || check == Block.func_149634_a((Item)Ic2Items.reactorvessel.func_77973_b()) || check == Block.func_149634_a((Item)Ic2Items.reactorAccessHatch.func_77973_b()) || check == Block.func_149634_a((Item)Ic2Items.reactorFluidPort.func_77973_b()))) {
            sendInt = 1;
            ItemStack sensorLocationCard = this.getItemStackByDamage(sendInt);
            this.setCoordinates(sensorLocationCard, x, y, z);
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = sensorLocationCard;
            if (!world.field_72995_K) {
                NuclearNetworkHelper.chatMessage(player, "SensorKit");
            }
            return true;
        }
        return false;
    }

    private void setCoordinates(ItemStack itemStack, int x, int y, int z) {
        NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(itemStack);
        nbtTagCompound.func_74768_a("x", x);
        nbtTagCompound.func_74768_a("y", y);
        nbtTagCompound.func_74768_a("z", z);
    }
}

