/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.FTBLib;
import ftb.lib.TextureCoords;
import ftb.lib.api.PlayerAction;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.friends.ILMPlayer;
import ftb.lib.api.gui.GuiIcons;
import ftb.lib.api.gui.GuiScreenRegistry;
import ftb.lib.api.gui.PlayerActionRegistry;
import ftb.utils.mod.client.gui.claims.GuiClaimChunks;
import ftb.utils.mod.client.gui.friends.GuideFriendsGUI;
import ftb.utils.mod.client.gui.guide.GuiGuide;
import ftb.utils.net.ClientAction;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class FTBUActions {
    public static final PlayerAction friends_gui = new PlayerAction(PlayerAction.Type.SELF, "ftbu.friends_gui", 950, TextureCoords.getSquareIcon((ResourceLocation)new ResourceLocation("ftbu", "textures/gui/friendsbutton.png"), (int)256)){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
            FTBLibClient.openGui((GuiScreen)new GuiGuide(null, new GuideFriendsGUI()));
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLibClient.isIngameWithFTBU();
        }

        public String getDisplayName() {
            return "FriendsGUI";
        }
    };
    public static final PlayerAction guide = new PlayerAction(PlayerAction.Type.SELF, "ftbu.guide", 0, GuiIcons.book){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
            FTBLibClient.playClickSound();
            GuiGuide.openClientGui(true);
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLibClient.isIngameWithFTBU();
        }

        public Boolean configDefault() {
            return Boolean.TRUE;
        }
    };
    public static final PlayerAction info = new PlayerAction(PlayerAction.Type.SELF, "ftbu.server_info", 0, GuiIcons.book_red){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
            ClientAction.REQUEST_SERVER_INFO.send(0);
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLibClient.isIngameWithFTBU();
        }

        public Boolean configDefault() {
            return Boolean.TRUE;
        }
    };
    public static final PlayerAction claims = new PlayerAction(PlayerAction.Type.SELF, "ftbu.claimed_chunks", 0, GuiIcons.map){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
            FTBLibClient.openGui((GuiScreen)new GuiClaimChunks(0L));
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLibClient.isIngameWithFTBU();
        }

        public Boolean configDefault() {
            return Boolean.TRUE;
        }
    };
    public static final PlayerAction trade = new PlayerAction(PlayerAction.Type.SELF, "ftbu.trade", 0, GuiIcons.money_bag){

        public void onClicked(ILMPlayer owner, ILMPlayer player) {
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLib.DEV_ENV;
        }

        public Boolean configDefault() {
            return Boolean.TRUE;
        }
    };
    public static final PlayerAction friend_add = new PlayerAction(PlayerAction.Type.OTHER, "ftbu.add_friend", 1, GuiIcons.add){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
            ClientAction.ADD_FRIEND.send(other.getPlayerID());
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLibClient.isIngameWithFTBU() && !self.isFriendRaw(other);
        }
    };
    public static final PlayerAction friend_remove = new PlayerAction(PlayerAction.Type.OTHER, "ftbu.rem_friend", -1, GuiIcons.remove){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
            ClientAction.REM_FRIEND.send(other.getPlayerID());
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLibClient.isIngameWithFTBU() && self.isFriendRaw(other);
        }
    };
    public static final PlayerAction friend_deny = new PlayerAction(PlayerAction.Type.OTHER, "ftbu.deny_friend", -1, GuiIcons.remove){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
            ClientAction.DENY_FRIEND.send(other.getPlayerID());
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLibClient.isIngameWithFTBU() && !self.isFriendRaw(other) && other.isFriendRaw(self);
        }
    };
    public static final PlayerAction mail = new PlayerAction(PlayerAction.Type.OTHER, "ftbu.mail", 0, GuiIcons.feather){

        public void onClicked(ILMPlayer self, ILMPlayer other) {
        }

        public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
            return FTBLib.DEV_ENV;
        }
    };

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        PlayerActionRegistry.add((PlayerAction)friends_gui);
        PlayerActionRegistry.add((PlayerAction)guide);
        PlayerActionRegistry.add((PlayerAction)info);
        PlayerActionRegistry.add((PlayerAction)claims);
        PlayerActionRegistry.add((PlayerAction)friend_add);
        PlayerActionRegistry.add((PlayerAction)friend_remove);
        PlayerActionRegistry.add((PlayerAction)friend_deny);
        if (FTBLib.DEV_ENV) {
            PlayerActionRegistry.add((PlayerAction)mail);
            PlayerActionRegistry.add((PlayerAction)trade);
        }
        GuiScreenRegistry.register((String)"friends_gui", (GuiScreenRegistry.Entry)new GuiScreenRegistry.Entry(){

            public GuiScreen openGui(EntityPlayer ep) {
                return new GuiGuide(null, new GuideFriendsGUI());
            }
        });
        GuiScreenRegistry.register((String)"claimed_chunks", (GuiScreenRegistry.Entry)new GuiScreenRegistry.Entry(){

            public GuiScreen openGui(EntityPlayer ep) {
                return new GuiClaimChunks(0L);
            }
        });
        GuiScreenRegistry.register((String)"guide", (GuiScreenRegistry.Entry)new GuiScreenRegistry.Entry(){

            public GuiScreen openGui(EntityPlayer ep) {
                return GuiGuide.openClientGui(false);
            }
        });
        GuiScreenRegistry.register((String)"server_info", (GuiScreenRegistry.Entry)new GuiScreenRegistry.Entry(){

            public GuiScreen openGui(EntityPlayer ep) {
                ClientAction.REQUEST_SERVER_INFO.send(0);
                return null;
            }
        });
    }
}

