/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.cmd;

import ftb.lib.FTBLib;
import ftb.lib.PrivacyLevel;
import ftb.lib.api.cmd.CommandLM;
import ftb.lib.api.cmd.CommandLevel;
import ftb.lib.api.cmd.CommandSubLM;
import ftb.utils.world.LMPlayerServer;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.IChatComponent;

public class CmdLMPlayerSettings
extends CommandSubLM {
    public CmdLMPlayerSettings() {
        super("lmplayer_settings", CommandLevel.ALL);
        this.add(new CmdSettingBool("chat_links", 0));
        this.add(new CmdSettingBool("explosions", 1));
        this.add(new CmdSettingBool("fake_players", 2));
        this.add(new CmdBlockSecurity("block_security"));
        this.add(new CmdRenderBadge("render_badge"));
    }

    public static class CmdRenderBadge
    extends CommandLM {
        public CmdRenderBadge(String s) {
            super(s, CommandLevel.ALL);
        }

        public String[] getTabStrings(ICommandSender ics, String[] args, int i) throws CommandException {
            if (i == 0) {
                return new String[]{"true", "false"};
            }
            return null;
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            boolean b;
            CmdRenderBadge.checkArgs((String[])args, (int)1);
            LMPlayerServer p = LMPlayerServer.get(ics);
            p.renderBadge = b = args[0].equals("toggle") ? !p.renderBadge : CmdRenderBadge.func_110662_c((ICommandSender)ics, (String)args[0]);
            p.sendUpdate();
            if (!args[0].equals("toggle")) {
                FTBLib.printChat((ICommandSender)ics, (Object)(this.commandName + " set to " + b));
            }
            return null;
        }
    }

    public static class CmdBlockSecurity
    extends CommandLM {
        public CmdBlockSecurity(String s) {
            super(s, CommandLevel.ALL);
        }

        public String[] getTabStrings(ICommandSender ics, String[] args, int i) throws CommandException {
            if (i == 0) {
                return PrivacyLevel.getNames();
            }
            return null;
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdBlockSecurity.checkArgs((String[])args, (int)1);
            LMPlayerServer p = LMPlayerServer.get(ics);
            if (args[0].equals("toggle")) {
                p.getSettings().blocks = PrivacyLevel.VALUES_3[(p.getSettings().blocks.ID + 1) % 3];
                p.sendUpdate();
                return null;
            }
            PrivacyLevel l = PrivacyLevel.get((String)args[0]);
            if (l != null) {
                p.getSettings().blocks = l;
                FTBLib.printChat((ICommandSender)ics, (Object)(this.commandName + " set to " + l.name().toLowerCase()));
            }
            return null;
        }
    }

    public static class CmdSettingBool
    extends CommandLM {
        public final byte flag;

        public CmdSettingBool(String s, byte f) {
            super(s, CommandLevel.ALL);
            this.flag = f;
        }

        public String[] getTabStrings(ICommandSender ics, String[] args, int i) throws CommandException {
            if (i == 0) {
                return new String[]{"true", "false"};
            }
            return null;
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdSettingBool.checkArgs((String[])args, (int)1);
            LMPlayerServer p = LMPlayerServer.get(ics);
            boolean b = args[0].equals("toggle") ? !p.getSettings().get(this.flag) : CmdSettingBool.func_110662_c((ICommandSender)ics, (String)args[0]);
            p.getSettings().set(this.flag, b);
            p.sendUpdate();
            if (!args[0].equals("toggle")) {
                FTBLib.printChat((ICommandSender)ics, (Object)(this.commandName + " set to " + b));
            }
            return null;
        }
    }
}

