/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world.claims;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ftb.lib.api.config.ConfigEntryBool;
import ftb.utils.world.LMWorld;
import ftb.utils.world.claims.WorldBorder;
import java.util.HashMap;
import latmod.lib.ByteIOStream;

public class LMWorldSettings {
    public final LMWorld world;
    public final ConfigEntryBool border_enabled;
    public final WorldBorder worldBorder0;
    public final HashMap<Integer, WorldBorder> worldBorder;

    public LMWorldSettings(LMWorld w) {
        this.world = w;
        this.border_enabled = new ConfigEntryBool("border_enabled", false);
        this.worldBorder0 = new WorldBorder(this, 0);
        this.worldBorder0.size = 0;
        this.worldBorder = new HashMap();
    }

    public void readFromJson(JsonObject group) {
        this.border_enabled.func_152753_a(group.get(this.border_enabled.getID()));
        this.worldBorder.clear();
        this.worldBorder0.size = 0;
        JsonArray a = group.get("world_border").getAsJsonArray();
        for (int i = 0; i < a.size(); ++i) {
            WorldBorder wb = WorldBorder.fromJson(this, a.get(i));
            if (wb.dim == 0) {
                this.worldBorder0.pos.x = wb.pos.x;
                this.worldBorder0.pos.y = wb.pos.y;
                this.worldBorder0.size = wb.size;
                continue;
            }
            this.worldBorder.put(wb.dim, wb);
        }
    }

    public void writeToJson(JsonObject group) {
        group.add(this.border_enabled.getID(), this.border_enabled.func_151003_a());
        JsonArray a = new JsonArray();
        a.add(this.worldBorder0.toJson());
        for (WorldBorder wb : this.worldBorder.values()) {
            if (wb.size == 0 && wb.pos.x == 0 && wb.pos.y == 0) continue;
            a.add(wb.toJson());
        }
        group.add("world_border", (JsonElement)a);
    }

    public void readFromNet(ByteIOStream io) {
        this.border_enabled.set(io.readBoolean());
        if (!this.border_enabled.get()) {
            return;
        }
        this.worldBorder0.pos.x = io.readInt();
        this.worldBorder0.pos.y = io.readInt();
        this.worldBorder0.size = io.readInt();
        int s = io.readInt();
        this.worldBorder.clear();
        for (int i = 0; i < s; ++i) {
            WorldBorder wb = new WorldBorder(this, io.readInt());
            wb.pos.x = io.readInt();
            wb.pos.y = io.readInt();
            wb.size = io.readInt();
            this.worldBorder.put(wb.dim, wb);
        }
    }

    public void writeToNet(ByteIOStream io) {
        io.writeBoolean(this.border_enabled.get());
        if (!this.border_enabled.get()) {
            return;
        }
        io.writeInt(this.worldBorder0.pos.x);
        io.writeInt(this.worldBorder0.pos.y);
        io.writeInt(this.worldBorder0.size);
        io.writeInt(this.worldBorder.size());
        for (WorldBorder wb : this.worldBorder.values()) {
            io.writeInt(wb.dim);
            io.writeInt(wb.pos.x);
            io.writeInt(wb.pos.y);
            io.writeInt(wb.size);
        }
    }

    public WorldBorder getWB(int dim) {
        if (dim == 0) {
            return this.worldBorder0;
        }
        WorldBorder wb = this.worldBorder.get(dim);
        if (wb == null) {
            wb = new WorldBorder(this, dim);
            wb.size = this.worldBorder0.size;
        }
        return wb;
    }

    public WorldBorder getAndSet(int dim) {
        if (dim == 0) {
            return this.worldBorder0;
        }
        WorldBorder wb = this.worldBorder.get(dim);
        if (wb == null) {
            wb = new WorldBorder(this, dim);
            this.worldBorder.put(dim, wb);
        }
        return wb;
    }
}

