/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.bag;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.SaveHelper;
import hardcorequesting.Translator;
import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.Group;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiEditMenuTier;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.QuestLine;
import java.util.Arrays;
import java.util.List;

public class GroupTier {
    private String name;
    private GuiColor color;
    private int[] weights;

    public GroupTier(String name, GuiColor color, int ... weights) {
        this.name = name;
        this.color = color;
        this.weights = Arrays.copyOf(weights, weights.length);
    }

    public String getName() {
        return this.name == null || this.name.equals("") ? Translator.translate("hqm.bag.unknown") : this.name;
    }

    public GuiColor getColor() {
        return this.color;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public static List<GroupTier> getTiers() {
        return QuestLine.getActiveQuestLine().tiers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GroupTier copy() {
        return new GroupTier(this.getName(), this.getColor(), this.getWeights());
    }

    public void load(GroupTier tier) {
        this.name = tier.name;
        this.color = tier.color;
        this.weights = Arrays.copyOf(this.weights, this.weights.length);
    }

    public void setColor(GuiColor color) {
        this.color = color;
    }

    public static void saveAll(DataWriter dw) {
        dw.writeData(QuestLine.getActiveQuestLine().tiers.size(), DataBitHelper.TIER_COUNT);
        for (GroupTier tier : QuestLine.getActiveQuestLine().tiers) {
            dw.writeString(tier.getName(), DataBitHelper.QUEST_NAME_LENGTH);
            dw.writeData(tier.getColor().ordinal(), DataBitHelper.COLOR);
            for (int weight : tier.weights) {
                dw.writeData(weight, DataBitHelper.WEIGHT);
            }
        }
    }

    public static void readAll(DataReader dr, FileVersion version) {
        QuestLine.getActiveQuestLine().tiers.clear();
        int count = dr.readData(DataBitHelper.TIER_COUNT);
        for (int i = 0; i < count; ++i) {
            String name = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
            GuiColor color = GuiColor.values()[dr.readData(DataBitHelper.COLOR)];
            int[] weights = new int[BagTier.values().length];
            for (int j = 0; j < weights.length; ++j) {
                weights[j] = dr.readData(DataBitHelper.WEIGHT);
            }
            QuestLine.getActiveQuestLine().tiers.add(new GroupTier(name, color, weights));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar tierScroll, int x, int y) {
        int start;
        List<GroupTier> tiers = GroupTier.getTiers();
        block6: for (int i = start = tierScroll.isVisible(gui) ? Math.round((float)(tiers.size() - 8) * tierScroll.getScroll()) : 0; i < Math.min(start + 8, tiers.size()); ++i) {
            int posY = 20 + 25 * (i - start);
            GroupTier groupTier = tiers.get(i);
            if (!gui.inBounds(180, posY, gui.getStringWidth(groupTier.getName()), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case TIER: {
                    if (gui.modifyingGroup == null) break block6;
                    gui.modifyingGroup.setTier(groupTier);
                    SaveHelper.add(SaveHelper.EditType.GROUP_CHANGE);
                    break;
                }
                case NORMAL: {
                    gui.setEditMenu(new GuiEditMenuTier(gui, gui.getPlayer(), groupTier));
                    break;
                }
                case RENAME: {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), groupTier));
                    break;
                }
                case DELETE: {
                    if (tiers.size() <= 1 && Group.getGroups().size() != 0) break block6;
                    for (Group group : Group.getGroups()) {
                        if (group.getTier() != groupTier) continue;
                        group.setTier(i == 0 ? tiers.get(1) : tiers.get(0));
                    }
                    tiers.remove(i);
                    SaveHelper.add(SaveHelper.EditType.TIER_REMOVE);
                    break;
                }
            }
            break;
        }
    }
}

