/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.TransposerManager;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Transposer")
public class Transposer {
    public static final String nameFill = "Thermal Expansion Transposer (Fill)";
    public static final String nameExtract = "Thermal Expansion Transposer (Extract)";

    @ZenMethod
    public static void addFillRecipe(int energy, IItemStack input, IItemStack output, ILiquidStack liquid) {
        if (input == null || output == null || liquid == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", nameFill));
            return;
        }
        if (TransposerManager.fillRecipeExists((ItemStack)InputHelper.toStack(input), (FluidStack)InputHelper.toFluid(liquid))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s and %s. Command ignored!", nameFill, LogHelper.getStackDescription(InputHelper.toStack(input)), LogHelper.getStackDescription(InputHelper.toFluid(liquid))));
            return;
        }
        TransposerManager.RecipeTransposer recipe = ReflectionHelper.getInstance(ThermalHelper.transposerRecipe, InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toFluid(liquid), energy, 100);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe, RecipeType.Fill));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", nameFill));
        }
    }

    @ZenMethod
    public static void addExtractRecipe(int energy, IItemStack input, ILiquidStack liquid, @Optional IItemStack output, @Optional int chance) {
        if (input == null || output == null || liquid == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", nameExtract));
            return;
        }
        if (TransposerManager.extractionRecipeExists((ItemStack)InputHelper.toStack(input), (FluidStack)InputHelper.toFluid(liquid))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s and %s. Command ignored!", nameExtract, LogHelper.getStackDescription(InputHelper.toStack(input)), LogHelper.getStackDescription(InputHelper.toFluid(liquid))));
            return;
        }
        TransposerManager.RecipeTransposer recipe = ReflectionHelper.getInstance(ThermalHelper.transposerRecipe, InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toFluid(liquid), energy, 100);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe, RecipeType.Extract));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", nameExtract));
        }
    }

    @ZenMethod
    public static void addExtractRecipe(int energy, IItemStack input, IItemStack output, ILiquidStack liquid, int chance) {
        if (input == null || output == null || liquid == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", nameExtract));
            return;
        }
        if (TransposerManager.extractionRecipeExists((ItemStack)InputHelper.toStack(input), (FluidStack)InputHelper.toFluid(liquid))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s and %s. Command ignored!", nameExtract, LogHelper.getStackDescription(InputHelper.toStack(input)), LogHelper.getStackDescription(InputHelper.toFluid(liquid))));
            return;
        }
        TransposerManager.RecipeTransposer recipe = ReflectionHelper.getInstance(ThermalHelper.transposerRecipe, InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toFluid(liquid), energy, 100);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe, RecipeType.Extract));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", nameExtract));
        }
    }

    @ZenMethod
    public static void removeFillRecipe(IIngredient input, IIngredient liquid) {
        Transposer.removeRecipe(input, liquid, RecipeType.Fill);
    }

    @ZenMethod
    public static void removeExtractRecipe(IIngredient input) {
        Transposer.removeRecipe(input, (IIngredient)IngredientAny.INSTANCE, RecipeType.Extract);
    }

    public static void removeRecipe(IIngredient input, IIngredient liquid, RecipeType type) {
        LinkedList<TransposerManager.RecipeTransposer> recipes = new LinkedList<TransposerManager.RecipeTransposer>();
        for (TransposerManager.RecipeTransposer recipe : type == RecipeType.Fill ? TransposerManager.getFillRecipeList() : TransposerManager.getExtractionRecipeList()) {
            if (recipe == null || !StackHelper.matches(input, InputHelper.toIItemStack(recipe.getInput())) || !StackHelper.matches(liquid, InputHelper.toILiquidStack(recipe.getFluid()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes, type));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s and %s.", type == RecipeType.Fill ? nameFill : nameExtract, input.toString(), liquid.toString()));
        }
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            TransposerManager.refreshRecipes();
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Refreshing Thermal Expansion Transposer (Fill) & Thermal Expansion Transposer (Extract) recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Ignoring undo of Thermal Expansion Transposer (Fill) & Thermal Expansion Transposer (Extract) recipe refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    protected static enum RecipeType {
        Fill,
        Extract;

    }

    private static class Remove
    extends BaseListRemoval<TransposerManager.RecipeTransposer> {
        private RecipeType type;

        protected Remove(List<TransposerManager.RecipeTransposer> recipes, RecipeType type) {
            super(type == RecipeType.Fill ? Transposer.nameFill : Transposer.nameExtract, null, recipes);
            this.type = type;
        }

        @Override
        public void apply() {
            for (TransposerManager.RecipeTransposer recipe : this.recipes) {
                boolean removed = false;
                switch (this.type) {
                    case Fill: {
                        removed = TransposerManager.removeFillRecipe((ItemStack)recipe.getInput(), (FluidStack)recipe.getFluid());
                        break;
                    }
                    case Extract: {
                        removed = TransposerManager.removeExtractionRecipe((ItemStack)recipe.getInput());
                    }
                }
                if (!removed) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (TransposerManager.RecipeTransposer recipe : this.successful) {
                switch (this.type) {
                    case Fill: {
                        TransposerManager.addFillRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getOutput(), (FluidStack)recipe.getFluid(), (boolean)false);
                        break;
                    }
                    case Extract: {
                        TransposerManager.addExtractionRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getOutput(), (FluidStack)recipe.getFluid(), (int)recipe.getChance(), (boolean)false);
                    }
                }
            }
        }

        @Override
        protected boolean equals(TransposerManager.RecipeTransposer recipe, TransposerManager.RecipeTransposer otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(TransposerManager.RecipeTransposer recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<TransposerManager.RecipeTransposer> {
        private RecipeType type;

        protected Add(TransposerManager.RecipeTransposer recipe, RecipeType type) {
            super(type == RecipeType.Fill ? Transposer.nameFill : Transposer.nameExtract, null);
            this.type = type;
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (TransposerManager.RecipeTransposer recipe : this.recipes) {
                boolean applied = false;
                switch (this.type) {
                    case Fill: {
                        applied = TransposerManager.addFillRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getOutput(), (FluidStack)recipe.getFluid(), (boolean)false);
                        break;
                    }
                    case Extract: {
                        applied = TransposerManager.addExtractionRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getOutput(), (FluidStack)recipe.getFluid(), (int)recipe.getChance(), (boolean)false);
                    }
                }
                if (!applied) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (TransposerManager.RecipeTransposer recipe : this.successful) {
                switch (this.type) {
                    case Fill: {
                        TransposerManager.removeFillRecipe((ItemStack)recipe.getInput(), (FluidStack)recipe.getFluid());
                        break;
                    }
                    case Extract: {
                        TransposerManager.removeExtractionRecipe((ItemStack)recipe.getInput());
                    }
                }
            }
        }

        @Override
        protected boolean equals(TransposerManager.RecipeTransposer recipe, TransposerManager.RecipeTransposer otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(TransposerManager.RecipeTransposer recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

