/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.transport;

import cofh.lib.network.ByteBufHelper;
import cofh.lib.transport.IEnderChannelRegistry;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ServerEnderChannelRegistry
implements IEnderChannelRegistry {
    protected Configuration linkConf;
    protected HashMap<String, TIntObjectHashMap<String>> channels = new HashMap();
    private int modCount;

    public ServerEnderChannelRegistry(Configuration config) {
        this.linkConf = config;
        this.load();
    }

    protected void load() {
        ++this.modCount;
        for (String channel : this.linkConf.getCategoryNames()) {
            ConfigCategory category = this.linkConf.getCategory(channel);
            TIntObjectHashMap map = this.channels.get(channel);
            if (map == null) {
                map = new TIntObjectHashMap();
                this.channels.put(channel, (TIntObjectHashMap<String>)map);
            }
            for (Property prop : category.values()) {
                try {
                    int freq = Integer.parseInt(prop.getName());
                    map.put(freq, (Object)prop.getString());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void save() {
        if (this.linkConf.hasChanged()) {
            this.linkConf.save();
        }
    }

    public ByteBuf getFrequencyData(String channel) {
        TIntObjectHashMap<String> map = this.channels.get(channel);
        ByteBuf ret = Unpooled.directBuffer();
        if (map != null) {
            TIntObjectIterator iter = map.iterator();
            ByteBufHelper.writeVarInt(map.size(), ret);
            ByteBufHelper.writeString(channel, ret);
            while (iter.hasNext()) {
                iter.advance();
                ByteBufHelper.writeVarInt(iter.key(), ret);
                ByteBufHelper.writeString((String)iter.value(), ret);
            }
        } else {
            ByteBufHelper.writeVarInt(0, ret);
            ByteBufHelper.writeString(channel, ret);
        }
        return ret;
    }

    @Override
    public List<IEnderChannelRegistry.Frequency> getFrequencyList(String channel) {
        LinkedList<IEnderChannelRegistry.Frequency> ret = new LinkedList<IEnderChannelRegistry.Frequency>();
        TIntObjectHashMap<String> map = this.channels.get(channel);
        if (map != null) {
            TIntObjectIterator iter = map.iterator();
            while (iter.hasNext()) {
                iter.advance();
                ret.add(new IEnderChannelRegistry.Frequency(iter.key(), (String)iter.value()));
            }
        }
        return ret;
    }

    @Override
    public String getFrequency(String channel, int freq) {
        TIntObjectHashMap<String> map = this.channels.get(channel);
        if (map != null) {
            return (String)map.get(freq);
        }
        return null;
    }

    @Override
    public String setFrequency(String channel, int freq, String name) {
        TIntObjectHashMap map = this.channels.get(channel);
        if (map == null) {
            map = new TIntObjectHashMap();
            this.channels.put(channel, (TIntObjectHashMap<String>)map);
        }
        String old = (String)map.put(freq, (Object)name);
        ++this.modCount;
        this.linkConf.get(channel, String.valueOf(freq), "").set(name);
        return old;
    }

    @Override
    public String removeFrequency(String channel, int freq) {
        TIntObjectHashMap<String> map = this.channels.get(channel);
        if (map == null) {
            return null;
        }
        String old = (String)map.remove(freq);
        if (old != null) {
            ++this.modCount;
            this.linkConf.getCategory(channel).remove((Object)String.valueOf(freq));
        }
        return old;
    }

    @Override
    public int updated() {
        return this.modCount;
    }
}

