/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;

public class SecurityHelper {
    private static boolean setup = false;
    private static UUID cachedId;

    public static void setup() {
        if (setup) {
            return;
        }
        EnumConnectionState.PLAY.func_150755_b().put((Object)-26, Login.S__PacketSendUUID.class);
        Map data = (Map)ReflectionHelper.getPrivateValue(EnumConnectionState.class, null, (String[])new String[]{"field_150761_f"});
        data.put(Login.S__PacketSendUUID.class, EnumConnectionState.PLAY);
        FMLCommonHandler.instance().bus().register((Object)new Login.S__PacketSendUUID());
        setup = true;
    }

    private SecurityHelper() {
    }

    public static boolean isDefaultUUID(UUID uuid) {
        return uuid == null || uuid.version() == 4 && uuid.variant() == 0;
    }

    public static UUID getID(EntityPlayer player) {
        if (MinecraftServer.func_71276_C() != null) {
            return player.func_146103_bH().getId();
        }
        return SecurityHelper.getClientId(player);
    }

    private static UUID getClientId(EntityPlayer player) {
        if (player != Minecraft.func_71410_x().field_71439_g) {
            return player.func_146103_bH().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId();
        }
        return cachedId;
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound tag, ISecurable tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74757_a("Secure", true);
        tag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
        tag.func_74778_a("OwnerUUID", tile.getOwner().getId().toString());
        tag.func_74778_a("Owner", tile.getOwner().getName());
        return tag;
    }

    public static void addOwnerInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            boolean hasUUID = stack.field_77990_d.func_74764_b("OwnerUUID");
            if (!stack.field_77990_d.func_74764_b("Owner") && !hasUUID) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else if (hasUUID && stack.field_77990_d.func_74764_b("Owner")) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + stack.field_77990_d.func_74779_i("Owner"));
            } else {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.anotherplayer"));
            }
        }
    }

    public static void addAccessInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            String accessString = "";
            switch (stack.field_77990_d.func_74771_c("Access")) {
                case 0: {
                    accessString = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case 1: {
                    accessString = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case 2: {
                    accessString = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            list.add(StringHelper.localize("info.cofh.access") + ": " + accessString);
        }
    }

    public static boolean isSecure(ItemStack stack) {
        return stack.field_77990_d == null ? false : stack.field_77990_d.func_74764_b("Secure");
    }

    public static ItemStack setSecure(ItemStack stack) {
        if (SecurityHelper.isSecure(stack)) {
            return stack;
        }
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a("Secure", true);
        stack.field_77990_d.func_74774_a("Access", (byte)0);
        return stack;
    }

    public static boolean setAccess(ItemStack stack, ISecurable.AccessMode access) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.field_77990_d.func_74774_a("Access", (byte)access.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack stack) {
        return stack.field_77990_d == null ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[stack.field_77990_d.func_74771_c("Access")];
    }

    public static boolean setOwner(ItemStack stack, GameProfile name) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.func_77983_a("OwnerUUID", (NBTBase)new NBTTagString(name.getId().toString()));
        stack.func_77983_a("Owner", (NBTBase)new NBTTagString(name.getName()));
        return true;
    }

    public static GameProfile getOwner(ItemStack stack) {
        if (stack.field_77990_d != null) {
            NBTTagCompound nbt = stack.field_77990_d;
            String uuid = nbt.func_74779_i("OwnerUUID");
            String name = nbt.func_74779_i("Owner");
            if (!Strings.isNullOrEmpty((String)uuid)) {
                return new GameProfile(UUID.fromString(uuid), name);
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                return new GameProfile(UUID.fromString(PreYggdrasilConverter.func_152719_a((String)name)), name);
            }
        }
        return new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    }

    public static GameProfile getProfile(UUID uuid, String name) {
        GameProfile owner = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(uuid);
        if (owner == null) {
            GameProfile temp = new GameProfile(uuid, name);
            owner = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(temp, true);
            if (owner != temp) {
                MinecraftServer.func_71276_C().func_152358_ax().func_152649_a(owner);
            }
        }
        return owner;
    }

    @Deprecated
    public static boolean setOwnerName(ItemStack stack, String name) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.field_77990_d.func_74778_a("Owner", name);
        return true;
    }

    public static String getOwnerName(ItemStack stack) {
        boolean hasUUID;
        NBTTagCompound nbt = stack.field_77990_d;
        if (nbt == null || !(hasUUID = nbt.func_74764_b("OwnerUUID")) && !nbt.func_74764_b("Owner")) {
            return "[None]";
        }
        return hasUUID ? stack.field_77990_d.func_74779_i("Owner") : StringHelper.localize("info.cofh.anotherplayer");
    }

    static {
        SecurityHelper.setup();
    }

    private static class Login {
        private Login() {
        }

        public static class S__PacketSendUUID
        extends Packet {
            private UUID id;

            @SubscribeEvent
            public void login(PlayerEvent.PlayerLoggedInEvent evt) {
                ((EntityPlayerMP)evt.player).field_71135_a.func_147359_a((Packet)new S__PacketSendUUID(evt.player));
            }

            public S__PacketSendUUID() {
            }

            public S__PacketSendUUID(EntityPlayer player) {
                this.id = player.func_146103_bH().getId();
            }

            public void func_148837_a(PacketBuffer buffer) throws IOException {
                this.id = new UUID(buffer.readLong(), buffer.readLong());
            }

            public void func_148840_b(PacketBuffer buffer) throws IOException {
                buffer.writeLong(this.id.getMostSignificantBits());
                buffer.writeLong(this.id.getLeastSignificantBits());
            }

            public boolean func_148836_a() {
                return true;
            }

            public void func_148833_a(INetHandler p_148833_1_) {
                cachedId = this.id;
            }
        }
    }
}

