/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.position;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.position.IRotateableTile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPosition
implements Comparable<BlockPosition>,
Serializable {
    private static final long serialVersionUID = 8671402745765780610L;
    public int x;
    public int y;
    public int z;
    public ForgeDirection orientation;

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(int x, int y, int z, ForgeDirection orientation) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = orientation;
    }

    public BlockPosition(BlockPosition p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public BlockPosition(NBTTagCompound tag) {
        this.x = tag.func_74762_e("bp_i");
        this.y = tag.func_74762_e("bp_j");
        this.z = tag.func_74762_e("bp_k");
        this.orientation = !tag.func_74764_b("bp_dir") ? ForgeDirection.UNKNOWN : ForgeDirection.getOrientation((int)tag.func_74771_c("bp_dir"));
    }

    public BlockPosition(TileEntity tile) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.orientation = tile instanceof IRotateableTile ? ((IRotateableTile)tile).getDirectionFacing() : ForgeDirection.UNKNOWN;
    }

    public static <T extends TileEntity> BlockPosition fromRotateableTile(T te) {
        return new BlockPosition(te);
    }

    public BlockPosition copy() {
        return new BlockPosition(this.x, this.y, this.z, this.orientation);
    }

    public BlockPosition copy(ForgeDirection orientation) {
        return new BlockPosition(this.x, this.y, this.z, orientation);
    }

    public BlockPosition setOrientation(ForgeDirection o) {
        this.orientation = o;
        return this;
    }

    public BlockPosition step(int dir) {
        int[] d = BlockHelper.SIDE_COORD_MOD[dir];
        this.x += d[0];
        this.y += d[1];
        this.z += d[2];
        return this;
    }

    public BlockPosition step(int dir, int dist) {
        int[] d = BlockHelper.SIDE_COORD_MOD[dir];
        this.x += d[0] * dist;
        this.y += d[1] * dist;
        this.z += d[2] * dist;
        return this;
    }

    public BlockPosition step(ForgeDirection dir) {
        this.x += dir.offsetX;
        this.y += dir.offsetY;
        this.z += dir.offsetZ;
        return this;
    }

    public BlockPosition step(ForgeDirection dir, int dist) {
        this.x += dir.offsetX * dist;
        this.y += dir.offsetY * dist;
        this.z += dir.offsetZ * dist;
        return this;
    }

    public BlockPosition moveForwards(int step) {
        switch (this.orientation) {
            case UP: {
                this.y += step;
                break;
            }
            case DOWN: {
                this.y -= step;
                break;
            }
            case SOUTH: {
                this.z += step;
                break;
            }
            case NORTH: {
                this.z -= step;
                break;
            }
            case EAST: {
                this.x += step;
                break;
            }
            case WEST: {
                this.x -= step;
                break;
            }
        }
        return this;
    }

    public BlockPosition moveBackwards(int step) {
        return this.moveForwards(-step);
    }

    public BlockPosition moveRight(int step) {
        switch (this.orientation) {
            case UP: 
            case SOUTH: {
                this.x -= step;
                break;
            }
            case DOWN: 
            case NORTH: {
                this.x += step;
                break;
            }
            case EAST: {
                this.z += step;
                break;
            }
            case WEST: {
                this.z -= step;
                break;
            }
        }
        return this;
    }

    public BlockPosition moveLeft(int step) {
        return this.moveRight(-step);
    }

    public BlockPosition moveUp(int step) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += step;
                break;
            }
            case UP: {
                this.z -= step;
                break;
            }
            case DOWN: {
                this.z += step;
            }
        }
        return this;
    }

    public BlockPosition moveDown(int step) {
        return this.moveUp(-step);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bp_i", this.x);
        tag.func_74768_a("bp_j", this.y);
        tag.func_74768_a("bp_k", this.z);
        tag.func_74774_a("bp_dir", (byte)this.orientation.ordinal());
    }

    public String toString() {
        if (this.orientation == null) {
            return "{" + this.x + ", " + this.y + ", " + this.z + "}";
        }
        return "{" + this.x + ", " + this.y + ", " + this.z + ";" + this.orientation.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockPosition)) {
            return false;
        }
        BlockPosition bp = (BlockPosition)obj;
        return bp.x == this.x & bp.y == this.y & bp.z == this.z & bp.orientation == this.orientation;
    }

    public boolean equals(BlockPosition bp) {
        return bp != null && bp.x == this.x & bp.y == this.y & bp.z == this.z & bp.orientation == this.orientation;
    }

    public int hashCode() {
        return this.x & 0xFFF | this.y & 0xFF00 | this.z & 0xFFF000;
    }

    public BlockPosition min(BlockPosition p) {
        return new BlockPosition(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public BlockPosition max(BlockPosition p) {
        return new BlockPosition(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }

    public List<BlockPosition> getAdjacent(boolean includeVertical) {
        ArrayList<BlockPosition> a = new ArrayList<BlockPosition>(4 + (includeVertical ? 2 : 0));
        a.add(this.copy(ForgeDirection.EAST).moveForwards(1));
        a.add(this.copy(ForgeDirection.WEST).moveForwards(1));
        a.add(this.copy(ForgeDirection.SOUTH).moveForwards(1));
        a.add(this.copy(ForgeDirection.NORTH).moveForwards(1));
        if (includeVertical) {
            a.add(this.copy(ForgeDirection.UP).moveForwards(1));
            a.add(this.copy(ForgeDirection.DOWN).moveForwards(1));
        }
        return a;
    }

    public boolean blockExists(World world) {
        return world.func_72899_e(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public <T> T getTileEntity(World world, Class<T> targetClass) {
        TileEntity te = world.func_147438_o(this.x, this.y, this.z);
        if (targetClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public static ForgeDirection getDirection(int xS, int yS, int zS, int x, int y, int z) {
        int dir = 0;
        if (y < yS) {
            dir |= 1;
        } else if (y != yS) {
            dir |= 2;
        }
        if (z < zS) {
            dir |= 4;
        } else if (z != zS) {
            dir |= 8;
        }
        if (x < xS) {
            dir |= 0x10;
        } else if (x != xS) {
            dir |= 0x20;
        }
        switch (dir) {
            case 2: {
                return ForgeDirection.UP;
            }
            case 1: {
                return ForgeDirection.DOWN;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 8: {
                return ForgeDirection.EAST;
            }
            case 16: {
                return ForgeDirection.NORTH;
            }
            case 32: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static TileEntity getTileEntityRaw(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        return world.func_72938_d(x, z).getTileEntityUnsafe(x & 0xF, y, z & 0xF);
    }

    public static <T> T getTileEntityRaw(World world, int x, int y, int z, Class<T> targetClass) {
        TileEntity te = BlockPosition.getTileEntityRaw(world, x, y, z);
        if (targetClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public static boolean blockExists(TileEntity start, ForgeDirection dir) {
        int x = start.field_145851_c + dir.offsetX;
        int y = start.field_145848_d + dir.offsetY;
        int z = start.field_145849_e + dir.offsetZ;
        return start.func_145831_w().func_72899_e(x, y, z);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity start, ForgeDirection dir) {
        int x = start.field_145851_c + dir.offsetX;
        int y = start.field_145848_d + dir.offsetY;
        int z = start.field_145849_e + dir.offsetZ;
        return BlockPosition.getTileEntityRaw(start.func_145831_w(), x, y, z);
    }

    public static <T> T getAdjacentTileEntity(TileEntity start, ForgeDirection direction, Class<T> targetClass) {
        TileEntity te = BlockPosition.getAdjacentTileEntity(start, direction);
        if (targetClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    @Override
    public int compareTo(BlockPosition other) {
        return this.x == other.x ? (this.y == other.y ? this.z - other.z : this.y - other.y) : this.x - other.x;
    }
}

