/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.utils.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SideFilterData
implements IInventory {
    public static final int INVENTORY_SIZE = 27;
    private ItemStack[] inventory = new ItemStack[27];
    private boolean matchNBT;
    private boolean matchMetadata;
    private boolean acceptUnsortedItems;

    public boolean matchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNBT) {
        this.matchNBT = matchNBT;
    }

    public boolean matchMetadata() {
        return this.matchMetadata;
    }

    public void setMatchMetadata(boolean matchMetadata) {
        this.matchMetadata = matchMetadata;
    }

    public boolean acceptsUnsortedItems() {
        return this.acceptUnsortedItems;
    }

    public void setAcceptUnsortedItems(boolean acceptUnsortedItems) {
        this.acceptUnsortedItems = acceptUnsortedItems;
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        nbtTagCompound.func_74757_a("matchNBT", this.matchNBT);
        nbtTagCompound.func_74757_a("matchMetadata", this.matchMetadata);
        nbtTagCompound.func_74757_a("acceptUnsortedItems", this.acceptUnsortedItems);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.matchNBT = nbtTagCompound.func_74767_n("matchNBT");
        this.matchMetadata = nbtTagCompound.func_74767_n("matchMetadata");
        this.acceptUnsortedItems = nbtTagCompound.func_74767_n("acceptUnsortedItems");
    }

    public boolean matchesStack(ItemStack stack) {
        if (stack == null) {
            Log.error("SideFilterData.matchesSide() called with null argument!");
            return false;
        }
        for (int index = 0; index < 27; ++index) {
            ItemStack slotStack = this.inventory[index];
            if (slotStack == null || slotStack.func_77973_b() != stack.func_77973_b() || this.matchMetadata && stack.func_77960_j() != slotStack.func_77960_j()) continue;
            if (!this.matchNBT || slotStack.field_77990_d == null && stack.field_77990_d == null) {
                return true;
            }
            if (slotStack.field_77990_d == null || stack.field_77990_d == null || !slotStack.field_77990_d.equals((Object)stack.field_77990_d)) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.inventory[slotIndex] != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "gui.jeweled_pipe";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

