/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import openmods.network.event.EventDirection;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventMeta;
import openmods.structured.Command;
import openperipheral.addons.glasses.SurfaceType;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.addons.glasses.client.SurfaceClient;

public abstract class TerminalEvent
extends NetworkEvent {
    public long terminalId;

    public TerminalEvent() {
    }

    public TerminalEvent(long terminalId) {
        this.terminalId = terminalId;
    }

    protected void readFromStream(DataInput input) throws IOException {
        this.terminalId = input.readLong();
    }

    protected void writeToStream(DataOutput output) throws IOException {
        output.writeLong(this.terminalId);
    }

    protected void appendLogInfo(List<String> info) {
        info.add(TerminalUtils.formatTerminalId(this.terminalId));
    }

    public abstract SurfaceType getSurfaceType();

    @NetworkEventMeta(direction=EventDirection.S2C, chunked=true, compressed=true)
    public static class PublicDrawableData
    extends DrawableData {
        public PublicDrawableData() {
        }

        public PublicDrawableData(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.GLOBAL;
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C, chunked=true, compressed=true)
    public static class PublicStructureData
    extends StructureData {
        public PublicStructureData() {
        }

        public PublicStructureData(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.GLOBAL;
        }
    }

    public static abstract class StructureData
    extends Data {
        public StructureData() {
        }

        public StructureData(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceClient createSurface() {
            return SurfaceClient.createPublicSurface(this.terminalId);
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C, chunked=true, compressed=true)
    public static class PrivateStructureData
    extends StructureData {
        public PrivateStructureData() {
        }

        public PrivateStructureData(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.PRIVATE;
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C, chunked=true, compressed=true)
    public static class PrivateDrawableData
    extends DrawableData {
        public PrivateDrawableData() {
        }

        public PrivateDrawableData(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.PRIVATE;
        }
    }

    public static abstract class DrawableData
    extends Data {
        public DrawableData() {
        }

        public DrawableData(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceClient createSurface() {
            return SurfaceClient.createPrivateSurface(this.terminalId);
        }
    }

    public static abstract class Data
    extends TerminalEvent {
        public final Command.CommandList commands = new Command.CommandList();

        public Data() {
        }

        public Data(long terminalId) {
            super(terminalId);
        }

        @Override
        protected void readFromStream(DataInput input) throws IOException {
            super.readFromStream(input);
            this.commands.readFromStream(input);
        }

        @Override
        protected void writeToStream(DataOutput output) throws IOException {
            super.writeToStream(output);
            this.commands.writeToStream(output);
        }

        @Override
        protected void appendLogInfo(List<String> info) {
            super.appendLogInfo(info);
            info.add(Integer.toString(this.commands.size()));
        }

        public SurfaceClient createSurface() {
            throw new AbstractMethodError();
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C)
    public static class PublicClear
    extends Clear {
        public PublicClear() {
        }

        public PublicClear(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.GLOBAL;
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C)
    public static class PrivateClear
    extends Clear {
        public PrivateClear() {
        }

        public PrivateClear(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.PRIVATE;
        }
    }

    public static abstract class Clear
    extends TerminalEvent {
        public Clear() {
        }

        public Clear(long terminalId) {
            super(terminalId);
        }
    }

    @NetworkEventMeta(direction=EventDirection.C2S)
    public static class PrivateStructureReset
    extends StructureReset {
        public PrivateStructureReset() {
        }

        public PrivateStructureReset(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.PRIVATE;
        }
    }

    @NetworkEventMeta(direction=EventDirection.C2S)
    public static class PrivateDrawableReset
    extends DrawableReset {
        public PrivateDrawableReset() {
        }

        public PrivateDrawableReset(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.PRIVATE;
        }
    }

    public static abstract class StructureReset
    extends Reset {
        public StructureReset() {
        }

        public StructureReset(long terminalId) {
            super(terminalId);
        }
    }

    @NetworkEventMeta(direction=EventDirection.C2S)
    public static class PublicStructureReset
    extends StructureReset {
        public PublicStructureReset() {
        }

        public PublicStructureReset(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.GLOBAL;
        }
    }

    @NetworkEventMeta(direction=EventDirection.C2S)
    public static class PublicDrawableReset
    extends DrawableReset {
        public PublicDrawableReset() {
        }

        public PublicDrawableReset(long terminalId) {
            super(terminalId);
        }

        @Override
        public SurfaceType getSurfaceType() {
            return SurfaceType.GLOBAL;
        }
    }

    public static abstract class DrawableReset
    extends Reset {
        public DrawableReset() {
        }

        public DrawableReset(long terminalId) {
            super(terminalId);
        }
    }

    public static abstract class Reset
    extends TerminalEvent {
        public Reset() {
        }

        public Reset(long terminalId) {
            super(terminalId);
        }
    }
}

