/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.ICustomHarvestDrops;
import openmods.api.IPlaceAwareTile;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.network.event.NetworkEventManager;
import openmods.network.senders.ITargetedPacketSender;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.ItemUtils;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.glasses.GuiCaptureControl;
import openperipheral.addons.glasses.IClearable;
import openperipheral.addons.glasses.IContainer;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalIdAccess;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.server.DrawableContainerMaster;
import openperipheral.addons.glasses.server.IDrawableFactory;
import openperipheral.addons.glasses.server.SurfaceServer;
import openperipheral.addons.glasses.server.TerminalManagerServer;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.Doc;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.architecture.FeatureGroup;
import openperipheral.api.architecture.IArchitecture;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.architecture.IAttachable;
import openperipheral.api.peripheral.PeripheralTypeId;

@Doc(value={"This peripheral is used to control terminal glasses and wireless keyboard.", "There is one global surface and one private surface for every glasses user.", "All calls names .add*() will return object that can be later used to modify it.", "To make changes visible to players, call .sync().", "This peripheral signals few events. Full list available here: http://goo.gl/8Hf2yA", "Simple demo: http://goo.gl/n5HPN8"})
@PeripheralTypeId(value="openperipheral_bridge")
@FeatureGroup(value={"openperipheral-glasses"})
public class TileEntityGlassesBridge
extends OpenTileEntity
implements IAttachable,
IPlaceAwareTile,
ICustomHarvestDrops,
IClearable {
    private static final String GLOBAL_FAKE_PLAYER_NAME = "$GLOBAL$";
    public static final String TAG_GUID = "guid";
    private static final String EVENT_PLAYER_ATTACH = "glasses_attach";
    private static final String EVENT_PLAYER_DETACH = "glasses_detach";
    private final Map<UUID, PlayerInfo> knownPlayersByUUID = Maps.newHashMap();
    private final Map<String, PlayerInfo> knownPlayersByName = Maps.newHashMap();
    private List<Object> globalFullDataPackets;
    private Set<IArchitectureAccess> computers = Sets.newIdentityHashSet();
    private Optional<Long> guid = Optional.absent();
    private SurfaceServer globalSurface;

    @IncludeInterface(value=IContainer.class)
    private IContainer<Drawable> getDrawablesContainer() {
        return this.globalSurface.drawablesContainer;
    }

    @IncludeInterface(value=IDrawableFactory.class)
    private IDrawableFactory getDrawablesFactory() {
        return this.globalSurface.drawablesFactory;
    }

    private void rebuildPlayerNamesMap() {
        this.knownPlayersByName.clear();
        for (PlayerInfo info : this.knownPlayersByUUID.values()) {
            EntityPlayerMP player = (EntityPlayerMP)info.player.get();
            if (!this.isPlayerValid(player)) continue;
            String name = player.func_146103_bH().getName();
            this.knownPlayersByName.put(name, info);
        }
    }

    public long getOrCreateGuid() {
        if (this.guid.isPresent()) {
            return (Long)this.guid.get();
        }
        long newGuid = TerminalUtils.generateGuid();
        this.guid = Optional.of((Object)newGuid);
        return newGuid;
    }

    public void registerTerminal(EntityPlayerMP player) {
        if (!this.knownPlayersByUUID.containsKey(player.func_146103_bH().getId())) {
            PlayerInfo playerInfo = new PlayerInfo(this.getOrCreateGuid(), player);
            GameProfile gameProfile = player.func_146103_bH();
            this.knownPlayersByUUID.put(gameProfile.getId(), playerInfo);
            this.rebuildPlayerNamesMap();
            this.queueEvent(EVENT_PLAYER_ATTACH, (EntityPlayer)player, new Object[0]);
            this.sentStoredFullDataToPlayer((EntityPlayer)player);
        }
    }

    private void sentStoredFullDataToPlayer(EntityPlayer player) {
        if (this.globalFullDataPackets != null) {
            NetworkEventManager.INSTANCE.dispatcher().senders.player.sendMessages(this.globalFullDataPackets, (Object)player);
        }
    }

    private void queueEvent(String event, EntityPlayer user, IEventArgsSource source) {
        GameProfile gameProfile = user.func_146103_bH();
        UUID userId = gameProfile.getId();
        String idString = userId != null ? userId.toString() : null;
        String userName = gameProfile.getName();
        for (IArchitectureAccess computer : this.computers) {
            Object[] extra = source.getArgs(computer);
            Object[] args = new Object[3 + extra.length];
            System.arraycopy(extra, 0, args, 3, extra.length);
            args[0] = computer.peripheralName();
            args[1] = userName;
            args[2] = idString;
            computer.signal(event, args);
        }
    }

    private void queueEvent(String event, EntityPlayer user, final Object ... args) {
        this.queueEvent(event, user, new IEventArgsSource(){

            @Override
            public Object[] getArgs(IArchitectureAccess access) {
                return args;
            }
        });
    }

    public void onChatCommand(String event, String content, EntityPlayer player) {
        this.queueEvent(event, player, content);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long guid = this.getOrCreateGuid();
        if (this.globalSurface == null) {
            this.globalSurface = SurfaceServer.createPublicSurface(guid);
        }
        TerminalManagerServer.instance.registerBridge(guid, this);
        boolean playersRemoved = false;
        Iterator<PlayerInfo> it = this.knownPlayersByUUID.values().iterator();
        while (it.hasNext()) {
            PlayerInfo info = it.next();
            EntityPlayerMP player = (EntityPlayerMP)info.player.get();
            if (this.isPlayerValid(player)) continue;
            this.queueEvent(EVENT_PLAYER_DETACH, (EntityPlayer)player, new Object[0]);
            TileEntityGlassesBridge.sendClearPacketToPlayer(player, this.globalSurface);
            TileEntityGlassesBridge.sendClearPacketToPlayer(player, info.surface);
            it.remove();
            playersRemoved = true;
        }
        if (playersRemoved) {
            this.rebuildPlayerNamesMap();
        }
    }

    private static void sendClearPacketToPlayer(EntityPlayerMP player, SurfaceServer surface) {
        surface.drawablesContainer.createClearPacket().sendToPlayer((EntityPlayer)player);
    }

    private boolean isPlayerValid(EntityPlayerMP player) {
        if (player == null) {
            return false;
        }
        if (player.field_70128_L && !TileEntityGlassesBridge.isPlayerLogged(player)) {
            return false;
        }
        Optional<Long> guid = TerminalIdAccess.instance.getIdFrom((EntityPlayer)player);
        return guid.isPresent() && ((Long)guid.get()).longValue() == this.getOrCreateGuid();
    }

    private static boolean isPlayerLogged(EntityPlayerMP player) {
        GameProfile gameProfile = player.func_146103_bH();
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP p : players) {
            if (!p.func_146103_bH().equals((Object)gameProfile)) continue;
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.guid.isPresent()) {
            tag.func_74772_a(TAG_GUID, ((Long)this.guid.get()).longValue());
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.guid = Optional.fromNullable((Object)TerminalUtils.extractGuid(tag));
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b(TAG_GUID)) {
            this.guid = Optional.of((Object)tag.func_74763_f(TAG_GUID));
        }
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops) {
        ItemStack result = new ItemStack(this.func_145838_q());
        if (this.guid.isPresent()) {
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
            tag.func_74772_a(TAG_GUID, ((Long)this.guid.get()).longValue());
        }
        drops.add(result);
    }

    public boolean suppressNormalHarvestDrops() {
        return true;
    }

    public void addComputer(IArchitectureAccess computer) {
        if (!this.computers.contains(computer)) {
            this.computers.add(computer);
        }
    }

    public void removeComputer(IArchitectureAccess computer) {
        this.computers.remove(computer);
    }

    public void handleUserEvent(final GlassesEvent.GlassesClientEvent evt) {
        this.queueEvent(evt.getEventName(), evt.sender, new IEventArgsSource(){

            @Override
            public Object[] getArgs(IArchitectureAccess access) {
                return evt.getEventArgs((IArchitecture)access);
            }
        });
    }

    public SurfaceServer getSurface(String username) {
        if (GLOBAL_FAKE_PLAYER_NAME.equals(username)) {
            return this.globalSurface;
        }
        PlayerInfo info = this.knownPlayersByName.get(username);
        return info != null ? info.surface : null;
    }

    public SurfaceServer getSurface(UUID uuid) {
        if (TerminalUtils.GLOBAL_SURFACE_UUID.equals(uuid)) {
            return this.globalSurface;
        }
        PlayerInfo info = this.knownPlayersByUUID.get(uuid);
        return info != null ? info.surface : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptCallable(description="Send updates to client. Without it changes won't be visible", name="sync")
    public void syncContents() {
        DrawableContainerMaster drawables;
        DrawableContainerMaster drawableContainerMaster = drawables = this.globalSurface.drawablesContainer;
        synchronized (drawableContainerMaster) {
            boolean globalChanged = drawables.hasUpdates();
            if (globalChanged || this.globalFullDataPackets == null) {
                TerminalEvent.Data globalFullData = drawables.createFullDataEvent();
                this.globalFullDataPackets = globalFullData.serialize();
            }
            List globalUpdateDataPackets = null;
            if (globalChanged) {
                TerminalEvent.Data globalDelta = drawables.createUpdateDataEvent();
                globalUpdateDataPackets = globalDelta.serialize();
            }
            ITargetedPacketSender playerSender = NetworkEventManager.INSTANCE.dispatcher().senders.player;
            for (PlayerInfo info : this.knownPlayersByUUID.values()) {
                EntityPlayerMP player = (EntityPlayerMP)info.player.get();
                if (!this.isPlayerValid(player)) continue;
                if (globalUpdateDataPackets != null) {
                    playerSender.sendMessages((Collection)globalUpdateDataPackets, (Object)player);
                }
                TileEntityGlassesBridge.sendPrivateUpdateToPlayer(player, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendPrivateUpdateToPlayer(EntityPlayerMP player, PlayerInfo info) {
        DrawableContainerMaster drawables;
        SurfaceServer privateSurface = info.surface;
        DrawableContainerMaster drawableContainerMaster = drawables = privateSurface.drawablesContainer;
        synchronized (drawableContainerMaster) {
            if (drawables.hasUpdates()) {
                TerminalEvent.Data privateUpdateDataPackets = drawables.createUpdateDataEvent();
                privateUpdateDataPackets.sendToPlayer((EntityPlayer)player);
            }
        }
    }

    private static void sendFullDataPacketToPlayer(EntityPlayer player, SurfaceServer surface) {
        surface.drawablesContainer.createFullDataEvent().sendToPlayer(player);
    }

    private void sendPrivateFullDataToPlayer(EntityPlayer player) {
        UUID playerUuid = player.func_146103_bH().getId();
        PlayerInfo info = this.knownPlayersByUUID.get(playerUuid);
        if (info != null) {
            TileEntityGlassesBridge.sendFullDataPacketToPlayer(player, info.surface);
        }
    }

    public void handlePrivateDrawableResetRequest(TerminalEvent.PrivateDrawableReset evt) {
        this.sendPrivateFullDataToPlayer(evt.sender);
    }

    public void handlePublicDrawableResetRequest(TerminalEvent.PublicDrawableReset evt) {
        this.sentStoredFullDataToPlayer(evt.sender);
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get the names of all the users linked up to this bridge")
    public List<GameProfile> getUsers() {
        ArrayList result = Lists.newArrayList();
        for (PlayerInfo info : this.knownPlayersByUUID.values()) {
            result.add(info.profile);
        }
        return result;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.STRING}, name="getGuid", description="Get the Guid of this bridge")
    public String getGuidString() {
        return TerminalUtils.formatTerminalId(this.getOrCreateGuid());
    }

    @Override
    @IncludeOverride
    public void clear() {
        this.globalSurface.drawablesContainer.clear();
        for (PlayerInfo info : this.knownPlayersByUUID.values()) {
            info.surface.drawablesContainer.clear();
        }
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the surface of a user to draw privately on their screen")
    public SurfaceServer getSurfaceByName(@Arg(name="username", description="The username of the user to get the draw surface for") String username) {
        SurfaceServer playerSurface = this.getSurface(username);
        Preconditions.checkNotNull((Object)playerSurface, (Object)"Invalid player");
        return playerSurface;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the surface of a user to draw privately on their screen")
    public SurfaceServer getSurfaceByUUID(@Arg(name="uuid", description="The uuid of the user to get the draw surface for") UUID uuid) {
        SurfaceServer playerSurface = this.getSurface(uuid);
        Preconditions.checkNotNull((Object)playerSurface, (Object)"Invalid player");
        return playerSurface;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Returns object used for controlling player capture mode")
    public GuiCaptureControl getCaptureControl(@Arg(name="uuid") UUID uuid) {
        PlayerInfo info = this.knownPlayersByUUID.get(uuid);
        return info != null ? new GuiCaptureControl(this.getOrCreateGuid(), info.player) : null;
    }

    private static interface IEventArgsSource {
        public Object[] getArgs(IArchitectureAccess var1);
    }

    private static class PlayerInfo {
        public final GameProfile profile;
        public final WeakReference<EntityPlayerMP> player;
        public final SurfaceServer surface;

        public PlayerInfo(long guid, EntityPlayerMP player) {
            this.player = new WeakReference<EntityPlayerMP>(player);
            this.profile = player.func_146103_bH();
            this.surface = SurfaceServer.createPrivateSurface(guid);
        }
    }
}

