/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.client.gui.ScaledResolution;
import openmods.geometry.Box2d;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openmods.structured.StructureField;
import openperipheral.addons.glasses.StructuredObjectBase;
import openperipheral.addons.glasses.drawable.DrawableType;
import openperipheral.addons.glasses.utils.Point2d;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import org.lwjgl.opengl.GL11;

@Asynchronous
@AdapterSourceName(value="glasses_drawable")
public abstract class Drawable
extends StructuredObjectBase {
    private Box2d boundingBox = Box2d.NULL;
    private float rotationSin;
    private float rotationCos;
    private final Alignment alignment = new Alignment();
    @Property
    @StructureField
    public short z;
    @Property
    @StructureField
    public boolean visible = true;
    @Property
    @StructureField
    public boolean clickable = true;
    @Property
    @StructureField
    public float rotation = 0.0f;
    @Property(type=ArgType.OBJECT, getterDesc="Get userdata", setterDesc="Set userdata (no restrictions, not sent to clients)", nullable=true)
    public Object userdata;

    protected Drawable() {
    }

    public void onUpdate() {
        double rotationRad = (double)(this.rotation / 180.0f) * Math.PI;
        this.rotationCos = (float)Math.cos(rotationRad);
        this.rotationSin = (float)Math.sin(rotationRad);
    }

    public Point2d transformToLocal(float worldX, float worldY, float screenWidth, float screenHeight) {
        float worldLeft = this.alignment.getScreenAnchorX(screenWidth) + this.boundingBox.left;
        float worldTop = this.alignment.getScreenAnchorY(screenHeight) + this.boundingBox.top;
        float localX = (worldX -= worldLeft) * this.rotationCos + (worldY -= worldTop) * this.rotationSin;
        float localY = worldX * -this.rotationSin + worldY * this.rotationCos;
        return new Point2d(localX -= this.alignment.getObjectAnchorX(this.boundingBox), localY -= this.alignment.getObjectAnchorY(this.boundingBox));
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(ScaledResolution resolution, RenderState renderState, float partialTicks) {
        float screenX = this.alignment.getScreenAnchorX(resolution.func_78326_a()) + this.boundingBox.left;
        float screenY = this.alignment.getScreenAnchorY(resolution.func_78328_b()) + this.boundingBox.top;
        float anchorX = this.alignment.getObjectAnchorX(this.boundingBox);
        float anchorY = this.alignment.getObjectAnchorY(this.boundingBox);
        GL11.glPushMatrix();
        if (this.rotation != 0.0f) {
            GL11.glTranslatef((float)screenX, (float)screenY, (float)this.z);
            GL11.glRotated((double)this.rotation, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslatef((float)anchorX, (float)anchorY, (float)0.0f);
        } else {
            GL11.glTranslatef((float)(screenX + anchorX), (float)(screenY + anchorY), (float)this.z);
        }
        this.drawContents(renderState, partialTicks);
        GL11.glPopMatrix();
    }

    protected void setBoundingBox(Box2d boundingBox) {
        Preconditions.checkNotNull((Object)boundingBox);
        this.boundingBox = boundingBox;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawContents(RenderState var1, float var2);

    protected abstract DrawableType getTypeEnum();

    protected abstract boolean isVisible();

    public final boolean shouldRender() {
        return this.visible && this.isVisible();
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public int getType() {
        return this.getTypeEnum().ordinal();
    }

    @ScriptCallable(returnTypes={ReturnType.STRING}, name="getType", description="Get object type")
    public String getTypeName() {
        return this.getTypeEnum().name().toLowerCase();
    }

    public VerticalAlignment getScreenVerticalAnchor() {
        return this.alignment.screenVerticalAnchor;
    }

    @ScriptCallable
    public void setScreenAnchor(@Arg(name="horizontal") HorizontalAlignment horizontal, @Arg(name="vertical") VerticalAlignment vertical) {
        this.alignment.screenVerticalAnchor = vertical;
        this.alignment.screenHorizontalAnchor = horizontal;
        this.markModified(this.alignment.id);
    }

    @ScriptCallable
    public void setObjectAnchor(@Arg(name="horizontal") HorizontalAlignment horizontal, @Arg(name="vertical") VerticalAlignment vertical) {
        this.alignment.objectVerticalAnchor = vertical;
        this.alignment.objectHorizontalAnchor = horizontal;
        this.markModified(this.alignment.id);
    }

    @ScriptCallable
    public void setAlignment(@Arg(name="horizontal") HorizontalAlignment horizontal, @Arg(name="vertical") VerticalAlignment vertical) {
        this.alignment.objectVerticalAnchor = this.alignment.screenVerticalAnchor = vertical;
        this.alignment.objectHorizontalAnchor = this.alignment.screenHorizontalAnchor = horizontal;
        this.markModified(this.alignment.id);
    }

    public void createElements(IStructureContainer.IElementAddCallback<IStructureElement> callback) {
        super.createElements(callback);
        this.alignment.id = callback.addElement((IStructureElement)this.alignment);
    }

    public Box2d getBoundingBox() {
        return this.boundingBox;
    }

    private static class Alignment
    implements IStructureElement {
        private static final int MASK = 3;
        private int id;
        public VerticalAlignment screenVerticalAnchor = VerticalAlignment.TOP;
        public HorizontalAlignment screenHorizontalAnchor = HorizontalAlignment.LEFT;
        public VerticalAlignment objectVerticalAnchor = VerticalAlignment.TOP;
        public HorizontalAlignment objectHorizontalAnchor = HorizontalAlignment.LEFT;

        private Alignment() {
        }

        public void readFromStream(DataInput input) throws IOException {
            byte value = input.readByte();
            this.screenVerticalAnchor = VerticalAlignment.VALUES[value >> 0 & 3];
            this.screenHorizontalAnchor = HorizontalAlignment.VALUES[value >> 2 & 3];
            this.objectVerticalAnchor = VerticalAlignment.VALUES[value >> 4 & 3];
            this.objectHorizontalAnchor = HorizontalAlignment.VALUES[value >> 6 & 3];
        }

        public void writeToStream(DataOutput output) throws IOException {
            byte value = (byte)(this.screenVerticalAnchor.ordinal() << 0 | this.screenHorizontalAnchor.ordinal() << 2 | this.objectVerticalAnchor.ordinal() << 4 | this.objectHorizontalAnchor.ordinal() << 6);
            output.writeByte(value);
        }

        public float getScreenAnchorX(float screenWidth) {
            switch (this.screenHorizontalAnchor) {
                case MIDDLE: {
                    return screenWidth / 2.0f;
                }
                case RIGHT: {
                    return screenWidth;
                }
            }
            return 0.0f;
        }

        public float getObjectAnchorX(Box2d box) {
            switch (this.objectHorizontalAnchor) {
                case MIDDLE: {
                    return -box.width / 2.0f;
                }
                case RIGHT: {
                    return -box.width;
                }
            }
            return 0.0f;
        }

        public float getScreenAnchorY(float screenHeight) {
            switch (this.screenVerticalAnchor) {
                case BOTTOM: {
                    return screenHeight;
                }
                case MIDDLE: {
                    return screenHeight / 2.0f;
                }
            }
            return 0.0f;
        }

        public float getObjectAnchorY(Box2d box) {
            switch (this.objectVerticalAnchor) {
                case BOTTOM: {
                    return -box.height;
                }
                case MIDDLE: {
                    return -box.height / 2.0f;
                }
            }
            return 0.0f;
        }
    }

    public static enum HorizontalAlignment {
        LEFT,
        MIDDLE,
        RIGHT;

        public static final HorizontalAlignment[] VALUES;

        static {
            VALUES = HorizontalAlignment.values();
        }
    }

    public static enum VerticalAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

        public static final VerticalAlignment[] VALUES;

        static {
            VALUES = VerticalAlignment.values();
        }
    }
}

