/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.lib;

import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.items.DraconiumBlend;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class OreDoublingRegistry {
    private static Map<String, ItemStack> oreResults = new HashMap<String, ItemStack>();
    private static String[] names = new String[]{"oreGold", "oreIron", "oreAluminum", "oreCopper", "oreLead", "oreSilver", "oreTin", "oreUranium", "orePlatinum", "oreNickel", "oreMithril", "oreCobalt", "oreArdite"};
    public static Map<String, ItemStack> resultOverrides = new HashMap<String, ItemStack>();

    public static void init() {
        for (String oreName : names) {
            String ingotName = "ingot" + oreName.substring(oreName.indexOf("ore") + 3);
            ItemStack resultIngot = GameRegistry.findItemStack((String)"ThermalFoundation", (String)ingotName, (int)1);
            if (resultIngot == null && OreDictionary.getOres((String)ingotName).size() > 0) {
                resultIngot = (ItemStack)OreDictionary.getOres((String)ingotName).get(0);
            }
            oreResults.put(oreName, resultIngot);
        }
    }

    public static ItemStack getOreResult(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (resultOverrides.containsKey(stack.func_77973_b().func_77667_c(stack))) {
            return resultOverrides.get(stack.func_77973_b().func_77667_c(stack)).func_77946_l();
        }
        if (FurnaceRecipes.func_77602_a().func_151395_a(stack) == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof DraconiumBlend) {
            return new ItemStack((Item)ModItems.draconiumIngot, 4);
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e)) {
            return new ItemStack(Blocks.field_150348_b, 2);
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
            return new ItemStack(Blocks.field_150359_w, 2);
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150434_aF)) {
            return new ItemStack(Items.field_151100_aR, 2, 2);
        }
        if (stack.func_77973_b() == Items.field_151119_aD) {
            return new ItemStack(Items.field_151118_aC, 2);
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        ItemStack resultStack = null;
        if (ids.length > 0) {
            String name = OreDictionary.getOreName((int)ids[0]);
            resultStack = oreResults.get(name);
        }
        if (resultStack != null) {
            ItemStack doubledStack = resultStack.func_77946_l();
            doubledStack.field_77994_a = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)stack).field_77994_a * 2;
            return doubledStack;
        }
        return null;
    }
}

