/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.vanillamc;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockSkull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonVanillaTiles
implements IWailaDataProvider {
    private static final String CONFIG_BEACON_LEVEL = "wawla.beacon.showLevels";
    private static final String CONFIG_BEACON_PRIMARY = "wawla.beacon.showPrimary";
    private static final String CONFIG_BEACON_SECONDARY = "wawla.beacon.showSecondary";
    private static final String CONFIG_FURNACE_INPUT = "wawla.furnace.input";
    private static final String CONFIG_FURNACE_OUTPUT = "wawla.furnace.output";
    private static final String CONFIG_FURNACE_FUEL = "wawla.furnace.fuel";
    private static final String CONFIG_FURNACE_BURNTIME = "wawla.furnace.burntime";
    private static final String CONFIG_PLAYER_SKULL = "wawla.showHead";

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        if (data.getTileEntity() instanceof TileEntityBeacon) {
            NBTTagCompound tag = data.getNBTData();
            int level = tag.func_74762_e("Levels");
            int primary = tag.func_74762_e("Primary");
            int secondary = tag.func_74762_e("Secondary");
            if (cfg.getConfig(CONFIG_BEACON_LEVEL)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.levels") + ": " + level);
            }
            if (cfg.getConfig(CONFIG_BEACON_PRIMARY) && primary > 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.primary") + ": " + StatCollector.func_74838_a((String)Potion.field_76425_a[primary].func_76393_a()));
            }
            if (cfg.getConfig(CONFIG_BEACON_SECONDARY) && secondary > 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.secondary") + ": " + StatCollector.func_74838_a((String)Potion.field_76425_a[secondary].func_76393_a()));
            }
        } else if (data.getTileEntity() instanceof TileEntityFurnace) {
            data.getTileEntity();
            int burnTime = data.getNBTData().func_74762_e("BurnTime") / 20;
            if (burnTime > 0 && cfg.getConfig(CONFIG_FURNACE_BURNTIME)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.burnTime") + ": " + burnTime + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            }
            if (data.getPlayer().func_70093_af()) {
                ItemStack[] furnaceStacks = Utilities.getInventoryStacks(data.getNBTData(), 3);
                if (furnaceStacks[0] != null && cfg.getConfig(CONFIG_FURNACE_INPUT)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.input") + ": " + furnaceStacks[0].func_82833_r() + " X " + furnaceStacks[0].field_77994_a);
                }
                if (furnaceStacks[1] != null && cfg.getConfig(CONFIG_FURNACE_FUEL)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.fuel") + ": " + furnaceStacks[1].func_82833_r() + " X " + furnaceStacks[1].field_77994_a);
                }
                if (furnaceStacks[2] != null && cfg.getConfig(CONFIG_FURNACE_OUTPUT)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.output") + ": " + furnaceStacks[2].func_82833_r() + " X " + furnaceStacks[2].field_77994_a);
                }
            }
        }
        if (data.getTileEntity() instanceof TileEntitySkull && cfg.getConfig(CONFIG_PLAYER_SKULL) && data.getNBTData().func_74764_b("Owner")) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.owner") + ": " + NBTUtil.func_152459_a((NBTTagCompound)data.getNBTData().func_74775_l("Owner")).getName());
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonVanillaTiles dataProvider = new AddonVanillaTiles();
        register.addConfig("Wawla-Blocks", CONFIG_BEACON_LEVEL);
        register.addConfig("Wawla-Blocks", CONFIG_BEACON_PRIMARY);
        register.addConfig("Wawla-Blocks", CONFIG_BEACON_SECONDARY);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, BlockBeacon.class);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, BlockBeacon.class);
        register.addConfig("Wawla-Blocks", CONFIG_FURNACE_INPUT);
        register.addConfig("Wawla-Blocks", CONFIG_FURNACE_OUTPUT);
        register.addConfig("Wawla-Blocks", CONFIG_FURNACE_FUEL);
        register.addConfig("Wawla-Blocks", CONFIG_FURNACE_BURNTIME);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, BlockFurnace.class);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, BlockFurnace.class);
        register.addConfig("Wawla-Blocks", CONFIG_PLAYER_SKULL);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, BlockSkull.class);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, BlockSkull.class);
    }
}

