/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.SymbolProfiler;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.utility.WeightedItemSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class SymbolManager {
    private static HashMap<String, IAgeSymbol> ageSymbols = new HashMap();
    private static HashMap<String, String> owners = new HashMap();
    private static SymbolProfiler symbolProfiler = new SymbolProfiler();
    private static HashSet<String> errored = new HashSet();
    private static HashSet<String> warned = new HashSet();
    private static HashSet<String> blacklist = new HashSet();
    private static Configuration config;
    private static HashMap<String, Integer> cardranks;
    private static ArrayList<Integer> cardranksizes;
    private static HashMap<Integer, Integer> cardrankweights;
    private static HashMap<String, Integer> maxTreasureStackOverrides;
    private static HashMap<String, Boolean> tradeableOverrides;
    private static HashMap<String, List<ItemStack>> tradeItemOverrides;
    private static HashMap<Integer, Integer> defaultMaxStacks;

    public static void blackListSymbol(String identifier) {
        blacklist.add(identifier);
        IAgeSymbol symbol2 = ageSymbols.get(identifier);
        if (symbol2 != null) {
            SymbolManager.unregisterSymbol(symbol2);
        }
    }

    public static void setConfig(MystConfig mystconfig) {
        config = mystconfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerSymbol(IAgeSymbol symbol2, boolean generateConfigOption, String modid) {
        boolean enabled = true;
        if (symbol2.identifier() == null || symbol2.identifier().length() == 0) {
            LoggerUtils.error(String.format("Attempting to bind symbol with null or zero length identifier.", new Object[0]), new Object[0]);
            return false;
        }
        if (config != null && generateConfigOption && !config.get("symbol", symbol2.identifier().toLowerCase().replace(' ', '_') + ".enabled", enabled).getBoolean(enabled)) {
            return false;
        }
        if (SymbolRemappings.hasRemapping(symbol2.identifier())) {
            LoggerUtils.error(String.format("%s has a remapping binding.  No symbol can be bound to this name.", symbol2.identifier()), new Object[0]);
            return false;
        }
        if (blacklist.contains(symbol2.identifier())) {
            LoggerUtils.info(String.format("Symbol %s is turned off by blacklist.", symbol2.identifier()), new Object[0]);
            return false;
        }
        if (ageSymbols.get(symbol2.identifier()) != null) {
            String str = String.format("%s cannot register symbol with identifier %s. Already bound by %s.", modid, symbol2.identifier(), owners.get(symbol2.identifier()));
            LoggerUtils.error(str, new Object[0]);
            throw new RuntimeException(str);
        }
        symbolProfiler.startProfiling(symbol2);
        try {
            symbol2.registerLogic(symbolProfiler, 0L);
        }
        catch (Exception e) {
            LoggerUtils.error(String.format("Exception encountered when profiling symbol with identifier %s.", symbol2.identifier()), new Object[0]);
            LoggerUtils.error(e.toString(), new Object[0]);
            e.printStackTrace();
            SymbolManager.blackListSymbol(symbol2.identifier());
            errored.add(symbol2.identifier());
        }
        finally {
            symbolProfiler.endProfiling(symbol2);
            if (config != null && config.hasChanged()) {
                config.save();
            }
        }
        ageSymbols.put(symbol2.identifier(), symbol2);
        owners.put(symbol2.identifier(), modid);
        return true;
    }

    public static HashSet<String> getErroredSymbols() {
        return errored;
    }

    private static void unregisterSymbol(IAgeSymbol symbol2) {
        if (ageSymbols.get(symbol2.identifier()) == symbol2) {
            ageSymbols.remove(symbol2.identifier());
            symbolProfiler.remove(symbol2);
        }
    }

    public static IAgeSymbol getAgeSymbol(String id) {
        IAgeSymbol symbol2 = ageSymbols.get(id);
        if (symbol2 == null && warned.add(id)) {
            LoggerUtils.error(String.format("No Symbol match for identifier %s.  Are all of the Age Symbols loaded?", id), new Object[0]);
        }
        return symbol2;
    }

    public static boolean hasBinding(String id) {
        return ageSymbols.containsKey(id);
    }

    public static String getSymbolOwner(String identifier) {
        return owners.get(identifier);
    }

    public static ArrayList<IAgeSymbol> getAgeSymbols() {
        ArrayList<IAgeSymbol> symbols = new ArrayList<IAgeSymbol>();
        for (IAgeSymbol s : ageSymbols.values()) {
            symbols.add(s);
        }
        return symbols;
    }

    public static HashSet<IAgeSymbol> findAgeSymbolsImplementing(Class<?> Interface) {
        return symbolProfiler.getSymbolsProviding(Interface);
    }

    public static IAgeSymbol findAgeSymbolImplementing(Random rand, Class<?> instance) {
        return WeightedItemSelector.getRandomItem(rand, SymbolManager.findAgeSymbolsImplementing(instance));
    }

    public static Collection<IAgeSymbol> getSymbolsByRank(Integer exact) {
        return SymbolManager.getSymbolsByRank(exact, exact);
    }

    public static Collection<IAgeSymbol> getSymbolsByRank(Integer min, Integer max) {
        ArrayList<IAgeSymbol> set = new ArrayList<IAgeSymbol>();
        Set<String> symbolIds = ageSymbols.keySet();
        for (String symbolId : symbolIds) {
            Integer rank = SymbolManager.getSymbolItemCardRank(symbolId);
            if (rank == null || min != null && min > rank || max != null && max < rank) continue;
            set.add(ageSymbols.get(symbolId));
        }
        return set;
    }

    public static int getSymbolItemWeight(String identifier) {
        if (!cardranks.containsKey(identifier)) {
            return 0;
        }
        Integer rank = cardranks.get(identifier);
        if (rank == null) {
            return 0;
        }
        if (cardrankweights == null) {
            throw new RuntimeException("Cannot obtain symbol treasure weight: Card ranking system not built");
        }
        return cardrankweights.get(rank);
    }

    public static void setSymbolItemCardRank(String identifier, int cardrank) {
        if (cardrankweights != null) {
            throw new RuntimeException("Cannot set symbol rarity ranking: rank weights finalized");
        }
        cardranks.put(identifier, cardrank);
        while (cardranksizes.size() <= cardrank) {
            cardranksizes.add(0);
        }
        cardranksizes.set(cardrank, cardranksizes.get(cardrank) + 1);
    }

    public static Integer getSymbolItemCardRank(String identifier) {
        return cardranks.get(identifier);
    }

    public static int getSymbolTreasureMaxStack(IAgeSymbol symbol2) {
        Integer rank = SymbolManager.getSymbolItemCardRank(symbol2.identifier());
        Integer dfault = defaultMaxStacks.get(rank);
        if (dfault == null) {
            dfault = 1;
        }
        if (!maxTreasureStackOverrides.containsKey(symbol2.identifier())) {
            return dfault;
        }
        Integer override = maxTreasureStackOverrides.get(symbol2.identifier());
        if (override == null) {
            return dfault;
        }
        return override;
    }

    public static void setSymbolTreasureMaxStack(String identifier, int override) {
        maxTreasureStackOverrides.put(identifier, override);
    }

    public static boolean isSymbolTradable(String identifier) {
        boolean dfault;
        boolean bl = dfault = SymbolManager.getSymbolItemWeight(identifier) > 0;
        if (!tradeableOverrides.containsKey(identifier)) {
            return dfault;
        }
        Boolean override = tradeableOverrides.get(identifier);
        if (override == null) {
            return dfault;
        }
        return override;
    }

    public static void setSymbolIsTradable(String identifier, boolean override) {
        tradeableOverrides.put(identifier, override);
    }

    public static List<ItemStack> getSymbolTradeItems(String identifier) {
        ItemStack dfault = new ItemStack(Items.field_151166_bC, Math.max(1, (int)(12.0f * (float)SymbolManager.getSymbolItemCardRank(identifier).intValue())));
        if (!tradeItemOverrides.containsKey(identifier)) {
            return Arrays.asList(dfault);
        }
        List<ItemStack> override = tradeItemOverrides.get(identifier);
        if (override == null) {
            return Arrays.asList(dfault);
        }
        return override;
    }

    public static void setSymbolTradeItems(String identifier, ItemStack primary, ItemStack secondary) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (primary != null) {
            list.add(primary.func_77946_l());
        }
        if (secondary != null) {
            list.add(secondary.func_77946_l());
        }
        if (list.size() > 0) {
            tradeItemOverrides.put(identifier, list);
        } else {
            SymbolManager.setSymbolIsTradable(identifier, false);
        }
    }

    public static void buildCardRanks() {
        boolean step = true;
        cardrankweights = new HashMap();
        int weight = 1;
        int lasttotal = 0;
        for (int i = cardranksizes.size() - 1; i >= 0; --i) {
            int count = cardranksizes.get(i);
            if (weight != 1 && count > 0) {
                weight = Math.max(weight, lasttotal / count + 1);
            }
            cardrankweights.put(i, weight);
            lasttotal = count * weight;
            ++weight;
        }
    }

    public static void registerRules() {
        ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
        for (IAgeSymbol symbol2 : symbols) {
            ArrayList<GrammarGenerator.Rule> rules;
            if (!(symbol2 instanceof SymbolBase) || (rules = ((SymbolBase)symbol2).getRules()) == null) continue;
            for (GrammarGenerator.Rule rule : rules) {
                GrammarGenerator.registerRule(rule);
            }
        }
    }

    static {
        cardranks = new HashMap();
        cardranksizes = new ArrayList();
        cardrankweights = null;
        maxTreasureStackOverrides = new HashMap();
        tradeableOverrides = new HashMap();
        tradeItemOverrides = new HashMap();
        defaultMaxStacks = new HashMap();
        defaultMaxStacks.put(null, 0);
        defaultMaxStacks.put(0, 16);
        defaultMaxStacks.put(1, 8);
        defaultMaxStacks.put(2, 4);
        defaultMaxStacks.put(3, 2);
    }
}

