/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.api.world.logic.ICelestial;
import com.xcompwiz.mystcraft.api.world.logic.IChunkProviderFinalization;
import com.xcompwiz.mystcraft.api.world.logic.IDynamicColorProvider;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import com.xcompwiz.mystcraft.api.world.logic.ILightingController;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.api.world.logic.ISpawnModifier;
import com.xcompwiz.mystcraft.api.world.logic.IStaticColorProvider;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainFeatureLocator;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainGenerator;
import com.xcompwiz.mystcraft.api.world.logic.IWeatherController;
import com.xcompwiz.mystcraft.api.world.logic.Modifier;
import com.xcompwiz.mystcraft.client.render.CloudRendererMyst;
import com.xcompwiz.mystcraft.client.render.WeatherRendererMyst;
import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.debug.DefaultValueCallback;
import com.xcompwiz.mystcraft.instability.InstabilityController;
import com.xcompwiz.mystcraft.instability.InstabilityData;
import com.xcompwiz.mystcraft.instability.bonus.InstabilityBonusManager;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.world.SkyRendererMyst;
import com.xcompwiz.mystcraft.world.WorldChunkManagerMyst;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfiler;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfilerManager;
import com.xcompwiz.util.SpiralOutwardIterator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;

public class AgeController
implements AgeDirector {
    private static final int MINCHUNKS = 400;
    private World world;
    private WorldChunkManager chunkManager;
    private SkyRendererMyst skyrenderer;
    private CloudRendererMyst cloudrenderer;
    private WeatherRendererMyst weatherrenderer;
    private AgeData agedata;
    private InstabilityController instabilityController;
    private InstabilityBonusManager instabilitybonusmanager;
    private Random symbolseedrand;
    private IBiomeController biomeController;
    private IWeatherController weatherController;
    private ITerrainGenerator genTerrain;
    private ILightingController lightingController;
    private List<ICelestial> celestials;
    private List<ICelestial> suns;
    private List<ITerrainAlteration> terrainalterations;
    private List<IChunkProviderFinalization> chunkfinalizers;
    private List<IPopulate> populateFuncs;
    private List<ITerrainFeatureLocator> featureLocators;
    private List<IStaticColorProvider> foliageColorProviders;
    private List<IStaticColorProvider> grassColorProviders;
    private List<IStaticColorProvider> waterColorProviders;
    private List<IDynamicColorProvider> cloudColorProviders;
    private List<IDynamicColorProvider> fogColorProviders;
    private List<IDynamicColorProvider> skyColorProviders;
    private List<ISpawnModifier> creatureAffecters;
    private List<IEnvironmentalEffect> envEffects;
    private HashMap<String, List<IDynamicColorProvider>> dynamicColorLists = new HashMap();
    private HashMap<String, List<IStaticColorProvider>> staticColorLists = new HashMap();
    private Float cloudHeight;
    private Double horizon;
    private Integer groundlevel;
    private Integer sealevel;
    private Boolean renderHorizon;
    private Boolean renderVoid;
    private Boolean pvpEnabled;
    private HashMap<String, Modifier> modifiers;
    private HashMap<String, Modifier> globalMods;
    private int nextprofiled;
    private int symbolinstability;
    private Integer blockinstability = null;
    private HashMap<IAgeSymbol, Integer> symbolcounts = new HashMap();
    protected int debuginstability = 0;
    private Semaphore semaphore = new Semaphore(1, true);
    private boolean rebuilding;

    public AgeController(World worldObj, AgeData age) {
        this.world = worldObj;
        this.agedata = age;
        this.chunkManager = new WorldChunkManagerMyst(this);
        this.skyrenderer = new SkyRendererMyst((WorldProviderMyst)this.world.field_73011_w, this);
        this.cloudrenderer = new CloudRendererMyst((WorldProviderMyst)this.world.field_73011_w, this);
        this.weatherrenderer = new WeatherRendererMyst((WorldProviderMyst)this.world.field_73011_w, this);
        this.reconstruct();
    }

    private void validate() {
        try {
            if (this.agedata.isUpdated()) {
                this.semaphore.acquire();
                this.rebuilding = true;
                this.reconstruct();
                this.rebuilding = false;
                this.semaphore.release();
            }
            while (this.rebuilding) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void reconstruct() {
        IAgeSymbol symbol2;
        this.agedata.onConstruct();
        long seed = this.agedata.getSeed();
        this.symbolseedrand = new Random(seed);
        this.dynamicColorLists.clear();
        this.staticColorLists.clear();
        this.biomeController = null;
        this.weatherController = null;
        this.genTerrain = null;
        this.lightingController = null;
        this.celestials = new ArrayList<ICelestial>();
        this.suns = new ArrayList<ICelestial>();
        this.terrainalterations = new ArrayList<ITerrainAlteration>();
        this.chunkfinalizers = new ArrayList<IChunkProviderFinalization>();
        this.populateFuncs = new ArrayList<IPopulate>();
        this.featureLocators = new ArrayList<ITerrainFeatureLocator>();
        this.cloudColorProviders = new ArrayList<IDynamicColorProvider>();
        this.fogColorProviders = new ArrayList<IDynamicColorProvider>();
        this.skyColorProviders = new ArrayList<IDynamicColorProvider>();
        this.foliageColorProviders = new ArrayList<IStaticColorProvider>();
        this.grassColorProviders = new ArrayList<IStaticColorProvider>();
        this.waterColorProviders = new ArrayList<IStaticColorProvider>();
        this.creatureAffecters = new ArrayList<ISpawnModifier>();
        this.envEffects = new ArrayList<IEnvironmentalEffect>();
        this.cloudHeight = null;
        this.horizon = null;
        this.groundlevel = null;
        this.sealevel = null;
        this.renderHorizon = null;
        this.renderVoid = null;
        this.pvpEnabled = null;
        this.globalMods = new HashMap();
        this.modifiers = new HashMap();
        this.symbolinstability = 0;
        this.instabilityController = null;
        this.dynamicColorLists.put("cloud", this.cloudColorProviders);
        this.dynamicColorLists.put("fog", this.fogColorProviders);
        this.dynamicColorLists.put("sky", this.skyColorProviders);
        this.staticColorLists.put("foliage", this.foliageColorProviders);
        this.staticColorLists.put("grass", this.grassColorProviders);
        this.staticColorLists.put("water", this.waterColorProviders);
        ArrayList<String> symbols = new ArrayList<String>(this.agedata.getSymbols(this.world.field_72995_K));
        for (String name : symbols) {
            IAgeSymbol symbol3 = SymbolManager.getAgeSymbol(name);
            if (symbol3 == null) {
                LoggerUtils.error("Attempting to generate age containing unmatched symbol " + name + ".  Results are undefined.", new Object[0]);
                continue;
            }
            this.addSymbol(symbol3);
        }
        if (this.biomeController == null) {
            symbol2 = SymbolManager.findAgeSymbolImplementing(new Random(this.agedata.getSeed()), IBiomeController.class);
            this.addSymbol(symbol2);
            this.agedata.addSymbol(symbol2.identifier(), InstabilityData.missing.controller);
        }
        if (this.genTerrain == null) {
            symbol2 = SymbolManager.findAgeSymbolImplementing(new Random(this.agedata.getSeed()), ITerrainGenerator.class);
            this.addSymbol(symbol2);
            this.agedata.addSymbol(symbol2.identifier(), InstabilityData.missing.controller);
        }
        if (this.lightingController == null) {
            symbol2 = SymbolManager.findAgeSymbolImplementing(new Random(this.agedata.getSeed()), ILightingController.class);
            this.addSymbol(symbol2);
            this.agedata.addSymbol(symbol2.identifier(), 0);
        }
        if (this.weatherController == null) {
            symbol2 = SymbolManager.findAgeSymbolImplementing(new Random(this.agedata.getSeed()), IWeatherController.class);
            this.addSymbol(symbol2);
            this.agedata.addSymbol(symbol2.identifier(), InstabilityData.missing.controller);
        }
        this.weatherController.setDataObject(this.agedata.getStorageObject("weather"));
        for (Modifier mod : this.modifiers.values()) {
            this.symbolinstability += mod.dangling;
        }
        this.globalMods.putAll(this.modifiers);
        this.modifiers.clear();
        this.lightingController.generateLightBrightnessTable(this.world.field_73011_w.field_76573_f);
        this.agedata.markVisited();
    }

    private void addSymbol(IAgeSymbol symbol2) {
        symbol2.registerLogic(this, this.symbolseedrand.nextLong());
        Integer count = this.symbolcounts.get(symbol2);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.symbolcounts.put(symbol2, count);
        this.symbolinstability += symbol2.instabilityModifier(count);
    }

    public void registerDebugInfo(DebugHierarchy.DebugNode node) {
        final ChunkProfiler profiler = this.getChunkProfiler();
        final InstabilityBonusManager bonusmanager = this.getInstabilityBonusManager();
        node.getOrCreateNode("experimental").addChild("mark_dead", new DebugHierarchy.DebugTaskCallback(){

            @Override
            public void run(ICommandSender agent, Object ... args) {
                int dimid = ((AgeController)AgeController.this).world.field_73011_w.field_76574_g;
                if (DimensionUtils.markDimensionDead(dimid)) {
                    agent.func_145747_a((IChatComponent)new ChatComponentText("Dimension " + dimid + " marked as dead."));
                } else {
                    agent.func_145747_a((IChatComponent)new ChatComponentText("ERROR: Could not mark dimension " + dimid + " as dead."));
                }
            }
        });
        node.addChild("profiled_chunks", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + profiler.getCount();
            }
        });
        node = node.getOrCreateNode("instability");
        node.addChild("symbols", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + AgeController.this.symbolinstability;
            }
        });
        node.addChild("debug", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + AgeController.this.debuginstability;
            }

            @Override
            public void set(ICommandSender agent, String value) {
                AgeController.this.debuginstability = Integer.getInteger(value);
            }
        });
        node.addChild("book", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + AgeController.this.agedata.getBaseInstability();
            }
        });
        node.addChild("total", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + (AgeController.this.symbolinstability + (AgeController.this.blockinstability == null ? 0 : AgeController.this.blockinstability) + AgeController.this.agedata.getBaseInstability() + AgeController.this.getInstabilityBonusManager().getResult());
            }
        });
        node.addChild("bonus_total", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + bonusmanager.getResult();
            }
        });
        node.addChild("blocks_total", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + AgeController.this.blockinstability;
            }
        });
        bonusmanager.registerDebugInfo(node.getOrCreateNode("bonus"));
        profiler.registerDebugInfo(node.getOrCreateNode("blocks"));
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D();
    }

    public boolean isInstabilityEnabled() {
        return Mystcraft.instabilityEnabled && this.agedata.isInstabilityEnabled();
    }

    @Override
    public int getInstabilityScore() {
        if (this.rebuilding) {
            throw new RuntimeException("Someone is trying to grab the world instability score before the world is built!");
        }
        int profiled = this.getChunkProfiler().getCount();
        if (profiled < 400 || profiled > this.nextprofiled || this.blockinstability == null) {
            this.nextprofiled = profiled + 100;
            this.updateProfiledInstability();
        }
        if (this.blockinstability == null) {
            return 0;
        }
        int score = this.debuginstability + this.symbolinstability + this.blockinstability + this.agedata.getBaseInstability() + this.getInstabilityBonusManager().getResult();
        int difficulty = Mystcraft.difficulty;
        switch (difficulty) {
            case 0: {
                score = (int)((float)score * 0.25f);
                break;
            }
            case 1: {
                score = (int)((float)score * 0.5f);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                score = (int)((float)score * 1.75f);
            }
        }
        return score;
    }

    public void updateProfiledInstability() {
        ChunkProfiler profiler = this.getChunkProfiler();
        int chunksneeded = 400 - this.getChunkProfiler().getCount();
        if (chunksneeded > 0 && ChunkProfilerManager.getSize() < chunksneeded) {
            this.expandChunkProfile();
        }
        if (this.getChunkProfiler().getCount() > 400) {
            this.blockinstability = profiler.calculateInstability();
        }
    }

    private void expandChunkProfile() {
        if (!(this.world instanceof WorldServer)) {
            return;
        }
        ChunkProfiler profiler = this.getChunkProfiler();
        ChunkCoordinates chunkcoordinates = this.world.func_72861_E();
        chunkcoordinates.field_71574_a >>= 4;
        chunkcoordinates.field_71573_c >>= 4;
        ChunkProviderServer chunkgen = ((WorldServer)this.world).field_73059_b;
        IChunkLoader chunkloader = ((WorldServer)this.world).field_73059_b.field_73247_e;
        SpiralOutwardIterator iter = new SpiralOutwardIterator();
        int chunksneeded = 400 - profiler.getCount();
        while (chunksneeded > 0 && ChunkProfilerManager.getSize() < chunksneeded) {
            iter.step();
            int chunkX = chunkcoordinates.field_71574_a + iter.x;
            int chunkZ = chunkcoordinates.field_71573_c + iter.y;
            if (this.safeLoadChunk(chunkloader, this.world, chunkX, chunkZ) == null) {
                chunkgen.func_73158_c(chunkX, chunkZ);
            }
            chunksneeded = 400 - profiler.getCount();
        }
    }

    private Chunk safeLoadChunk(IChunkLoader chunkloader, World worldObj, int par1, int par2) {
        if (chunkloader == null) {
            return null;
        }
        try {
            return chunkloader.func_75815_a(worldObj, par1, par2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public float getCloudHeight() {
        return this.cloudHeight != null ? this.cloudHeight.floatValue() : 128.0f;
    }

    @Override
    public double getHorizon() {
        return this.horizon != null ? this.horizon : 63.0;
    }

    @Override
    public int getAverageGroundLevel() {
        return this.groundlevel != null ? this.groundlevel : 64;
    }

    @Override
    public int getSeaLevel() {
        return this.sealevel != null ? this.sealevel : 63;
    }

    public boolean shouldRenderHorizon() {
        return this.renderHorizon != null ? this.renderHorizon : true;
    }

    public boolean shouldRenderVoid() {
        return this.renderVoid != null ? this.renderVoid : true;
    }

    public boolean isPvPEnabled() {
        return this.pvpEnabled != null ? this.pvpEnabled : true;
    }

    public Vec3 getFogColor(Entity entity, BiomeGenBase biome, float time, float celestial_angle, float partialtick) {
        this.validate();
        if (this.fogColorProviders == null || this.fogColorProviders.size() == 0) {
            return null;
        }
        Vec3 color = null;
        for (IDynamicColorProvider mod : this.fogColorProviders) {
            Color op = mod.getColor(entity, biome, time, celestial_angle, partialtick);
            if (op == null) continue;
            if (color == null) {
                color = Vec3.func_72443_a((double)op.r, (double)op.g, (double)op.b);
                continue;
            }
            color.field_72450_a = (color.field_72450_a + (double)op.r) / 2.0;
            color.field_72448_b = (color.field_72448_b + (double)op.g) / 2.0;
            color.field_72449_c = (color.field_72449_c + (double)op.b) / 2.0;
        }
        return color;
    }

    public Vec3 getCloudColor(Entity entity, BiomeGenBase biome, float time, float celestial_angle, float partialtick) {
        this.validate();
        if (this.cloudColorProviders == null || this.cloudColorProviders.size() == 0) {
            return null;
        }
        Vec3 color = null;
        for (IDynamicColorProvider mod : this.cloudColorProviders) {
            Color op = mod.getColor(entity, biome, time, celestial_angle, partialtick);
            if (op == null) continue;
            if (color == null) {
                color = Vec3.func_72443_a((double)op.r, (double)op.g, (double)op.b);
                continue;
            }
            color.field_72450_a = (color.field_72450_a + (double)op.r) / 2.0;
            color.field_72448_b = (color.field_72448_b + (double)op.g) / 2.0;
            color.field_72449_c = (color.field_72449_c + (double)op.b) / 2.0;
        }
        return color;
    }

    @Override
    public ColorGradient getSunriseSunsetColor() {
        Modifier sunset = this.globalMods.get("sunset");
        if (sunset == null) {
            return null;
        }
        return sunset.asGradient();
    }

    public Vec3 getSkyColor(Entity entity, BiomeGenBase biome, float time, float celestial_angle, float partialtick) {
        this.validate();
        if (this.skyColorProviders == null || this.skyColorProviders.size() == 0) {
            return null;
        }
        Vec3 color = null;
        for (IDynamicColorProvider mod : this.skyColorProviders) {
            Color op = mod.getColor(entity, biome, time, celestial_angle, partialtick);
            if (op == null) continue;
            if (color == null) {
                color = Vec3.func_72443_a((double)op.r, (double)op.g, (double)op.b);
                continue;
            }
            color.field_72450_a = (color.field_72450_a + (double)op.r) / 2.0;
            color.field_72448_b = (color.field_72448_b + (double)op.g) / 2.0;
            color.field_72449_c = (color.field_72449_c + (double)op.b) / 2.0;
        }
        return color;
    }

    public Color getStaticColor(String string, BiomeGenBase biome, int x, int y, int z) {
        this.validate();
        List<IStaticColorProvider> list = this.staticColorLists.get(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        Color color = null;
        for (IStaticColorProvider mod : list) {
            Color op = mod.getStaticColor(this.world, biome, x, y, z);
            if (op == null) continue;
            if (color == null) {
                color = new Color(op.r, op.g, op.b);
                continue;
            }
            color.average(op);
        }
        return color;
    }

    private InstabilityController getInstabilityController() {
        if (this.instabilityController == null) {
            this.instabilityController = new InstabilityController((WorldProviderMyst)this.world.field_73011_w, this);
        }
        return this.instabilityController;
    }

    private InstabilityBonusManager getInstabilityBonusManager() {
        if (this.instabilitybonusmanager == null) {
            this.instabilitybonusmanager = new InstabilityBonusManager((WorldProviderMyst)this.world.field_73011_w, this);
        }
        return this.instabilitybonusmanager;
    }

    public IBiomeController getBiomeController() {
        this.validate();
        return this.biomeController;
    }

    public IWeatherController getWeatherController() {
        this.validate();
        return this.weatherController;
    }

    public ILightingController getLightingController() {
        this.validate();
        return this.lightingController;
    }

    public ITerrainGenerator getTerrainGenerator() {
        this.validate();
        return this.genTerrain;
    }

    public ChunkProfiler getChunkProfiler() {
        ChunkProfiler chunkprofiler = (ChunkProfiler)this.world.perWorldStorage.func_75742_a(ChunkProfiler.class, "MystChunkProfile");
        if (chunkprofiler == null) {
            chunkprofiler = new ChunkProfiler("MystChunkProfile");
            this.world.perWorldStorage.func_75745_a("MystChunkProfile", (WorldSavedData)chunkprofiler);
        }
        return chunkprofiler;
    }

    public void modifyBiomeAt(BiomeGenBase biome, int x, int z) {
        this.validate();
    }

    public void modifyBiomesAt(BiomeGenBase[] abiomegenbase, int x, int z, int xSize, int zSize, boolean usecache) {
        this.validate();
    }

    public void modifyGenerationBiomesAt(BiomeGenBase[] abiomegenbase, int x, int z, int xSize, int zSize) {
        this.validate();
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
        this.validate();
        this.getTerrainGenerator().generateTerrain(chunkX, chunkZ, blocks, metadata);
    }

    public void modifyTerrain(int chunkX, int chunkZ, Block[] blocks, byte[] metadata) {
        this.validate();
        if (this.terrainalterations != null && this.terrainalterations.size() > 0) {
            for (ITerrainAlteration mod : this.terrainalterations) {
                mod.alterTerrain(this.world, chunkX, chunkZ, blocks, metadata);
            }
        }
    }

    public void finalizeChunk(Chunk chunk, int chunkX, int chunkZ) {
        this.validate();
        if (this.chunkfinalizers != null && this.chunkfinalizers.size() > 0) {
            for (IChunkProviderFinalization mod : this.chunkfinalizers) {
                mod.finalizeChunk(chunk, chunkX, chunkZ);
            }
        }
    }

    public void populate(World worldObj, Random rand, int i, int j) {
        this.validate();
        if (this.populateFuncs != null && this.populateFuncs.size() > 0) {
            boolean flag = false;
            for (IPopulate mod : this.populateFuncs) {
                flag = flag || mod.populate(worldObj, rand, i, j, flag);
            }
        }
    }

    public void tickBlocksAndAmbiance(Chunk chunk) {
        this.getWeatherController().tick(this.world, chunk);
        if (this.envEffects != null && this.envEffects.size() > 0) {
            for (IEnvironmentalEffect effect : this.envEffects) {
                effect.tick(this.world, chunk);
            }
        }
        this.getInstabilityController().tick(this.world, chunk);
    }

    public void tick() {
        if (this.world.field_72995_K) {
            return;
        }
        this.getInstabilityBonusManager().tick(this.world);
    }

    public List<BiomeGenBase.SpawnListEntry> affectCreatureList(EnumCreatureType enumcreaturetype, List<BiomeGenBase.SpawnListEntry> list, int i, int j, int k) {
        this.validate();
        if (list == null) {
            list = new ArrayList<BiomeGenBase.SpawnListEntry>();
        }
        return list;
    }

    public ChunkPosition locateTerrainFeature(World world, String s, int i, int j, int k) {
        this.validate();
        if (this.featureLocators == null || this.featureLocators.size() == 0) {
            return null;
        }
        ChunkPosition found = null;
        for (ITerrainFeatureLocator mod : this.featureLocators) {
            found = mod.locate(world, s, i, j, k);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    public int scaleLighting(int blockLightValue) {
        this.validate();
        return this.getLightingController().scaleLighting(blockLightValue);
    }

    public void generateLightBrightnessTable(float[] lightBrightnessTable) {
        this.validate();
        this.getLightingController().generateLightBrightnessTable(lightBrightnessTable);
    }

    public float calculateCelestialAngle(long time, float f1) {
        this.validate();
        float lowest = 0.5f;
        float highest = 0.5f;
        for (ICelestial sun : this.suns) {
            float temp;
            for (temp = sun.getAltitudeAngle(time, f1); temp < 0.0f; temp += 1.0f) {
            }
            while (temp > 1.0f) {
                temp -= 1.0f;
            }
            if (temp > highest) {
                highest = temp;
            }
            if (!(temp < lowest)) continue;
            lowest = temp;
        }
        if (1.0f - highest < lowest) {
            return highest;
        }
        return lowest;
    }

    public long getTimeToSunrise(long time) {
        Long result = null;
        for (ICelestial sun : this.suns) {
            Long temp = sun.getTimeToDawn(time);
            if (temp == null || result != null && temp >= result) continue;
            result = temp;
        }
        if (result == null) {
            long dayinterval = 24000L;
            return dayinterval - time % dayinterval;
        }
        return result;
    }

    public float getTemperatureAtHeight(float temp, int y) {
        return temp;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCelestials(TextureManager eng, World worldObj, float partial) {
        for (ICelestial celestial : this.celestials) {
            celestial.render(eng, worldObj, partial);
        }
    }

    @Override
    public long getSeed() {
        return this.agedata.getSeed();
    }

    @Override
    public WorldChunkManager getWorldChunkManager() {
        return this.chunkManager;
    }

    public SkyRendererMyst getSkyRenderer() {
        return this.skyrenderer;
    }

    public CloudRendererMyst getCloudRenderer() {
        return this.cloudrenderer;
    }

    public WeatherRendererMyst getWeatherRenderer() {
        return this.weatherrenderer;
    }

    @Override
    public void addInstability(int instability) {
        this.symbolinstability += instability;
    }

    @Override
    public void setCloudHeight(float height) {
        this.cloudHeight = this.cloudHeight == null ? Float.valueOf(height) : Float.valueOf((this.cloudHeight.floatValue() + height) / 2.0f);
    }

    @Override
    public void setHorizon(double height) {
        this.horizon = this.horizon == null ? Double.valueOf(height) : Double.valueOf((this.horizon + height) / 2.0);
    }

    @Override
    public void setAverageGroundLevel(int height) {
        this.groundlevel = this.groundlevel != null ? Integer.valueOf((this.groundlevel + height) / 2) : Integer.valueOf(height);
    }

    @Override
    public void setSeaLevel(int height) {
        this.sealevel = this.sealevel != null ? Integer.valueOf((this.sealevel + height) / 2) : Integer.valueOf(height);
    }

    @Override
    public void setDrawHorizon(boolean flag) {
        this.renderHorizon = flag;
    }

    @Override
    public void setDrawVoid(boolean flag) {
        this.renderVoid = flag;
    }

    @Override
    public void setPvPEnabled(boolean flag) {
        this.pvpEnabled = flag;
    }

    @Override
    public void registerInterface(IBiomeController controller) {
        if (this.biomeController != null) {
            this.symbolinstability += InstabilityData.extra.controller;
        }
        this.biomeController = controller;
    }

    @Override
    public void registerInterface(ITerrainGenerator terrainGen) {
        if (this.genTerrain != null) {
            this.symbolinstability += InstabilityData.extra.controller;
        }
        this.genTerrain = terrainGen;
    }

    @Override
    public void registerInterface(ILightingController reg) {
        if (this.lightingController != null) {
            this.symbolinstability += InstabilityData.extra.controller;
        }
        this.lightingController = reg;
    }

    @Override
    public void registerInterface(IWeatherController reg) {
        if (this.weatherController != null) {
            this.symbolinstability += InstabilityData.extra.controller;
        }
        this.weatherController = reg;
    }

    @Override
    public void registerInterface(ICelestial reg) {
        this.celestials.add(reg);
        if (reg.providesLight()) {
            this.suns.add(reg);
        }
    }

    @Override
    public void registerInterface(ITerrainAlteration reg) {
        this.terrainalterations.add(reg);
    }

    @Override
    public void registerInterface(IChunkProviderFinalization reg) {
        this.chunkfinalizers.add(reg);
    }

    @Override
    public void registerInterface(IPopulate reg) {
        this.populateFuncs.add(reg);
    }

    @Override
    public void registerInterface(ITerrainFeatureLocator reg) {
        this.featureLocators.add(reg);
    }

    @Override
    public void registerInterface(IDynamicColorProvider reg, String type) {
        List<IDynamicColorProvider> list = this.dynamicColorLists.get(type);
        if (list == null) {
            throw new RuntimeException("Invalid Dynamic Color Provider Type");
        }
        list.add(reg);
    }

    @Override
    public void registerInterface(IStaticColorProvider reg, String type) {
        List<IStaticColorProvider> list = this.staticColorLists.get(type);
        if (list == null) {
            throw new RuntimeException("Invalid Static Color Provider Type");
        }
        list.add(reg);
    }

    @Override
    public void registerInterface(ISpawnModifier reg) {
        this.creatureAffecters.add(reg);
    }

    @Override
    public void registerInterface(IEnvironmentalEffect reg) {
        this.envEffects.add(reg);
    }

    @Override
    public Modifier popModifier(String id) {
        if (this.modifiers.containsKey(id)) {
            return this.modifiers.remove(id);
        }
        return new Modifier();
    }

    @Override
    public void setModifier(String id, Object obj) {
        this.setModifier(id, new Modifier(obj));
    }

    @Override
    public void setModifier(String id, Modifier val) {
        if (val == null) {
            throw new RuntimeException("Something tried to register a null modifier!");
        }
        if (this.modifiers.containsKey(id)) {
            this.symbolinstability += this.modifiers.get((Object)id).dangling;
        }
        this.modifiers.put(id, val);
    }

    @Override
    public void clearModifiers() {
        for (Modifier mod : this.modifiers.values()) {
            this.symbolinstability = (int)((float)this.symbolinstability + (float)mod.dangling * InstabilityData.clearPercentage);
        }
        this.modifiers.clear();
    }
}

