/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class ExternalSaveHandler
implements ISaveHandler {
    private final File mapDataDir;
    private final long initializationTime = MinecraftServer.func_130071_aq();
    private final String saveDirectoryName;

    public ExternalSaveHandler(File directory, String savename) {
        this.mapDataDir = new File(directory, savename);
        this.mapDataDir.mkdirs();
        this.saveDirectoryName = savename;
        this.setSessionLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionLock() {
        try {
            File file1 = new File(this.mapDataDir, "session.lock");
            DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));
            try {
                dataoutputstream.writeLong(this.initializationTime);
            }
            finally {
                dataoutputstream.close();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    public File func_75765_b() {
        return this.mapDataDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_75762_c() throws MinecraftException {
        try {
            File file1 = new File(this.mapDataDir, "session.lock");
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(file1));
            try {
                if (datainputstream.readLong() != this.initializationTime) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                datainputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    public IChunkLoader func_75763_a(WorldProvider p_75763_1_) {
        throw new RuntimeException("Chunk storage is not supported on this save handler");
    }

    public WorldInfo func_75757_d() {
        throw new RuntimeException("World info is not supported on this save handler");
    }

    public void func_75755_a(WorldInfo p_75755_1_, NBTTagCompound p_75755_2_) {
    }

    public void func_75761_a(WorldInfo p_75761_1_) {
    }

    public void writePlayerData(EntityPlayer p_75753_1_) {
    }

    public NBTTagCompound readPlayerData(EntityPlayer p_75752_1_) {
        throw new RuntimeException("Player data is not supported on this save handler");
    }

    public IPlayerFileData func_75756_e() {
        return null;
    }

    public String[] getAvailablePlayerDat() {
        throw new RuntimeException("Player data is not supported on this save handler");
    }

    public void func_75759_a() {
    }

    public File func_75758_b(String dataname) {
        return new File(this.mapDataDir, dataname + ".dat");
    }

    public String func_75760_g() {
        return this.saveDirectoryName;
    }

    public NBTTagCompound getPlayerNBT(EntityPlayerMP player) {
        return null;
    }
}

