/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.aquatweaks.api.IAquaConnectable;
import blusunrize.immersiveengineering.api.AdvancedAABB;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.render.BlockRenderMetalDevices2;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.ItemBlockMetalDevices2;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBlastFurnacePreheater;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBreakerSwitch;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCapacitorCreative;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityChargingStation;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityElectricLantern;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityEnergyMeter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFloodlight;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPump;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalBarrel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRedstoneBreaker;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySkycrateDispenser;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.IC2Helper;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

@Optional.Interface(iface="blusunrize.aquatweaks.api.IAquaConnectable", modid="AquaTweaks")
public class BlockMetalDevices2
extends BlockIEBase
implements IEBlockInterfaces.ICustomBoundingboxes,
IAquaConnectable {
    public static final int META_breakerSwitch = 0;
    public static final int META_skycrateDispenser = 1;
    public static final int META_energyMeter = 2;
    public static final int META_electricLantern = 3;
    public static final int META_floodlight = 4;
    public static final int META_fluidPipe = 5;
    public static final int META_fluidPump = 6;
    public static final int META_barrel = 7;
    public static final int META_capacitorCreative = 8;
    public static final int META_redstoneBreaker = 9;
    public static final int META_chargingStation = 10;
    public static final int META_blastFurnacePreheater = 11;
    IIcon[] iconPump = new IIcon[7];
    IIcon iconFloodlightGlass;
    IIcon[] iconBarrel = new IIcon[4];
    IIcon[][] iconCap = new IIcon[3][3];

    public BlockMetalDevices2() {
        super("metalDevice2", Material.field_151573_f, 1, ItemBlockMetalDevices2.class, "breakerSwitch", "skycrateDispenser", "energyMeter", "electricLantern", "floodlight", "fluidPipe", "fluidPump", "barrel", "capacitorCreative", "redstoneBreaker", "chargingStation", "blastFurnacePreheater");
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.setMetaLightOpacity(7, 255);
    }

    @Override
    public boolean allowHammerHarvest(int meta) {
        return true;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 6));
        list.add(new ItemStack(item, 1, 7));
        list.add(new ItemStack(item, 1, 8));
        list.add(new ItemStack(item, 1, 9));
        list.add(new ItemStack(item, 1, 10));
        list.add(new ItemStack(item, 1, 11));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        int i;
        for (i = 0; i < this.subNames.length; ++i) {
            if (i == 6 || i == 8) continue;
            this.icons[i][0] = iconRegister.func_94245_a("immersiveEngineering:metal2_" + this.subNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            String s = i == 0 ? "none" : (i == 1 ? "in" : "out");
            this.iconCap[0][i] = iconRegister.func_94245_a("immersiveengineering:metal2_capacitorCreative_bottom_" + s);
            this.iconCap[1][i] = iconRegister.func_94245_a("immersiveengineering:metal2_capacitorCreative_top_" + s);
            this.iconCap[2][i] = iconRegister.func_94245_a("immersiveengineering:metal2_capacitorCreative_side_" + s);
        }
        this.iconFloodlightGlass = iconRegister.func_94245_a("immersiveEngineering:metal2_floodlightGlass");
        this.iconPump[0] = iconRegister.func_94245_a("immersiveEngineering:metal2_pump_side_none");
        this.iconPump[1] = iconRegister.func_94245_a("immersiveEngineering:metal2_pump_side_in");
        this.iconPump[2] = iconRegister.func_94245_a("immersiveEngineering:metal2_pump_side_out");
        this.iconPump[3] = iconRegister.func_94245_a("immersiveEngineering:metal2_pump_bottom_none");
        this.iconPump[4] = iconRegister.func_94245_a("immersiveEngineering:metal2_pump_bottom_in");
        this.iconPump[5] = iconRegister.func_94245_a("immersiveEngineering:metal2_pump_bottom_out");
        this.iconPump[6] = iconRegister.func_94245_a("immersiveEngineering:metal2_pump_top");
        this.iconBarrel[0] = iconRegister.func_94245_a("immersiveengineering:metal2_barrel_top_none");
        this.iconBarrel[1] = iconRegister.func_94245_a("immersiveengineering:metal2_barrel_top_in");
        this.iconBarrel[2] = iconRegister.func_94245_a("immersiveengineering:metal2_barrel_top_out");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityMetalBarrel && side < 2) {
            return this.iconBarrel[((TileEntityMetalBarrel)te).sideConfig[side] + 1];
        }
        if (te instanceof TileEntityCapacitorCreative) {
            TileEntityCapacitorCreative cap = (TileEntityCapacitorCreative)te;
            if (side == 0) {
                return this.iconCap[0][cap.sideConfig[side] + 1];
            }
            if (side == 1) {
                return this.iconCap[1][cap.sideConfig[side] + 1];
            }
            return this.iconCap[2][cap.sideConfig[side] + 1];
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 6) {
            return this.iconPump[Math.min(side + 1, 6)];
        }
        if (meta == 4 && side == 1) {
            return this.iconFloodlightGlass;
        }
        if (meta == 7 && side < 2) {
            return this.iconBarrel[0];
        }
        if (meta == 8) {
            if (side == 0) {
                return this.iconCap[0][0];
            }
            if (side == 1) {
                return this.iconCap[1][0];
            }
            return this.iconCap[2][0];
        }
        return super.func_149691_a(side, meta);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return BlockRenderMetalDevices2.renderID;
    }

    public boolean canRenderInPass(int pass) {
        BlockRenderMetalDevices2.renderPass = pass;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int dye;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IEBlockInterfaces.IColouredTile && (dye = Utils.getDye(player.func_71045_bC())) >= 0) {
            float r = (float)(((IEBlockInterfaces.IColouredTile)te).getColour() >> 16 & 0xFF) / 255.0f;
            float g = (float)(((IEBlockInterfaces.IColouredTile)te).getColour() >> 8 & 0xFF) / 255.0f;
            float b = (float)(((IEBlockInterfaces.IColouredTile)te).getColour() & 0xFF) / 255.0f;
            r += EntitySheep.field_70898_d[15 - dye][0];
            g += EntitySheep.field_70898_d[15 - dye][1];
            b += EntitySheep.field_70898_d[15 - dye][2];
            int newColour = (int)((r /= 2.0f) * 255.0f);
            newColour = (newColour << 8) + (int)((g /= 2.0f) * 255.0f);
            newColour = (newColour << 8) + (int)((b /= 2.0f) * 255.0f);
            ((IEBlockInterfaces.IColouredTile)te).setColour(newColour);
            te.func_70296_d();
            world.func_147471_g(x, y, z);
            return true;
        }
        if (!player.func_70093_af() && te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            if (!world.field_72995_K) {
                if (Utils.isHammer(player.func_71045_bC())) {
                    ((TileEntityBreakerSwitch)te).inverted = !((TileEntityBreakerSwitch)te).inverted;
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info." + (((TileEntityBreakerSwitch)te).inverted ? "invertedOn" : "invertedOff"), new Object[0]));
                    te.func_70296_d();
                } else {
                    ((TileEntityBreakerSwitch)te).toggle();
                    te.func_70296_d();
                }
                world.func_147459_d(x, y, z, (Block)this);
                for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                    world.func_147459_d(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ, (Block)this);
                }
                world.func_147451_t(x, y, z);
            }
            return true;
        }
        if (te instanceof TileEntityEnergyMeter) {
            if (!world.field_72995_K) {
                TileEntity tmp;
                TileEntityEnergyMeter meter = (TileEntityEnergyMeter)te;
                int transfer = meter.getAveragePower();
                if (meter.dummy && (tmp = world.func_147438_o(meter.field_145851_c, meter.field_145848_d + 1, meter.field_145849_e)) instanceof TileEntityEnergyMeter) {
                    meter = (TileEntityEnergyMeter)tmp;
                }
                String transferred = "0";
                if (transfer > 0) {
                    transferred = Utils.formatDouble(transfer, "0.###");
                }
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.energyTransfered", new Object[]{meter.lastPackets.size(), transferred}));
            }
            return true;
        }
        if (Utils.isHammer(player.func_71045_bC()) && te instanceof TileEntityFloodlight) {
            if (!world.field_72995_K) {
                if (side == ((TileEntityFloodlight)te).side || ForgeDirection.OPPOSITES[side] == ((TileEntityFloodlight)te).side) {
                    ((TileEntityFloodlight)te).turnY(player.func_70093_af(), false);
                } else {
                    ((TileEntityFloodlight)te).turnX(!player.func_70093_af(), false);
                }
            }
            return true;
        }
        if (te instanceof TileEntityFluidPump) {
            TileEntityFluidPump pump = (TileEntityFluidPump)te;
            if (!pump.dummy) {
                if (!world.field_72995_K) {
                    if (Utils.isHammer(player.func_71045_bC())) {
                        if (player.func_70093_af()) {
                            side = ForgeDirection.OPPOSITES[side];
                        }
                        pump.toggleSide(side);
                        world.func_147471_g(x, y, z);
                    } else if (Config.getBoolean("pump_placeCobble") && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 1), (ItemStack)player.func_71045_bC(), (boolean)true)) {
                        pump.placeCobble = !pump.placeCobble;
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.pump.placeCobble." + pump.placeCobble, new Object[0]));
                    }
                }
                return true;
            }
        } else if (te instanceof TileEntityFluidPipe) {
            if (Utils.isHammer(player.func_71045_bC())) {
                if (!world.field_72995_K) {
                    TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
                    ForgeDirection fd = ForgeDirection.UNKNOWN;
                    ArrayList<AxisAlignedBB> boxes = this.addCustomSelectionBoxesToList(world, x, y, z);
                    for (AxisAlignedBB box : boxes) {
                        if (!box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ)) || !(box instanceof AdvancedAABB)) continue;
                        fd = ((AdvancedAABB)box).fd;
                    }
                    if (fd != null && fd != ForgeDirection.UNKNOWN) {
                        tile.toggleSide(fd.ordinal());
                        world.func_147471_g(x, y, z);
                        TileEntityFluidPipe.indirectConnections.clear();
                        return true;
                    }
                }
            } else if (player.func_71045_bC() != null) {
                TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
                for (ItemStack valid : TileEntityFluidPipe.validScaffoldCoverings) {
                    if (!OreDictionary.itemMatches((ItemStack)valid, (ItemStack)player.func_71045_bC(), (boolean)true) || OreDictionary.itemMatches((ItemStack)tile.scaffoldCovering, (ItemStack)player.func_71045_bC(), (boolean)true)) continue;
                    if (!world.field_72995_K && tile.scaffoldCovering != null && world.func_82736_K().func_82766_b("doTileDrops")) {
                        EntityItem entityitem = player.func_71019_a(tile.scaffoldCovering.func_77946_l(), false);
                        entityitem.field_145804_b = 0;
                    }
                    tile.scaffoldCovering = Utils.copyStackWithAmount(player.func_71045_bC(), 1);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    world.func_147471_g(x, y, z);
                    world.func_147452_c(x, y, z, tile.func_145838_q(), 0, 0);
                    return true;
                }
            } else if (player.func_70093_af() && player.func_71045_bC() == null) {
                TileEntityFluidPipe pipe = (TileEntityFluidPipe)te;
                if (pipe.scaffoldCovering != null) {
                    if (!world.field_72995_K) {
                        if (world.func_82736_K().func_82766_b("doTileDrops")) {
                            EntityItem entityitem = player.func_71019_a(pipe.scaffoldCovering.func_77946_l(), false);
                            entityitem.field_145804_b = 0;
                        }
                        pipe.scaffoldCovering = null;
                        world.func_147471_g(x, y, z);
                        world.func_147452_c(x, y, z, pipe.func_145838_q(), 0, 0);
                    }
                    return true;
                }
            }
        } else if (te instanceof TileEntityWoodenBarrel) {
            TileEntityWoodenBarrel barrel = (TileEntityWoodenBarrel)te;
            if (!world.field_72995_K && Utils.isHammer(player.func_71045_bC()) && side < 2) {
                if (player.func_70093_af()) {
                    side = ForgeDirection.OPPOSITES[side];
                }
                barrel.toggleSide(side);
            } else {
                if (Utils.fillFluidHandlerWithPlayerItem(world, barrel, player)) {
                    barrel.func_70296_d();
                    world.func_147471_g(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e);
                    return true;
                }
                if (Utils.fillPlayerItemFromFluidHandler(world, barrel, player, barrel.tank.getFluid())) {
                    barrel.func_70296_d();
                    world.func_147471_g(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e);
                    return true;
                }
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IFluidContainerItem) {
                    barrel.func_70296_d();
                    world.func_147471_g(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e);
                    return true;
                }
            }
        } else {
            if (te instanceof TileEntityCapacitorCreative && Utils.isHammer(player.func_71045_bC())) {
                if (player.func_70093_af()) {
                    side = ForgeDirection.OPPOSITES[side];
                }
                if (!world.field_72995_K) {
                    ((TileEntityCapacitorCreative)te).toggleSide(side);
                    te.func_70296_d();
                    world.func_147471_g(x, y, z);
                    world.func_147452_c(x, y, z, te.func_145838_q(), 0, 0);
                }
                return true;
            }
            if (te instanceof TileEntityChargingStation) {
                ItemStack equipped = player.func_71045_bC();
                if (equipped != null && (equipped.func_77973_b() instanceof IEnergyContainerItem || Lib.IC2 && IC2Helper.isElectricItem(equipped))) {
                    ItemStack stored = ((TileEntityChargingStation)te).inventory;
                    ((TileEntityChargingStation)te).func_70299_a(0, player.func_71045_bC());
                    player.func_70062_b(0, stored);
                    return true;
                }
                if (((TileEntityChargingStation)te).inventory != null) {
                    if (!world.field_72995_K) {
                        player.func_70099_a(((TileEntityChargingStation)te).inventory, 0.5f);
                    }
                    ((TileEntityChargingStation)te).func_70299_a(0, null);
                    return true;
                }
            }
        }
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            int f = ((TileEntityBreakerSwitch)te).facing;
            int side = ((TileEntityBreakerSwitch)te).sideAttached;
            if (side == 0) {
                this.func_149676_a(f < 4 ? 0.25f : (f == 5 ? 0.75f : 0.0f), 0.1875f, f > 3 ? 0.25f : (f == 3 ? 0.75f : 0.0f), f < 4 ? 0.75f : (f == 4 ? 0.25f : 1.0f), 0.8125f, f > 3 ? 0.75f : (f == 2 ? 0.25f : 1.0f));
            } else if (side == 1) {
                this.func_149676_a(f >= 4 ? 0.1875f : 0.25f, 0.0f, f <= 3 ? 0.1875f : 0.25f, f >= 4 ? 0.8125f : 0.75f, 0.25f, f <= 3 ? 0.8125f : 0.75f);
            } else {
                this.func_149676_a(f >= 4 ? 0.1875f : 0.25f, 0.75f, f <= 3 ? 0.1875f : 0.25f, f >= 4 ? 0.8125f : 0.75f, 1.0f, f <= 3 ? 0.8125f : 0.75f);
            }
        } else if (te instanceof TileEntityEnergyMeter && !((TileEntityEnergyMeter)te).dummy) {
            this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.875f, 0.8125f);
        } else if (te instanceof TileEntityFloodlight) {
            TileEntityFloodlight light = (TileEntityFloodlight)te;
            this.func_149676_a(light.side / 2 == 2 ? 0.0f : 0.0625f, light.side / 2 == 0 ? 0.0f : 0.0625f, light.side / 2 == 1 ? 0.0f : 0.0625f, light.side / 2 == 2 ? 1.0f : 0.9375f, light.side / 2 == 0 ? 1.0f : 0.9375f, light.side / 2 == 1 ? 1.0f : 0.9375f);
        } else if (te instanceof TileEntityFluidPipe) {
            this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        } else if (te instanceof TileEntityFluidPump) {
            if (((TileEntityFluidPump)te).dummy) {
                this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (world.func_72805_g(x, y, z) == 3) {
            this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
        } else if (te instanceof TileEntityRedstoneBreaker) {
            int f = ((TileEntityBreakerSwitch)te).facing;
            int side = ((TileEntityBreakerSwitch)te).sideAttached;
            if (side == 0) {
                this.func_149676_a(0.0f, 0.125f, 0.0f, 1.0f, 0.875f, 1.0f);
            } else if (side == 1) {
                this.func_149676_a(f >= 4 ? 0.125f : 0.0f, 0.0f, f <= 3 ? 0.125f : 0.0f, f >= 4 ? 0.875f : 1.0f, 1.0f, f <= 3 ? 0.875f : 1.0f);
            } else {
                this.func_149676_a(f >= 4 ? 0.125f : 0.0f, 0.0f, f <= 3 ? 0.125f : 0.0f, f >= 4 ? 0.875f : 1.0f, 1.0f, f <= 3 ? 0.875f : 1.0f);
            }
        } else if (te instanceof TileEntityChargingStation) {
            int f = ((TileEntityChargingStation)te).facing;
            this.func_149676_a(f < 4 ? 0.125f : 0.0f, 0.0f, f > 3 ? 0.125f : 0.0f, f < 4 ? 0.875f : 1.0f, 1.0f, f > 3 ? 0.875f : 1.0f);
        } else if (te instanceof TileEntityBlastFurnacePreheater && ((TileEntityBlastFurnacePreheater)te).dummy > 0) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity ent) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityFluidPipe) {
            TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
            if (tile.scaffoldCovering != null) {
                this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
                this.addCollisionBox(world, x, y, z, aabb, list, ent);
            } else {
                byte connections = tile.getConnectionByte();
                if (connections == 48) {
                    this.func_149676_a(0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    if ((connections & 0x10) == 0) {
                        this.func_149676_a(0.0f, 0.125f, 0.125f, 0.125f, 0.875f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                    if ((connections & 0x20) == 0) {
                        this.func_149676_a(0.875f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                } else if (connections == 12) {
                    this.func_149676_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 1.0f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    if ((connections & 4) == 0) {
                        this.func_149676_a(0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.125f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                    if ((connections & 8) == 0) {
                        this.func_149676_a(0.125f, 0.125f, 0.875f, 0.875f, 0.875f, 1.0f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                } else if (connections == 3) {
                    this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    if ((connections & 1) == 0) {
                        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.125f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                    if ((connections & 2) == 0) {
                        this.func_149676_a(0.125f, 0.875f, 0.125f, 0.875f, 1.0f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                } else {
                    this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    for (int i = 0; i < 6; ++i) {
                        if ((connections & 1) == 1) {
                            this.func_149676_a(i == 4 ? 0.0f : (i == 5 ? 0.875f : 0.125f), i == 0 ? 0.0f : (i == 1 ? 0.875f : 0.125f), i == 2 ? 0.0f : (i == 3 ? 0.875f : 0.125f), i == 4 ? 0.125f : (i == 5 ? 1.0f : 0.875f), i == 0 ? 0.125f : (i == 1 ? 1.0f : 0.875f), i == 2 ? 0.125f : (i == 3 ? 1.0f : 0.875f));
                            this.addCollisionBox(world, x, y, z, aabb, list, ent);
                        }
                        connections = (byte)(connections >> 1);
                    }
                }
            }
        } else {
            super.func_149743_a(world, x, y, z, aabb, list, ent);
        }
    }

    @Override
    public ArrayList<AxisAlignedBB> addCustomSelectionBoxesToList(World world, int x, int y, int z) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityFluidPipe) {
            double[] dArray;
            TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
            byte connections = tile.getAvailableConnectionByte();
            byte availableConnections = tile.getConnectionByte();
            if (tile.scaffoldCovering != null) {
                double[] dArray2 = new double[6];
                dArray2[0] = 0.002;
                dArray2[1] = 0.998;
                dArray2[2] = 0.002;
                dArray2[3] = 0.998;
                dArray2[4] = 0.002;
                dArray = dArray2;
                dArray2[5] = 0.998;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 0.25;
                dArray3[1] = 0.75;
                dArray3[2] = 0.25;
                dArray3[3] = 0.75;
                dArray3[4] = 0.25;
                dArray = dArray3;
                dArray3[5] = 0.75;
            }
            double[] baseAABB = dArray;
            for (int i = 0; i < 6; ++i) {
                double size;
                double depth = tile.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
                double d = size = tile.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
                if (tile.scaffoldCovering != null) {
                    size = 0.0;
                }
                if ((connections & 1) == 1) {
                    list.add(new AdvancedAABB(i == 4 ? 0.0 : (i == 5 ? 1.0 - depth : size), i == 0 ? 0.0 : (i == 1 ? 1.0 - depth : size), i == 2 ? 0.0 : (i == 3 ? 1.0 - depth : size), i == 4 ? depth : (i == 5 ? 1.0 : 1.0 - size), i == 0 ? depth : (i == 1 ? 1.0 : 1.0 - size), i == 2 ? depth : (i == 3 ? 1.0 : 1.0 - size), ForgeDirection.getOrientation((int)i)));
                }
                if ((availableConnections & 1) == 1) {
                    int n = i;
                    baseAABB[n] = baseAABB[n] + (i % 2 == 1 ? 0.125 : -0.125);
                }
                baseAABB[i] = Math.min(Math.max(baseAABB[i], 0.0), 1.0);
                availableConnections = (byte)(availableConnections >> 1);
                connections = (byte)(connections >> 1);
            }
            list.add(new AdvancedAABB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3], ForgeDirection.UNKNOWN));
        }
        return list;
    }

    @Override
    public boolean addSpecifiedSubBox(World world, int x, int y, int z, EntityPlayer player, AxisAlignedBB box, Vec3 hitVec, ArrayList<AxisAlignedBB> list) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityFluidPipe && box instanceof AdvancedAABB && ((AdvancedAABB)box).fd != null) {
            ForgeDirection fd = ((AdvancedAABB)box).fd;
            if (box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(hitVec.func_72441_c((double)(-x), (double)(-y), (double)(-z)))) {
                list.add(fd == ForgeDirection.UNKNOWN ? box : box.func_72314_b(fd.offsetX != 0 ? 0.0 : 0.03125, fd.offsetY != 0 ? 0.0 : 0.03125, fd.offsetZ != 0 ? 0.0 : 0.03125));
                return fd == ForgeDirection.UNKNOWN && list.isEmpty();
            }
        }
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity ent) {
        TileEntity te;
        if (world.func_72805_g(x, y, z) == 5 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityFluidPipe && ((TileEntityFluidPipe)te).scaffoldCovering != null) {
            float f5 = 0.15f;
            if (ent.field_70159_w < (double)(-f5)) {
                ent.field_70159_w = -f5;
            }
            if (ent.field_70159_w > (double)f5) {
                ent.field_70159_w = f5;
            }
            if (ent.field_70179_y < (double)(-f5)) {
                ent.field_70179_y = -f5;
            }
            if (ent.field_70179_y > (double)f5) {
                ent.field_70179_y = f5;
            }
            ent.field_70143_R = 0.0f;
            if (ent.field_70181_x < -0.15) {
                ent.field_70181_x = -0.15;
            }
            if (ent.field_70181_x < 0.0 && ent instanceof EntityPlayer && ent.func_70093_af()) {
                ent.field_70181_x = 0.05;
                return;
            }
            if (ent.field_70123_F) {
                ent.field_70181_x = 0.2;
            }
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 3) {
            return side.ordinal() < 2;
        }
        if (meta == 4) {
            TileEntity te = world.func_147438_o(x, y, z);
            return te instanceof TileEntityFloodlight && side.getOpposite().ordinal() == ((TileEntityFloodlight)te).side;
        }
        if (meta == 5) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityFluidPipe && ((TileEntityFluidPipe)te).scaffoldCovering != null) {
                return true;
            }
        } else {
            if (meta == 6) {
                return true;
            }
            if (meta == 2) {
                TileEntity te = world.func_147438_o(x, y, z);
                return te instanceof TileEntityEnergyMeter && ((TileEntityEnergyMeter)te).dummy;
            }
            if (meta == 8) {
                return true;
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityBreakerSwitch();
            }
            case 1: {
                return new TileEntitySkycrateDispenser();
            }
            case 2: {
                return new TileEntityEnergyMeter();
            }
            case 3: {
                return new TileEntityElectricLantern();
            }
            case 4: {
                return new TileEntityFloodlight();
            }
            case 5: {
                return new TileEntityFluidPipe();
            }
            case 6: {
                return new TileEntityFluidPump();
            }
            case 7: {
                return new TileEntityMetalBarrel();
            }
            case 8: {
                return new TileEntityCapacitorCreative();
            }
            case 9: {
                return new TileEntityRedstoneBreaker();
            }
            case 10: {
                return new TileEntityChargingStation();
            }
            case 11: {
                return new TileEntityBlastFurnacePreheater();
            }
        }
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityWoodenBarrel) {
            ItemStack stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenBarrel)te).writeTank(tag, true);
            if (!tag.func_82582_d()) {
                stack.func_77982_d(tag);
            }
            return stack;
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        ItemStack s;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityEnergyMeter) {
            if (((TileEntityEnergyMeter)te).dummy) {
                world.func_147468_f(x, y + 1, z);
            } else {
                world.func_147468_f(x, y - 1, z);
            }
        }
        if (te instanceof TileEntityFloodlight) {
            ((TileEntityFloodlight)te).updateFakeLights(true, false);
        }
        if (te instanceof TileEntityFluidPump) {
            if (((TileEntityFluidPump)te).dummy) {
                world.func_147468_f(x, y - 1, z);
            } else {
                world.func_147468_f(x, y + 1, z);
            }
        }
        if (te instanceof TileEntityFluidPipe && world.func_82736_K().func_82766_b("doTileDrops") && ((TileEntityFluidPipe)te).scaffoldCovering != null) {
            EntityItem entityitem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, ((TileEntityFluidPipe)te).scaffoldCovering.func_77946_l());
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        if (te instanceof TileEntityBlastFurnacePreheater) {
            int startY = y - ((TileEntityBlastFurnacePreheater)te).dummy;
            for (int i = 0; i < 3; ++i) {
                if (!(world.func_147438_o(x, startY + i, z) instanceof TileEntityBlastFurnacePreheater)) continue;
                world.func_147468_f(x, startY + i, z);
            }
        }
        if (te instanceof TileEntityChargingStation && (s = ((TileEntityChargingStation)te).inventory) != null) {
            float fx = (float)(world.field_73012_v.nextGaussian() * (double)0.8f + (double)0.1f);
            float fz = (float)(world.field_73012_v.nextGaussian() * (double)0.8f + (double)0.1f);
            EntityItem entityitem = new EntityItem(world, (double)((float)x + fx), (double)y + 0.5, (double)((float)z + fz), s);
            entityitem.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
            entityitem.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
            entityitem.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
            if (s.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)s.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && te instanceof TileEntityWoodenBarrel) {
            ItemStack stack = new ItemStack((Block)this, 1, meta);
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenBarrel)te).writeTank(tag, true);
            if (!tag.func_82582_d()) {
                stack.func_77982_d(tag);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileEntityWoodenBarrel) {
            ItemStack stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenBarrel)te).writeTank(tag, true);
            if (!tag.func_82582_d()) {
                stack.func_77982_d(tag);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata == 7) {
            return ret;
        }
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_149692_a(metadata)));
        }
        return ret;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityFluidPipe && !world.field_72995_K) {
            TileEntityFluidPipe.indirectConnections.clear();
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity other;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFluidPipe && (other = world.func_147438_o(tileX, tileY, tileZ)) instanceof IFluidHandler) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                TileEntityFluidPipe.indirectConnections.clear();
            }
            ForgeDirection fd = tileY < y ? ForgeDirection.DOWN : (tileY > y ? ForgeDirection.UP : (tileZ < z ? ForgeDirection.NORTH : (tileZ > z ? ForgeDirection.SOUTH : (tileX < x ? ForgeDirection.WEST : ForgeDirection.EAST))));
            ((TileEntityFluidPipe)tile).sideConfig[fd.ordinal()] = 0;
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tile instanceof TileEntityRedstoneBreaker) {
            boolean RS = !world.func_72864_z(x, y, z);
            boolean b = ((TileEntityRedstoneBreaker)tile).active;
            ((TileEntityRedstoneBreaker)tile).active = RS;
            if (b != RS) {
                tile.func_70296_d();
                ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections();
            }
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityWoodenBarrel) {
            TileEntityWoodenBarrel barrel = (TileEntityWoodenBarrel)te;
            return (int)(15.0f * ((float)barrel.tank.getFluidAmount() / (float)barrel.tank.getCapacity()));
        }
        if (te instanceof TileEntityChargingStation) {
            return ((TileEntityChargingStation)te).comparatorOutput;
        }
        if (te instanceof TileEntityEnergyMeter) {
            return ((TileEntityEnergyMeter)te).compVal;
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            TileEntityBreakerSwitch breaker = (TileEntityBreakerSwitch)te;
            boolean power = breaker.active && !breaker.inverted || !breaker.active && breaker.inverted;
            return power ? 15 : 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            TileEntityBreakerSwitch breaker = (TileEntityBreakerSwitch)te;
            int powerSide = breaker.sideAttached > 0 ? breaker.sideAttached - 1 : breaker.facing;
            boolean power = breaker.active && !breaker.inverted || !breaker.active && breaker.inverted;
            return power && ForgeDirection.OPPOSITES[side] == powerSide ? 15 : 0;
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_72805_g(x, y, z) == 0) {
            return super.canConnectRedstone(world, x, y, z, side);
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityElectricLantern) {
            return ((TileEntityElectricLantern)te).active ? 15 : 0;
        }
        return 0;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean shouldRenderFluid(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 0 || meta == 3 || meta == 4 || meta == 5 || meta == 9;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 0 || meta == 3 || meta == 4 || meta == 5 || meta == 9;
    }
}

