/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class EntityChemthrowerShot
extends EntityIEProjectile {
    private Fluid fluid;
    static final int dataMarker_fluid = 13;

    public EntityChemthrowerShot(World world) {
        super(world);
    }

    public EntityChemthrowerShot(World world, double x, double y, double z, double ax, double ay, double az, Fluid fluid) {
        super(world, x, y, z, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    public EntityChemthrowerShot(World world, EntityLivingBase living, double ax, double ay, double az, Fluid fluid) {
        super(world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
    }

    public void setFluidSynced() {
        if (this.getFluid() != null) {
            this.field_70180_af.func_75692_b(13, (Object)FluidRegistry.getFluidID((Fluid)this.getFluid()));
        }
    }

    public Fluid getFluidSynced() {
        return FluidRegistry.getFluid((int)this.field_70180_af.func_75679_c(13));
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public double getGravity() {
        if (this.getFluid() != null) {
            boolean isGas = this.getFluid().isGaseous() || ChemthrowerHandler.isGas(this.getFluid());
            return (isGas ? 0.025f : 0.05f) * (float)(this.getFluid().getDensity() < 0 ? -1 : 1);
        }
        return super.getGravity();
    }

    @Override
    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid());
    }

    public void func_70030_z() {
        Block b;
        if (this.getFluid() == null && this.field_70170_p.field_72995_K) {
            this.fluid = this.getFluidSynced();
        }
        if ((b = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) != null && this.canIgnite() && (b.func_149688_o() == Material.field_151581_o || b.func_149688_o() == Material.field_151587_i)) {
            this.func_70015_d(6);
        }
        super.func_70030_z();
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K && this.getFluid() != null) {
            int tempDiff;
            int damage;
            boolean fire;
            ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect(this.getFluid());
            boolean bl = fire = this.getFluid().getTemperature() > 1000;
            if (effect != null) {
                ItemStack thrower = null;
                EntityPlayer shooter = (EntityPlayer)this.getShooter();
                if (shooter != null) {
                    thrower = shooter.func_71045_bC();
                }
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    effect.applyToEntity((EntityLivingBase)mop.field_72308_g, shooter, thrower, this.fluid);
                } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    effect.applyToBlock(this.field_70170_p, mop, shooter, thrower, this.fluid);
                }
            } else if (mop.field_72308_g != null && this.getFluid().getTemperature() > 500 && mop.field_72308_g.func_70097_a(DamageSource.field_76371_c, (float)(damage = Math.abs(tempDiff = this.getFluid().getTemperature() - 300) / 500))) {
                mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.75);
            }
            if (mop.field_72308_g != null) {
                int f;
                int n = this.func_70027_ad() ? this.field_70151_c : (f = fire ? 3 : 0);
                if (f > 0) {
                    mop.field_72308_g.func_70015_d(f);
                    if (mop.field_72308_g.func_70097_a(DamageSource.field_76372_a, 2.0f)) {
                        mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.75);
                    }
                }
            }
        }
    }
}

