/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.player.renderhooks;

import com.InfinityRaider.AgriCraft.renderers.particles.DustFX;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
public class PlayerEffectRendererNavi
extends PlayerEffectRenderer {
    private short counter = 0;
    private final Sphere sphere;
    private final float f;
    private final int detail;
    private final ResourceLocation texture;
    private final ResourceLocation largeWing = new ResourceLocation("agricraft", "textures/entities/player/navi/wingLarge.png");
    private final ResourceLocation smallWing = new ResourceLocation("agricraft", "textures/entities/player/navi/wingSmall.png");

    protected PlayerEffectRendererNavi() {
        this.texture = new ResourceLocation("agricraft", "textures/entities/player/navi/navi.png");
        this.f = 0.5f;
        this.detail = 8;
        this.sphere = new Sphere();
        this.sphere.setDrawStyle(100012);
        this.sphere.setNormals(100000);
        this.sphere.setOrientation(100020);
    }

    @Override
    ArrayList<String> getDisplayNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("SkeletonPunk");
        return list;
    }

    @Override
    void renderEffects(EntityPlayer player, RenderPlayer renderer, float partialTick) {
        double[] pos = this.getPosition(player, partialTick);
        GL11.glTranslated((double)pos[0], (double)pos[1], (double)pos[2]);
        this.renderWings();
        this.renderSphere();
        this.spawnParticles(player, pos[1], partialTick);
        GL11.glTranslated((double)(-pos[0]), (double)(-pos[1]), (double)(-pos[2]));
    }

    private double[] getPosition(EntityPlayer player, float partialTick) {
        double arg = Math.toRadians(360L * (System.currentTimeMillis() & 0x3FFFL) / 16383L);
        double vY = 5.0;
        double aY = 0.1f;
        double dy = aY * Math.cos(vY * arg % 360.0);
        return new double[]{0.5, -1.0 + dy, 1.0};
    }

    private void renderSphere() {
        float scale = 0.2f;
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.sphere.draw(this.f, this.detail, this.detail);
    }

    private void renderWings() {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        float arg = (float)Math.toRadians(7200L * (System.currentTimeMillis() & 0x3FFFL) / 16383L % 360L);
        float sin = (float)(10.0 * Math.sin(arg));
        float scale = 0.5f;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.largeWing);
        GL11.glRotatef((float)(45.0f + sin), (float)0.0f, (float)1.0f, (float)0.0f);
        this.draw(tessellator, scale);
        GL11.glRotatef((float)(2.0f * (-45.0f - sin)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.draw(tessellator, scale);
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.smallWing);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.draw(tessellator, scale);
        GL11.glRotatef((float)(2.0f * (45.0f + sin)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.draw(tessellator, scale);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glRotatef((float)(-45.0f - sin), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
    }

    private void draw(Tessellator tessellator, float scale) {
        GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(0.0, (double)(-scale), 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)(-scale), (double)(-scale), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)(-scale), 0.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(-scale), 0.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(-scale), (double)(-scale), 0.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, (double)(-scale), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
    }

    private void spawnParticles(EntityPlayer player, double y, float partialTick) {
        short delay = 20;
        this.counter = (short)(this.counter + 1);
        if (this.counter >= delay) {
            this.counter = 0;
            double x = 0.5;
            y += player == Minecraft.func_71410_x().field_71439_g ? 0.62 : 0.0;
            double z = -1.0;
            double yaw = Math.toRadians(player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTick);
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            double xNew = x * cos - z * sin;
            double zNew = x * sin + z * cos;
            Vec3 vector = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            float scale = player.field_70170_p.field_73012_v.nextFloat();
            double radius = 0.3 * player.field_70170_p.field_73012_v.nextDouble();
            double angle = Math.toRadians(player.field_70170_p.field_73012_v.nextInt(360));
            DustFX particle = new DustFX(player.field_70170_p, player.field_70165_t + xNew + radius * Math.cos(angle), player.field_70163_u - 2.0 * y, player.field_70161_v + zNew + radius * Math.sin(angle), scale, 0.01f, vector, this.texture);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
    }
}

