/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.api.rednet.connectivity;

import java.util.HashMap;
import java.util.Map;

public enum RedNetConnectionType {
    None,
    CableSingle,
    PlateSingle,
    CableAll,
    PlateAll,
    ForcedCableSingle,
    ForcedPlateSingle,
    ForcedCableAll,
    ForcedPlateAll,
    DecorativeSingle,
    DecorativeAll,
    ForcedDecorativeSingle,
    ForcedDecorativeAll;

    private static final Map<Short, RedNetConnectionType> connections;
    public final boolean isConnected = this.ordinal() != 0;
    public final boolean isSingleSubnet = this.name().endsWith("Single");
    public final boolean isAllSubnets = this.name().endsWith("All");
    public final boolean isPlate = this.name().contains("Plate");
    public final boolean isCable = this.name().contains("Cable");
    public final boolean isConnectionForced = this.name().startsWith("Forced");
    public final boolean isDecorative = this.name().contains("Decorative");
    public final short flags = RedNetConnectionType.toFlags(this.isConnected, this.isCable, this.isPlate, this.isSingleSubnet, this.isAllSubnets, this.isConnectionForced);

    public static final RedNetConnectionType fromFlags(short flags) {
        return connections.get(flags);
    }

    private static final short toFlags(boolean ... flags) {
        short ret = 0;
        int i = flags.length;
        while (i-- > 0) {
            ret = (short)(ret | (flags[i] ? 1 : 0) << i);
        }
        return ret;
    }

    static {
        connections = new HashMap<Short, RedNetConnectionType>();
        for (RedNetConnectionType type : RedNetConnectionType.values()) {
            connections.put(type.flags, type);
        }
    }
}

