/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import java.awt.Point;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTransceiver
extends AbstractMachineContainer<TileTransceiver> {
    public static final int GUI_WIDTH = 256;
    static final Point PLAYER_INV_OFFSET = new Point(47, 86);
    static final Point ITEM_INV_OFFSET = new Point(54, 30);
    static final Point HIDDEN_OFFSET = new Point(-3000, -3000);
    static final Point FILTER_OFFSET = new Point(ContainerTransceiver.PLAYER_INV_OFFSET.x, 30);

    public ContainerTransceiver(InventoryPlayer inventory, TileTransceiver te) {
        super(inventory, te);
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.func_75146_a(new Slot(this.getInv(), i, 0, 0){

                public boolean func_75214_a(ItemStack itemstack) {
                    return ((TileTransceiver)ContainerTransceiver.this.getInv()).func_94041_b(this.getSlotIndex(), itemstack);
                }
            });
        }
        while (i < 16) {
            this.func_75146_a(new Slot(this.getInv(), i, 0, 0){

                public boolean func_75214_a(ItemStack p_75214_1_) {
                    return false;
                }
            });
            ++i;
        }
        this.setItemSlotLocations(this.getItemInventoryOffset());
    }

    public void setPlayerInventoryVisible(boolean visible) {
        Set entries = this.playerSlotLocations.entrySet();
        for (Map.Entry entry : entries) {
            ((Slot)entry.getKey()).field_75223_e = visible ? ((Point)entry.getValue()).x : -3000;
            ((Slot)entry.getKey()).field_75221_f = visible ? ((Point)entry.getValue()).y : -3000;
        }
    }

    public void setBufferSlotsVisible(boolean visible) {
        Point itemOffset = visible ? this.getItemInventoryOffset() : HIDDEN_OFFSET;
        this.setItemSlotLocations(itemOffset);
    }

    private void setItemSlotLocations(Point offset) {
        int i;
        int x = offset.x;
        int y = offset.y;
        for (i = 0; i < 4; ++i) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
        }
        x = offset.x;
        y = offset.y + 18;
        while (i < 8) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
            ++i;
        }
        x = offset.x + 72 + this.getItemBufferSpacing();
        y = offset.y;
        while (i < 12) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
            ++i;
        }
        x = offset.x + 72 + this.getItemBufferSpacing();
        y = offset.y + 18;
        while (i < 16) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
            ++i;
        }
    }

    @Override
    public Point getPlayerInventoryOffset() {
        return PLAYER_INV_OFFSET;
    }

    public Point getItemInventoryOffset() {
        return ITEM_INV_OFFSET;
    }

    public Point getFilterOffset() {
        return FILTER_OFFSET;
    }

    public int getItemBufferSpacing() {
        return 5;
    }

    @Override
    protected int getIndexOfFirstPlayerInvSlot(SlotDefinition slotDef) {
        return slotDef.getNumSlots();
    }
}

