/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.crafting.ShapelessToolRecipe;
import tconstruct.library.tools.ToolCore;

public class Detailing {
    public List<DetailInput> detailing = new ArrayList<DetailInput>();

    public void addDetailing(Object input, int inputMeta, Object output, int outputMeta, ToolCore tool) {
        ItemStack oID;
        ItemStack iID;
        int iMeta = inputMeta;
        int oMeta = outputMeta;
        if (input instanceof Block) {
            iID = new ItemStack((Block)input);
        } else if (input instanceof Item) {
            iID = new ItemStack((Item)input);
        } else if (input instanceof ItemStack) {
            iID = (ItemStack)input;
        } else {
            throw new RuntimeException("Invalid detail input!");
        }
        if (output instanceof Block) {
            oID = new ItemStack((Block)output);
        } else if (output instanceof Item) {
            oID = new ItemStack((Item)output);
        } else if (output instanceof ItemStack) {
            oID = (ItemStack)output;
        } else {
            throw new RuntimeException("Invalid detail output!");
        }
        this.addDetailing(new DetailInput(iID, iMeta, oID, oMeta), tool);
    }

    public void addDetailing(DetailInput details, ToolCore tool) {
        this.detailing.add(details);
        ItemStack toolstack = new ItemStack((Item)tool, 1, Short.MAX_VALUE);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound toolTag = new NBTTagCompound();
        toolTag.func_74768_a("RenderHandle", 0);
        toolTag.func_74768_a("RenderHead", 2);
        toolTag.func_74768_a("RenderAccessory", 2);
        toolTag.func_74768_a("Damage", 0);
        toolTag.func_74768_a("TotalDurability", 100);
        compound.func_74782_a("InfiTool", (NBTBase)toolTag);
        toolstack.func_77982_d(compound);
        this.addShapelessToolRecipe(new ItemStack(details.output.func_77973_b(), 1, details.outputMeta), toolstack, new ItemStack(details.input.func_77973_b(), 1, details.inputMeta));
    }

    public void addShapelessToolRecipe(ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        Object[] aobject = par2ArrayOfObj;
        int i = par2ArrayOfObj.length;
        for (int j = 0; j < i; ++j) {
            Object object1 = aobject[j];
            if (object1 instanceof ItemStack) {
                arraylist.add(((ItemStack)object1).func_77946_l());
                continue;
            }
            if (object1 instanceof Item) {
                arraylist.add(new ItemStack((Item)object1));
                continue;
            }
            if (!(object1 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless tool recipe!");
            }
            arraylist.add(new ItemStack((Block)object1));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessToolRecipe(par1ItemStack, arraylist));
    }

    public DetailInput getDetailing(Block block, int inputMeta) {
        for (int i = 0; i < this.detailing.size(); ++i) {
            DetailInput detail = this.detailing.get(i);
            if (Item.func_150898_a((Block)block) != detail.input.func_77973_b() || inputMeta != detail.inputMeta) continue;
            return detail;
        }
        return null;
    }

    public class DetailInput {
        public ItemStack input;
        public int inputMeta;
        public ItemStack output;
        public int outputMeta;

        public DetailInput(ItemStack input, int inputMeta, ItemStack output, int outputMeta) {
            this.input = input;
            this.inputMeta = inputMeta;
            this.output = output;
            this.outputMeta = outputMeta;
        }
    }
}

