/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.types.classifier;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import openperipheral.adapter.types.classifier.DefaultTypeClassifier;
import openperipheral.api.adapter.IScriptType;
import openperipheral.api.adapter.ITypeClassifier;

public class TypeClassifier
implements ITypeClassifier {
    public static final TypeClassifier INSTANCE = new TypeClassifier();
    private final List<ITypeClassifier.IGenericClassifier> classifiers = Lists.newArrayList();

    public TypeClassifier() {
        this.registerDefaultClassifiers();
    }

    protected void registerDefaultClassifiers() {
        this.registerClassifier(new DefaultTypeClassifier());
    }

    @Override
    public void registerClassifier(ITypeClassifier.IGenericClassifier classifier) {
        this.classifiers.add(classifier);
    }

    @Override
    public void registerClassifier(ITypeClassifier.IClassClassifier classifier) {
        this.classifiers.add(new ClassQualifierAdapter(classifier));
    }

    @Override
    public void registerType(Class<?> cls, final IScriptType type) {
        final TypeToken match = TypeToken.of(cls);
        this.classifiers.add(new ITypeClassifier.IGenericClassifier(){

            @Override
            public IScriptType classify(ITypeClassifier classifier, Type t) {
                return match.isAssignableFrom(t) ? type : null;
            }
        });
    }

    @Override
    public IScriptType classifyType(Type type) {
        for (ITypeClassifier.IGenericClassifier c : this.classifiers) {
            IScriptType result = c.classify(this, type);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException(String.format("Can't classify type '%s'", type));
    }

    private static class ClassQualifierAdapter
    implements ITypeClassifier.IGenericClassifier {
        private final ITypeClassifier.IClassClassifier wrapped;

        public ClassQualifierAdapter(ITypeClassifier.IClassClassifier wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public IScriptType classify(ITypeClassifier classifier, Type type) {
            TypeToken token = TypeToken.of((Type)type);
            return this.wrapped.classify(classifier, token.getRawType());
        }
    }
}

