/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc;

import com.google.common.base.Throwables;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaTask;
import dan200.computercraft.api.lua.LuaException;
import openperipheral.adapter.AdapterLogicException;

public class SynchronousExecutor {
    public static final Object[] DUMMY = new Object[0];

    public static Object[] executeInMainThread(ILuaContext context, Task task) throws LuaException, InterruptedException {
        Responder responder = new Responder(context, task);
        long taskId = context.issueMainThreadTask((ILuaTask)responder);
        responder.waitForEvent(taskId);
        Throwable error = responder.error;
        if (error != null) {
            if (error instanceof LuaException) {
                throw (LuaException)error;
            }
            throw new LuaException(AdapterLogicException.getMessageForThrowable(error));
        }
        return responder.result;
    }

    private static class Responder
    implements ILuaTask {
        private static final String CALLBACK_EVENT_ID = "task_complete";
        private final ILuaContext context;
        private final Task task;
        private boolean nobodyLovesMe;
        public Throwable error;
        public Object[] result;

        public Responder(ILuaContext context, Task task) {
            this.context = context;
            this.task = task;
        }

        public void waitForEvent(long transactionId) throws LuaException, InterruptedException {
            while (!this.nobodyLovesMe) {
                Object[] result;
                try {
                    result = this.context.pullEvent(CALLBACK_EVENT_ID);
                }
                catch (LuaException e) {
                    this.nobodyLovesMe = true;
                    throw e;
                }
                catch (InterruptedException e) {
                    this.nobodyLovesMe = true;
                    throw e;
                }
                catch (Throwable t) {
                    this.nobodyLovesMe = true;
                    throw Throwables.propagate((Throwable)t);
                }
                if (!result[0].equals(CALLBACK_EVENT_ID)) {
                    throw new LuaException("pullEvent failed, expected 'task_complete', got: " + result[0]);
                }
                long receivedTransactionId = ((Number)result[1]).longValue();
                if (transactionId != receivedTransactionId) continue;
                boolean success = (Boolean)result[2];
                if (success) break;
                throw new LuaException(String.valueOf(result[3]));
            }
        }

        public Object[] execute() {
            try {
                this.result = this.task.execute();
            }
            catch (Throwable e) {
                this.error = e;
            }
            return DUMMY;
        }
    }

    public static interface Task {
        public Object[] execute() throws LuaException, InterruptedException;
    }
}

