/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import minetweaker.runtime.ILogger;

public class FileLogger
implements ILogger {
    private final Writer writer;
    private final PrintWriter printWriter;

    public FileLogger(File output) {
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "utf-8");
            this.printWriter = new PrintWriter(this.writer);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("What the heck?");
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Could not open log file " + output);
        }
    }

    @Override
    public void logCommand(String message) {
        try {
            this.writer.write(message + "\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logInfo(String message) {
        try {
            this.writer.write("INFO: " + message + "\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logWarning(String message) {
        try {
            this.writer.write("WARNING: " + message + "\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logError(String message) {
        this.logError(message, null);
    }

    @Override
    public void logError(String message, Throwable exception) {
        try {
            this.writer.write("ERROR: " + message + "\n");
            if (exception != null) {
                exception.printStackTrace(this.printWriter);
            }
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

