/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.util;

import amerifrance.guideapi.ConfigHandler;
import amerifrance.guideapi.api.GuideAPIItems;
import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.NBTBookTags;
import amerifrance.guideapi.items.ItemLostPage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class EventHandler {
    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            NBTTagCompound tag = this.getModTag(player, "guideapi");
            if (ConfigHandler.canSpawnWithBooks) {
                for (Book book : GuideRegistry.getBookList()) {
                    if (!book.spawnWithBook || tag.func_74767_n("hasInitial" + book.unlocBookTitle)) continue;
                    player.field_71071_by.func_70441_a(GuideRegistry.getItemStackForBook(book));
                    player.field_71069_bz.func_75142_b();
                    tag.func_74757_a("hasInitial" + book.unlocBookTitle, true);
                }
            }
        }
    }

    public NBTTagCompound getModTag(EntityPlayer player, String modName) {
        NBTTagCompound modTag;
        NBTTagCompound persistTag;
        NBTTagCompound tag = player.getEntityData();
        if (tag.func_74764_b("PlayerPersisted")) {
            persistTag = tag.func_74775_l("PlayerPersisted");
        } else {
            persistTag = new NBTTagCompound();
            tag.func_74782_a("PlayerPersisted", (NBTBase)persistTag);
        }
        if (persistTag.func_74764_b(modName)) {
            modTag = persistTag.func_74775_l(modName);
        } else {
            modTag = new NBTTagCompound();
            persistTag.func_74782_a(modName, (NBTBase)modTag);
        }
        return modTag;
    }

    @SubscribeEvent
    public void onAnvil(AnvilUpdateEvent event) {
        ItemStack left = event.left;
        ItemStack right = event.right;
        if (left == null || right == null || !right.func_77942_o()) {
            return;
        }
        if (left.func_77973_b() == GuideAPIItems.guideBook && right.func_77973_b() == GuideAPIItems.lostPage) {
            if (ItemLostPage.getPageCharacteristics(right) != null && left.func_77960_j() == GuideRegistry.getIndexOf((Book)ItemLostPage.getPageCharacteristics(right)[0])) {
                ItemStack output = left.func_77946_l();
                if (!output.func_77942_o()) {
                    output.func_77982_d(new NBTTagCompound());
                }
                output.field_77990_d.func_74757_a(right.field_77990_d.func_74779_i(NBTBookTags.KEY_TAG), true);
                event.output = output;
                event.cost = 5;
            }
        } else if (left.func_77973_b() == GuideAPIItems.lostPage && right.func_77973_b() == Items.field_151121_aF) {
            ItemStack output = left.func_77946_l();
            output.field_77994_a = 2;
            event.output = output;
            event.cost = 5;
        }
    }
}

