/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.TypeAdapterFactory;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.IChatComponent;

public class JsonHelper {
    public static Gson chatComponentGson;

    public static void init() {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeHierarchyAdapter(IChatComponent.class, (Object)new IChatComponent.Serializer());
        gb.registerTypeHierarchyAdapter(ChatStyle.class, (Object)new ChatStyle.Serializer());
        gb.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
        chatComponentGson = gb.create();
    }

    public static JsonElement serializeICC(IChatComponent c) {
        if (c == null) {
            return JsonNull.INSTANCE;
        }
        return chatComponentGson.toJsonTree((Object)c, IChatComponent.class);
    }

    public static IChatComponent deserializeICC(JsonElement e) {
        if (e == null || e.isJsonNull()) {
            return null;
        }
        return (IChatComponent)chatComponentGson.fromJson(e, IChatComponent.class);
    }
}

