/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.cmd;

import ftb.lib.api.cmd.CommandLM;
import ftb.lib.api.cmd.CommandLevel;
import ftb.lib.api.cmd.ICustomCommandInfo;
import ftb.lib.api.cmd.InvalidSubCommandException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import latmod.lib.LMListUtils;
import latmod.lib.LMStringUtils;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandSubLM
extends CommandLM
implements ICustomCommandInfo {
    public final Map<String, CommandLM> subCommands = new HashMap<String, CommandLM>();

    public CommandSubLM(String s, CommandLevel l) {
        super(s, l);
    }

    public void add(CommandLM c) {
        this.subCommands.put(c.commandName, c);
    }

    @Override
    public String func_71518_a(ICommandSender ics) {
        return "/" + this.commandName + " [ " + LMStringUtils.strip(LMListUtils.toStringArray(this.subCommands.keySet())) + " ]";
    }

    @Override
    public String[] getTabStrings(ICommandSender ics, String[] args, int i) throws CommandException {
        String[] s;
        if (i == 0) {
            return LMListUtils.toStringArray(this.subCommands.keySet());
        }
        CommandLM cmd = this.subCommands.get(args[0]);
        if (cmd != null && (s = cmd.getTabStrings(ics, LMStringUtils.shiftArray(args), i - 1)) != null && s.length > 0) {
            return s;
        }
        return super.getTabStrings(ics, args, i);
    }

    @Override
    public Boolean getUsername(String[] args, int i) {
        CommandLM cmd;
        if (i > 0 && args.length > 1 && (cmd = this.subCommands.get(args[0])) != null) {
            return cmd.getUsername(LMStringUtils.shiftArray(args), i - 1);
        }
        return null;
    }

    @Override
    public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
        if (args == null || args.length == 0) {
            return new ChatComponentText(LMStringUtils.strip(this.getTabStrings(ics, args, 0)));
        }
        CommandLM cmd = this.subCommands.get(args[0]);
        if (cmd != null) {
            return cmd.onCommand(ics, LMStringUtils.shiftArray(args));
        }
        throw new InvalidSubCommandException(args[0]);
    }

    @Override
    public void addInfo(List<IChatComponent> list, ICommandSender sender) {
        list.add((IChatComponent)new ChatComponentText('/' + this.commandName));
        list.add(null);
        this.addCommandUsage(sender, list, 0);
    }

    private static IChatComponent tree(IChatComponent sibling, int level) {
        if (level == 0) {
            return sibling;
        }
        char[] chars = new char[level * 2];
        Arrays.fill(chars, ' ');
        return new ChatComponentText(new String(chars)).func_150257_a(sibling);
    }

    private void addCommandUsage(ICommandSender ics, List<IChatComponent> list, int level) {
        for (CommandLM c : this.subCommands.values()) {
            if (c instanceof CommandSubLM) {
                list.add(CommandSubLM.tree((IChatComponent)new ChatComponentText('/' + c.commandName), level));
                ((CommandSubLM)c).addCommandUsage(ics, list, level + 1);
                continue;
            }
            String usage = c.func_71518_a(ics);
            if (usage.indexOf(47) != -1 || usage.indexOf(37) != -1) {
                list.add(CommandSubLM.tree((IChatComponent)new ChatComponentText(usage), level));
                continue;
            }
            list.add(CommandSubLM.tree((IChatComponent)new ChatComponentTranslation(usage, new Object[0]), level));
        }
    }
}

