/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.tile;

import ftb.lib.api.item.LMInvUtils;
import ftb.lib.api.tile.TileLM;
import latmod.lib.MathHelperLM;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileInvLM
extends TileLM
implements IInventory {
    private String customName = "";
    public final ItemStack[] items;
    public boolean dropItems = true;
    public final int[] ALL_SLOTS;

    public TileInvLM(int invSize) {
        this.items = new ItemStack[invSize];
        this.ALL_SLOTS = MathHelperLM.getAllInts(0, invSize);
    }

    @Override
    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        LMInvUtils.readItemsFromNBT(this.items, tag, "Items");
        this.customName = tag.func_74779_i("CustomName");
    }

    @Override
    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        LMInvUtils.writeItemsToNBT(this.items, tag, "Items");
        if (!this.customName.isEmpty()) {
            tag.func_74778_a("CustomName", this.customName);
        }
    }

    @Override
    public void onBroken() {
        if (this.isServer() && this.dropItems && this.items.length > 0) {
            LMInvUtils.dropAllItems(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.items);
        }
        this.func_70296_d();
        super.onBroken();
    }

    public String func_145825_b() {
        return this.customName;
    }

    @Override
    public void setName(String s) {
        this.customName = s;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int i, int j) {
        return LMInvUtils.decrStackSize(this, i, j);
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70304_b(int i) {
        return LMInvUtils.removeStackFromSlot(this, i);
    }

    public void func_70299_a(int i, ItemStack is) {
        this.items[i] = is;
    }

    public boolean func_70300_a(EntityPlayer ep) {
        return this.security.canInteract(ep);
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return true;
    }

    public void clear() {
        LMInvUtils.clear(this);
    }

    public boolean func_145818_k_() {
        return !this.func_145825_b().isEmpty();
    }

    public final String getName() {
        return this.func_145825_b();
    }
}

