/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib;

import java.text.DecimalFormat;
import java.util.Random;
import latmod.lib.util.VecLM;

public class MathHelperLM {
    public static final Random rand = new Random();
    public static final DecimalFormat smallDoubleFormatter = new DecimalFormat("#0.00");
    public static final double RAD = Math.PI / 180;
    public static final double DEG = 57.29577951308232;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final float PI_F = (float)Math.PI;
    public static final float TWO_PI_F = (float)Math.PI * 2;
    public static final float HALF_PI_F = 1.5707964f;
    public static final double SQRT_2 = Math.sqrt(2.0);
    public static final float RAD_F = (float)Math.PI / 180;
    public static final float DEG_F = 57.29578f;
    private static final int SIN_TABLE_SIZE = 65536;
    private static final int SIN_TABLE_SIZE_1 = 65535;
    private static final double[] SIN_TABLE = new double[65536];
    private static final double SIN_SCALE = 10430.378350470453;
    private static final double COS_SHIFT = 16384.0;

    public static double sin(double d) {
        return SIN_TABLE[(int)(d * 10430.378350470453) & 0xFFFF];
    }

    public static double cos(double d) {
        return SIN_TABLE[(int)(d * 10430.378350470453 + 16384.0) & 0xFFFF];
    }

    public static double tan(double d) {
        return MathHelperLM.sin(d) / MathHelperLM.cos(d);
    }

    public static double sinFromDeg(double f) {
        return MathHelperLM.sin(f * (Math.PI / 180));
    }

    public static double cosFromDeg(double f) {
        return MathHelperLM.cos(f * (Math.PI / 180));
    }

    public static double tanFromDeg(double f) {
        return MathHelperLM.tan(f * (Math.PI / 180));
    }

    public static double sqrt(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        return Math.sqrt(d);
    }

    public static double sqrt2sq(double x, double y) {
        return MathHelperLM.sqrt(MathHelperLM.sq(x) + MathHelperLM.sq(y));
    }

    public static double sqrt3sq(double x, double y, double z) {
        return MathHelperLM.sqrt(MathHelperLM.sq(x) + MathHelperLM.sq(y) + MathHelperLM.sq(z));
    }

    public static double sq(double f) {
        return f * f;
    }

    public static double power(double i, int n) {
        if (n == 2) {
            return i * i;
        }
        double i1 = 1.0;
        for (int j = 0; j < n; ++j) {
            i1 *= i;
        }
        return i1;
    }

    public static int power(int i, int n) {
        if (n == 2) {
            return i * i;
        }
        int i1 = 1;
        for (int j = 0; j < n; ++j) {
            i1 *= i;
        }
        return i1;
    }

    public static long power(long i, int n) {
        if (n == 2) {
            return i * i;
        }
        long i1 = 1L;
        for (int j = 0; j < n; ++j) {
            i1 *= i;
        }
        return i1;
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        if (x1 == x2 && y1 == y2 && z1 == z2) {
            return 0.0;
        }
        return MathHelperLM.sq(x2 - x1) + MathHelperLM.sq(y2 - y1) + MathHelperLM.sq(z2 - z1);
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathHelperLM.sqrt(MathHelperLM.distSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distSq(double x1, double y1, double x2, double y2) {
        if (x1 == x2 && y1 == y2) {
            return 0.0;
        }
        return MathHelperLM.sq(x2 - x1) + MathHelperLM.sq(y2 - y1);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return MathHelperLM.sqrt(MathHelperLM.distSq(x1, y1, x2, y2));
    }

    public static VecLM getLook(VecLM v, double yaw, double pitch, double dist) {
        if (v == null) {
            v = new VecLM();
        }
        double f = MathHelperLM.cos(pitch * (Math.PI / 180));
        double x1 = MathHelperLM.cos(-yaw * (Math.PI / 180) + 1.5707963267948966);
        double z1 = MathHelperLM.sin(-yaw * (Math.PI / 180) + 1.5707963267948966);
        double y1 = MathHelperLM.sin(pitch * (Math.PI / 180));
        v.set(x1 * f * dist, y1 * dist, z1 * f * dist);
        return v;
    }

    public static int floor(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static int ceil(double d) {
        int i = (int)d;
        return d > (double)i ? i + 1 : i;
    }

    public static int chunk(int i) {
        return i >> 4;
    }

    public static int unchunk(int i) {
        return i << 4;
    }

    public static int chunk(double d) {
        return MathHelperLM.chunk(MathHelperLM.floor(d));
    }

    public static int randomInt(Random r, int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            int min0 = min;
            min = max;
            max = min0;
        }
        return min + r.nextInt(max - min + 1);
    }

    public static double randomDouble(Random r, double min, double max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            double min0 = min;
            min = max;
            max = min0;
        }
        return min + r.nextDouble() * (max - min);
    }

    public static boolean isRound(double d) {
        return (double)Math.round(d) == d;
    }

    public static int lerpInt(int i1, int i2, double f) {
        return i1 + (int)((double)(i2 - i1) * f);
    }

    public static double lerp(double f1, double f2, double f) {
        return f1 + (f2 - f1) * f;
    }

    public static double clamp(double n, double min, double max) {
        if (n < min) {
            return min;
        }
        if (n > max) {
            return max;
        }
        return n;
    }

    public static int clampInt(int n, int min, int max) {
        if (n < min) {
            return min;
        }
        if (n > max) {
            return max;
        }
        return n;
    }

    public static float clampFloat(float n, float min, float max) {
        if (n < min) {
            return min;
        }
        if (n > max) {
            return max;
        }
        return n;
    }

    public static double[] clamp(double[] d, double min, double max) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = MathHelperLM.clamp(d[i], min, max);
        }
        return d;
    }

    public static int[] clampInt(int[] i, int min, int max) {
        for (int j = 0; j < i.length; ++j) {
            i[j] = MathHelperLM.clampInt(i[j], min, max);
        }
        return i;
    }

    public static String toSmallDouble(double d) {
        return smallDoubleFormatter.format(d);
    }

    public static double map(double val, double min1, double max1, double min2, double max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    public static int mapInt(int val, int min1, int max1, int min2, int max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    public static VecLM getMidPoint(double x1, double y1, double z1, double x2, double y2, double z2, double p) {
        double x = x2 - x1;
        double y = y2 - y1;
        double z = z2 - z1;
        double d = Math.sqrt(x * x + y * y + z * z);
        return new VecLM(x1 + x / d * (d * p), y1 + y / d * (d * p), z1 + z / d * (d * p));
    }

    public static VecLM getMidPoint(VecLM v1, VecLM v2, double p) {
        return MathHelperLM.getMidPoint(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, p);
    }

    public static int getRotations(double yaw, int max) {
        return MathHelperLM.floor(yaw * (double)max / 360.0 + 0.5) & max - 1;
    }

    public static int getRotYaw(int rot) {
        if (rot == 2) {
            return 180;
        }
        if (rot == 3) {
            return 0;
        }
        if (rot == 4) {
            return 90;
        }
        if (rot == 5) {
            return -90;
        }
        return 0;
    }

    public static int getRotPitch(int rot) {
        if (rot == 0) {
            return 90;
        }
        if (rot == 1) {
            return -90;
        }
        return 0;
    }

    public static boolean inRange(double d, double min, double max) {
        return d >= min && d <= max;
    }

    public static int percent(double d, double max) {
        return (int)(d / max * 100.0);
    }

    public static int[] flip(int[] i) {
        if (i == null) {
            return null;
        }
        int[] ai = new int[i.length];
        for (int j = 0; j < i.length; ++j) {
            ai[j] = i[i.length - 1 - j];
        }
        return ai;
    }

    public static int[] getAllInts(int min, int size) {
        int[] ai = new int[size];
        for (int i = 0; i < size; ++i) {
            ai[i] = min + i;
        }
        return ai;
    }

    public static double wrap(double i, double n) {
        if ((i %= n) < 0.0) {
            i += n;
        }
        return i;
    }

    public static int wrap(int i, int n) {
        if ((i %= n) < 0) {
            i += n;
        }
        return i;
    }

    public static boolean isPow2(int i) {
        return i != 0 && (i & i - 1) == 0;
    }

    static {
        double ds = 9.587379924285257E-5;
        for (int i = 0; i < 65536; ++i) {
            MathHelperLM.SIN_TABLE[i] = Math.sin((double)i * ds);
        }
    }
}

