/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEPlinth;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class RitualEffectBiomeChanger
extends RitualEffect {
    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int cooldown = ritualStone.getCooldown();
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (cooldown > 0) {
            ritualStone.setCooldown(cooldown - 1);
            if (world.field_73012_v.nextInt(15) == 0) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)(x - 1 + world.field_73012_v.nextInt(3)), (double)(y + 1), (double)(z - 1 + world.field_73012_v.nextInt(3))));
            }
            return;
        }
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        int range = 10;
        if (currentEssence < this.getCostPerRefresh()) {
            EntityPlayer entityOwner = SpellHelper.getPlayerForUsername(owner);
            if (entityOwner == null) {
                return;
            }
            entityOwner.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 80));
        } else {
            boolean[][] boolList = new boolean[range * 2 + 1][range * 2 + 1];
            for (int i = 0; i < 2 * range + 1; ++i) {
                for (int j = 0; j < 2 * range + 1; ++j) {
                    boolList[i][j] = false;
                }
            }
            boolList[range][range] = true;
            boolean isReady = false;
            while (!isReady) {
                isReady = true;
                for (int i = 0; i < 2 * range + 1; ++i) {
                    for (int j = 0; j < 2 * range + 1; ++j) {
                        Block block;
                        if (!boolList[i][j]) continue;
                        if (!(i - 1 < 0 || boolList[i - 1][j] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i - 1, y + 1, z - range + j)) || ModBlocks.bloodStoneBrick.equals(block))) {
                            boolList[i - 1][j] = true;
                            isReady = false;
                        }
                        if (!(j - 1 < 0 || boolList[i][j - 1] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i, y + 1, z - range + j - 1)) || ModBlocks.bloodStoneBrick.equals(block))) {
                            boolList[i][j - 1] = true;
                            isReady = false;
                        }
                        if (!(i + 1 > 2 * range || boolList[i + 1][j] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i + 1, y + 1, z - range + j)) || ModBlocks.bloodStoneBrick.equals(block))) {
                            boolList[i + 1][j] = true;
                            isReady = false;
                        }
                        if (j + 1 > 2 * range || boolList[i][j + 1] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i, y + 1, z - range + j + 1)) || ModBlocks.bloodStoneBrick.equals(block)) continue;
                        boolList[i][j + 1] = true;
                        isReady = false;
                    }
                }
            }
            float temperature = 0.5f;
            float humidity = 0.5f;
            float acceptableRange = 0.1f;
            int biomeSkip = 0;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    Item itemTest;
                    if (i == 0 && j == 0) continue;
                    boolean isItemConsumed = false;
                    TileEntity tileEntity = world.func_147438_o(x + i, y, z + j);
                    if (!(tileEntity instanceof TEPlinth)) continue;
                    TEPlinth tilePlinth = (TEPlinth)tileEntity;
                    ItemStack itemStack = tilePlinth.func_70301_a(0);
                    if (itemStack != null && (itemTest = itemStack.func_77973_b()) != null) {
                        if (itemTest instanceof ItemBlock) {
                            Block item = ((ItemBlock)itemTest).field_150939_a;
                            if (item == Blocks.field_150354_m) {
                                humidity -= 0.1f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150368_y) {
                                humidity += 0.4f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150354_m) {
                                humidity -= 0.1f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150322_A) {
                                humidity -= 0.2f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150424_aL) {
                                humidity -= 0.4f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150402_ci) {
                                temperature += 0.2f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150432_aD) {
                                temperature -= 0.4f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150433_aE) {
                                temperature -= 0.2f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150325_L) {
                                int skip = itemStack.func_77960_j() + 1;
                                biomeSkip += skip;
                                isItemConsumed = true;
                            }
                        } else if (itemTest.equals(Items.field_151100_aR) && itemStack.func_77960_j() == 4) {
                            humidity += 0.1f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151129_at)) {
                            temperature += 0.4f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151131_as)) {
                            humidity += 0.2f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151044_h)) {
                            temperature += 0.1f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151126_ay)) {
                            temperature -= 0.1f;
                            isItemConsumed = true;
                        }
                    }
                    if (!isItemConsumed) continue;
                    tilePlinth.func_70299_a(0, null);
                    world.func_147471_g(x + i, y, z + j);
                    world.func_72942_c((Entity)new EntityLightningBolt(world, (double)(x + i), (double)(y + 1), (double)(z + j)));
                }
            }
            boolean wantsSnow = false;
            boolean wantsRain = true;
            int biomeID = 1;
            BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
            int iteration = 0;
            for (BiomeGenBase biome : biomeList) {
                if (biome == null) continue;
                float temp = biome.field_76750_F;
                float rainfall = biome.field_76751_G;
                temperature = Math.min(2.0f, Math.max(0.0f, temperature));
                if (Math.abs(rainfall - (humidity = Math.min(2.0f, Math.max(0.0f, humidity)))) < acceptableRange && Math.abs(temperature - temp) < acceptableRange) {
                    biomeID = iteration;
                    if (biomeSkip == 0) break;
                    --biomeSkip;
                }
                ++iteration;
            }
            if (biomeSkip != 0) {
                biomeID = 1;
            }
            for (int i = 0; i < 2 * range + 1; ++i) {
                for (int j = 0; j < 2 * range + 1; ++j) {
                    if (!boolList[i][j]) continue;
                    Chunk chunk = world.func_72938_d(x - range + i, z - range + j);
                    byte[] byteArray = chunk.func_76605_m();
                    int moduX = (x - range + i) % 16;
                    int moduZ = (z - range + j) % 16;
                    if (moduX < 0) {
                        moduX += 16;
                    }
                    if (moduZ < 0) {
                        moduZ += 16;
                    }
                    byteArray[moduZ * 16 + moduX] = (byte)biomeID;
                    chunk.func_76616_a(byteArray);
                }
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
            ritualStone.setActive(false);
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostGaia[1];
    }

    @Override
    public int getInitialCooldown() {
        return 200;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> biomeChangerRitual = new ArrayList<RitualComponent>();
        biomeChangerRitual.add(new RitualComponent(1, 0, -2, 4));
        biomeChangerRitual.add(new RitualComponent(1, 0, -3, 4));
        biomeChangerRitual.add(new RitualComponent(2, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(3, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(1, 0, 2, 4));
        biomeChangerRitual.add(new RitualComponent(1, 0, 3, 4));
        biomeChangerRitual.add(new RitualComponent(2, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(3, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -2, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -3, 4));
        biomeChangerRitual.add(new RitualComponent(-2, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(-3, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 2, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 3, 4));
        biomeChangerRitual.add(new RitualComponent(-2, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(-3, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(3, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(3, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, -5, 2));
        biomeChangerRitual.add(new RitualComponent(5, 0, -4, 2));
        biomeChangerRitual.add(new RitualComponent(3, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(3, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, 5, 2));
        biomeChangerRitual.add(new RitualComponent(5, 0, 4, 2));
        biomeChangerRitual.add(new RitualComponent(-3, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(-3, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 5, 2));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 4, 2));
        biomeChangerRitual.add(new RitualComponent(-3, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(-3, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -5, 2));
        biomeChangerRitual.add(new RitualComponent(-5, 0, -4, 2));
        biomeChangerRitual.add(new RitualComponent(0, 0, -5, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -6, 1));
        biomeChangerRitual.add(new RitualComponent(1, 0, -6, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -8, 0));
        biomeChangerRitual.add(new RitualComponent(0, 0, -8, 0));
        biomeChangerRitual.add(new RitualComponent(1, 0, -8, 0));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -10, 5));
        biomeChangerRitual.add(new RitualComponent(0, 0, -10, 5));
        biomeChangerRitual.add(new RitualComponent(1, 0, -10, 5));
        biomeChangerRitual.add(new RitualComponent(0, 0, 5, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 6, 1));
        biomeChangerRitual.add(new RitualComponent(1, 0, 6, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 8, 0));
        biomeChangerRitual.add(new RitualComponent(0, 0, 8, 0));
        biomeChangerRitual.add(new RitualComponent(1, 0, 8, 0));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 10, 5));
        biomeChangerRitual.add(new RitualComponent(0, 0, 10, 5));
        biomeChangerRitual.add(new RitualComponent(1, 0, 10, 5));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 0, 1));
        biomeChangerRitual.add(new RitualComponent(-6, 0, -1, 1));
        biomeChangerRitual.add(new RitualComponent(-6, 0, 1, 1));
        biomeChangerRitual.add(new RitualComponent(-8, 0, -1, 0));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 0, 0));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 1, 0));
        biomeChangerRitual.add(new RitualComponent(-10, 0, -1, 5));
        biomeChangerRitual.add(new RitualComponent(-10, 0, 0, 5));
        biomeChangerRitual.add(new RitualComponent(-10, 0, 1, 5));
        biomeChangerRitual.add(new RitualComponent(5, 0, 0, 1));
        biomeChangerRitual.add(new RitualComponent(6, 0, -1, 1));
        biomeChangerRitual.add(new RitualComponent(6, 0, 1, 1));
        biomeChangerRitual.add(new RitualComponent(8, 0, -1, 0));
        biomeChangerRitual.add(new RitualComponent(8, 0, 0, 0));
        biomeChangerRitual.add(new RitualComponent(8, 0, 1, 0));
        biomeChangerRitual.add(new RitualComponent(10, 0, -1, 5));
        biomeChangerRitual.add(new RitualComponent(10, 0, 0, 5));
        biomeChangerRitual.add(new RitualComponent(10, 0, 1, 5));
        biomeChangerRitual.add(new RitualComponent(6, 0, -6, 4));
        biomeChangerRitual.add(new RitualComponent(6, 0, -7, 4));
        biomeChangerRitual.add(new RitualComponent(7, 0, -6, 4));
        biomeChangerRitual.add(new RitualComponent(7, 0, -5, 3));
        biomeChangerRitual.add(new RitualComponent(5, 0, -7, 3));
        biomeChangerRitual.add(new RitualComponent(8, 0, -5, 5));
        biomeChangerRitual.add(new RitualComponent(8, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(9, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(5, 0, -8, 5));
        biomeChangerRitual.add(new RitualComponent(4, 0, -8, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, -9, 3));
        biomeChangerRitual.add(new RitualComponent(-6, 0, 6, 4));
        biomeChangerRitual.add(new RitualComponent(-6, 0, 7, 4));
        biomeChangerRitual.add(new RitualComponent(-7, 0, 6, 4));
        biomeChangerRitual.add(new RitualComponent(-7, 0, 5, 3));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 7, 3));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 5, 5));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(-9, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 8, 5));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 8, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 9, 3));
        biomeChangerRitual.add(new RitualComponent(6, 0, 6, 2));
        biomeChangerRitual.add(new RitualComponent(6, 0, 7, 2));
        biomeChangerRitual.add(new RitualComponent(7, 0, 6, 2));
        biomeChangerRitual.add(new RitualComponent(7, 0, 5, 1));
        biomeChangerRitual.add(new RitualComponent(5, 0, 7, 1));
        biomeChangerRitual.add(new RitualComponent(8, 0, 5, 5));
        biomeChangerRitual.add(new RitualComponent(8, 0, 4, 1));
        biomeChangerRitual.add(new RitualComponent(9, 0, 4, 1));
        biomeChangerRitual.add(new RitualComponent(5, 0, 8, 5));
        biomeChangerRitual.add(new RitualComponent(4, 0, 8, 1));
        biomeChangerRitual.add(new RitualComponent(4, 0, 9, 1));
        biomeChangerRitual.add(new RitualComponent(-6, 0, -6, 2));
        biomeChangerRitual.add(new RitualComponent(-6, 0, -7, 2));
        biomeChangerRitual.add(new RitualComponent(-7, 0, -6, 2));
        biomeChangerRitual.add(new RitualComponent(-7, 0, -5, 1));
        biomeChangerRitual.add(new RitualComponent(-5, 0, -7, 1));
        biomeChangerRitual.add(new RitualComponent(-8, 0, -5, 5));
        biomeChangerRitual.add(new RitualComponent(-8, 0, -4, 1));
        biomeChangerRitual.add(new RitualComponent(-9, 0, -4, 1));
        biomeChangerRitual.add(new RitualComponent(-5, 0, -8, 5));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -8, 1));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -9, 1));
        return biomeChangerRitual;
    }
}

