/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.grid;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridException;
import appeng.tile.misc.TileSecurity;
import appeng.tile.networking.TileWireless;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.api.grid.IEssentiaGrid;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;

public abstract class WirelessAELink
implements IStorageMonitorable {
    protected final EntityPlayer player;
    protected final String encryptionKey;
    protected IWirelessAccessPoint accessPoint;
    protected DimensionalCoord apLocation = null;
    protected BaseActionSource actionSource;

    public WirelessAELink(@Nullable EntityPlayer player, @Nonnull String encryptionKey) {
        this.player = player;
        this.encryptionKey = encryptionKey;
        this.linkWithNewAP();
    }

    private static boolean isAPInRange(DimensionalCoord APLocation, double APRange, World world, int x, int y, int z) {
        if (!APLocation.isInWorld(world)) {
            return false;
        }
        double squareDistance = WirelessAELink.getSquaredDistanceFromAP(APLocation, x, y, z);
        return squareDistance <= APRange * APRange;
    }

    private static ArrayList<IWirelessAccessPoint> locateAPsInRange(World world, int x, int y, int z, IGrid grid) {
        IMachineSet accessPoints = grid.getMachines(TileWireless.class);
        if (accessPoints.isEmpty()) {
            return null;
        }
        ArrayList<IWirelessAccessPoint> aps = new ArrayList<IWirelessAccessPoint>();
        for (IGridNode APNode : accessPoints) {
            IWirelessAccessPoint AP = (IWirelessAccessPoint)APNode.getMachine();
            if (!AP.isActive() || !WirelessAELink.isAPInRange(AP.getLocation(), AP.getRange(), world, x, y, z)) continue;
            aps.add(AP);
        }
        return aps;
    }

    protected static double getSquaredDistanceFromAP(DimensionalCoord locationAP, int x, int y, int z) {
        if (locationAP == null) {
            return Double.MAX_VALUE;
        }
        int dX = locationAP.x - x;
        int dY = locationAP.y - y;
        int dZ = locationAP.z - z;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public static ArrayList<IWirelessAccessPoint> locateAPsInRange(World world, int x, int y, int z, String encryptionKey) {
        IGrid grid;
        long encryptionValue;
        try {
            encryptionValue = Long.parseLong(encryptionKey);
        }
        catch (NumberFormatException e) {
            return null;
        }
        ILocatable source = AEApi.instance().registries().locatable().getLocatableBy(encryptionValue);
        if (!(source instanceof TileSecurity)) {
            return null;
        }
        TileSecurity securityHost = (TileSecurity)source;
        try {
            grid = securityHost.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        }
        catch (Exception e) {
            return null;
        }
        return WirelessAELink.locateAPsInRange(world, x, y, z, grid);
    }

    public static ArrayList<IWirelessAccessPoint> locateAPsInRangeOfPlayer(EntityPlayer player, String encryptionKey) {
        return WirelessAELink.locateAPsInRange(player.field_70170_p, (int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v), encryptionKey);
    }

    private boolean isAPInRangeAndActive() {
        if (this.accessPoint != null && this.accessPoint.isActive()) {
            return WirelessAELink.isAPInRange(this.apLocation, this.accessPoint.getRange(), this.getUserWorld(), this.getUserPositionX(), this.getUserPositionY(), this.getUserPositionZ());
        }
        return false;
    }

    private boolean linkWithNewAP() {
        World w = this.getUserWorld();
        int x = this.getUserPositionX();
        int y = this.getUserPositionY();
        int z = this.getUserPositionZ();
        ArrayList<IWirelessAccessPoint> apList = null;
        if (this.accessPoint != null) {
            try {
                IGrid grid = this.accessPoint.getGrid();
                apList = grid != null ? WirelessAELink.locateAPsInRange(w, x, y, z, grid) : WirelessAELink.locateAPsInRange(w, x, y, z, this.encryptionKey);
            }
            catch (GridException grid) {
                // empty catch block
            }
        }
        IWirelessAccessPoint closestAP = null;
        if (apList != null) {
            double closestDistance = Double.MAX_VALUE;
            for (IWirelessAccessPoint ap : apList) {
                double dist = WirelessAELink.getSquaredDistanceFromAP(ap.getLocation(), x, y, z);
                if (!(dist < closestDistance)) continue;
                closestDistance = dist;
                closestAP = ap;
            }
        }
        if (closestAP != null) {
            this.setAP(closestAP);
        } else {
            this.accessPoint = null;
        }
        return this.accessPoint != null;
    }

    private void setAP(IWirelessAccessPoint accessPoint) {
        this.accessPoint = accessPoint;
        this.apLocation = this.accessPoint.getLocation();
        this.actionSource = this.player != null ? new PlayerSource(this.player, (IActionHost)this.accessPoint) : new MachineSource((IActionHost)this.accessPoint);
    }

    protected abstract int getUserPositionX();

    protected abstract int getUserPositionY();

    protected abstract int getUserPositionZ();

    protected abstract World getUserWorld();

    protected abstract boolean hasPowerToCommunicate();

    public IEnergyGrid getEnergyGrid() {
        if (this.accessPoint == null) {
            return null;
        }
        try {
            return (IEnergyGrid)this.accessPoint.getActionableNode().getGrid().getCache(IEnergyGrid.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IMEEssentiaMonitor getEssentiaInventory() {
        if (this.accessPoint == null || !this.isConnected()) {
            return null;
        }
        try {
            return (IMEEssentiaMonitor)this.accessPoint.getGrid().getCache(IEssentiaGrid.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.accessPoint == null || !this.isConnected()) {
            return null;
        }
        try {
            IStorageGrid storageGrid = (IStorageGrid)this.accessPoint.getActionableNode().getGrid().getCache(IStorageGrid.class);
            return storageGrid.getFluidInventory();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        if (this.accessPoint == null || !this.isConnected()) {
            return null;
        }
        try {
            IStorageGrid storageGrid = (IStorageGrid)this.accessPoint.getActionableNode().getGrid().getCache(IStorageGrid.class);
            return storageGrid.getItemInventory();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isConnected() {
        if (!this.hasPowerToCommunicate()) {
            return false;
        }
        if (this.isAPInRangeAndActive()) {
            return true;
        }
        return this.linkWithNewAP();
    }
}

