/*
 * Decompiled with CFR 0.152.
 */
package hats.client.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import hats.api.RenderOnEntityHelper;
import hats.client.gui.GuiHatSelection;
import hats.client.gui.GuiHatUnlocked;
import hats.client.gui.GuiTradeReq;
import hats.common.Hats;
import hats.common.core.HatHandler;
import hats.common.core.HatInfo;
import hats.common.entity.EntityHat;
import hats.common.packet.PacketPing;
import hats.common.packet.PacketRequestMobHats;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class TickHandlerClient {
    public HashMap<String, HatInfo> playerWornHats = new HashMap();
    public HashMap<String, EntityHat> hats = new HashMap();
    public HashMap<Integer, EntityHat> mobHats = new HashMap();
    public HashMap<Integer, EntityHat> rendered = new HashMap();
    public HashMap<String, Integer> availableHats = new HashMap();
    public HashMap<String, Integer> serverHats = new HashMap();
    public ArrayList<String> requestedHats = new ArrayList();
    public ArrayList<Integer> requestMobHats = new ArrayList();
    public ArrayList<Integer> requestedMobHats = new ArrayList();
    public World worldInstance;
    public long clock;
    public long lastHitKey;
    public float rotationYaw;
    public float rotationPitch;
    public double posX;
    public double posY;
    public double posZ;
    public boolean isActive;
    public boolean hasScreen;
    public int currentHatRenders;
    public int requestCooldown;
    public GuiHatUnlocked guiHatUnlocked;
    public GuiTradeReq guiNewTradeReq;
    public String tradeReq;
    public int tradeReqTimeout;

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            WorldClient world = mc.field_71441_e;
            if (event.phase == TickEvent.Phase.START) {
                this.currentHatRenders = 0;
                for (Map.Entry<String, EntityHat> e : this.hats.entrySet()) {
                    if (e.getValue().parent == null) continue;
                    EntityHat hat = e.getValue();
                    this.updateHatPosAndAngle(hat, hat.renderingParent);
                }
                for (Map.Entry<Integer, EntityHat> e : this.mobHats.entrySet()) {
                    if (e.getValue().parent == null) continue;
                    EntityHat hat = e.getValue();
                    this.updateHatPosAndAngle(hat, hat.parent);
                }
            } else {
                if (this.guiHatUnlocked == null) {
                    this.guiHatUnlocked = new GuiHatUnlocked(mc);
                }
                this.guiHatUnlocked.updateGui();
                if (this.guiNewTradeReq == null) {
                    this.guiNewTradeReq = new GuiTradeReq(mc);
                }
                this.guiNewTradeReq.updateGui();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null) {
            int i;
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            if (this.worldInstance != world) {
                this.worldInstance = world;
                this.mobHats.clear();
                this.hats.clear();
                this.requestMobHats.clear();
                this.requestedMobHats.clear();
                this.requestCooldown = 40;
            }
            if (Hats.config.getSessionInt("showJoinMessage") == 1) {
                Hats.config.updateSession("showJoinMessage", (Object)0);
                mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation(Hats.config.getSessionInt("playerHatsMode") == 4 ? StatCollector.func_74838_a((String)"hats.firstJoin.hatHunting") : (Hats.config.getSessionInt("playerHatsMode") == 6 ? StatCollector.func_74838_a((String)"hats.firstJoin.timeActive") : StatCollector.func_74838_a((String)"hats.firstJoin.kingOfTheHat.hasKing")), new Object[0]));
            }
            if (Hats.config.getInt("enableInServersWithoutMod") == 1 && Hats.config.getSessionInt("serverHasMod") == 0 || Hats.config.getSessionInt("serverHasMod") == 1) {
                for (i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityHat hat;
                    EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
                    if (Hats.config.getSessionInt("serverHasMod") == 0 && Hats.config.getInt("shouldOtherPlayersHaveHats") == 0 && player != Minecraft.func_71410_x().field_71439_g || !player.func_70089_S() || (hat = this.hats.get(player.func_70005_c_())) != null && !hat.field_70128_L) continue;
                    if (player.func_70005_c_().equalsIgnoreCase(mc.field_71439_g.func_70005_c_())) {
                        for (Map.Entry<String, EntityHat> entry : this.hats.entrySet()) {
                            entry.getValue().func_70106_y();
                        }
                        for (Map.Entry<Object, EntityHat> entry : this.mobHats.entrySet()) {
                            entry.getValue().func_70106_y();
                        }
                        this.requestedMobHats.clear();
                    }
                    HatInfo hatInfo = Hats.config.getSessionInt("serverHasMod") == 1 ? this.getPlayerHat(player.func_70005_c_()) : (Hats.config.getInt("randomHat") == 1 || Hats.config.getInt("randomHat") == 2 && player != mc.field_71439_g ? HatHandler.getRandomHatFromList(HatHandler.getAllHats(), false) : Hats.favouriteHatInfo);
                    hat = new EntityHat((World)world, (EntityLivingBase)player, hatInfo);
                    this.hats.put(player.func_70005_c_(), hat);
                    world.func_72838_d((Entity)hat);
                }
            }
            if (this.clock != world.func_72820_D() || !world.func_82736_K().func_82766_b("doDaylightCycle")) {
                this.clock = world.func_72820_D();
                if (this.requestCooldown > 0) {
                    --this.requestCooldown;
                }
                if (this.tradeReqTimeout > 0) {
                    --this.tradeReqTimeout;
                    if (this.tradeReqTimeout == 0) {
                        if (mc.field_71462_r instanceof GuiHatSelection) {
                            ((GuiHatSelection)mc.field_71462_r).updateButtonList();
                        }
                        this.tradeReq = null;
                    }
                }
                if (this.clock % 5L == 0L && this.requestCooldown <= 0 && this.requestMobHats.size() > 0) {
                    PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketRequestMobHats(this.requestMobHats));
                    this.requestMobHats.clear();
                }
                if (Hats.config.getSessionInt("playerHatsMode") == 6) {
                    ++this.lastHitKey;
                    if (Keyboard.isKeyDown((int)mc.field_71474_y.field_74351_w.func_151463_i()) || Keyboard.isKeyDown((int)mc.field_71474_y.field_74368_y.func_151463_i()) || Keyboard.isKeyDown((int)mc.field_71474_y.field_74370_x.func_151463_i()) || Keyboard.isKeyDown((int)mc.field_71474_y.field_74366_z.func_151463_i())) {
                        this.lastHitKey = 0L;
                    }
                    if (this.clock % 107L == 0L) {
                        if ((this.lastHitKey > 100L || this.lastHitKey == 0L && this.posX == mc.field_71439_g.field_70165_t && this.posY == mc.field_71439_g.field_70163_u && this.posZ == mc.field_71439_g.field_70161_v) && (this.rotationYaw == mc.field_71439_g.field_70177_z && this.rotationPitch == mc.field_71439_g.field_70125_A || this.posX == mc.field_71439_g.field_70165_t && this.posY == mc.field_71439_g.field_70163_u && this.posZ == mc.field_71439_g.field_70161_v || mc.field_71439_g.field_70154_o != null) || this.hasScreen) {
                            if (this.isActive) {
                                this.isActive = false;
                                PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketPing(1, false));
                            }
                        } else if (!this.isActive) {
                            this.isActive = true;
                            PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketPing(1, true));
                        }
                        this.rotationYaw = mc.field_71439_g.field_70177_z;
                        this.rotationPitch = mc.field_71439_g.field_70125_A;
                        this.posX = mc.field_71439_g.field_70165_t;
                        this.posY = mc.field_71439_g.field_70163_u;
                        this.posZ = mc.field_71439_g.field_70161_v;
                    }
                }
            }
            if (Hats.config.getInt("randomMobHat") > 0 && (Hats.config.getSessionInt("serverHasMod") != 1 || Hats.config.getSessionInt("playerHatsMode") != 4) || Hats.config.getSessionInt("serverHasMod") == 1 && Hats.config.getSessionInt("playerHatsMode") == 4) {
                for (i = 0; i < world.field_72996_f.size(); ++i) {
                    EntityLivingBase living;
                    EntityHat hat;
                    Entity ent = (Entity)world.field_72996_f.get(i);
                    if (!(ent instanceof EntityLivingBase) || (Hats.config.getSessionInt("serverHasMod") != 1 || Hats.config.getSessionInt("playerHatsMode") != 4) && !HatHandler.canMobHat((EntityLivingBase)ent) || ent instanceof EntityPlayer || (hat = this.mobHats.get((living = (EntityLivingBase)ent).func_145782_y())) != null && !hat.field_70128_L) continue;
                    if (Hats.config.getSessionInt("serverHasMod") == 0 || Hats.config.getSessionInt("playerHatsMode") != 4) {
                        HatInfo hatInfo = living.func_70681_au().nextFloat() < (float)Hats.config.getInt("randomMobHat") / 100.0f ? (Hats.config.getInt("randomHat") >= 1 ? HatHandler.getRandomHatFromList(HatHandler.getAllHats(), false) : Hats.favouriteHatInfo) : new HatInfo();
                        hat = new EntityHat((World)world, living, hatInfo);
                        this.mobHats.put(living.func_145782_y(), hat);
                        world.func_72838_d((Entity)hat);
                        continue;
                    }
                    if (this.requestMobHats.contains(living.func_145782_y()) || this.requestedMobHats.contains(living.func_145782_y())) continue;
                    this.requestMobHats.add(living.func_145782_y());
                    this.requestedMobHats.add(living.func_145782_y());
                }
            }
            Iterator<Map.Entry<String, EntityHat>> ite = this.hats.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, EntityHat> e = ite.next();
                if (e.getValue().field_70170_p.field_73011_w.field_76574_g == world.field_73011_w.field_76574_g && world.func_72820_D() - e.getValue().lastUpdate <= 10L) continue;
                e.getValue().func_70106_y();
                ite.remove();
            }
            Iterator<Map.Entry<Integer, EntityHat>> ite1 = this.mobHats.entrySet().iterator();
            while (ite1.hasNext()) {
                Map.Entry<Integer, EntityHat> e = ite1.next();
                if (e.getValue().field_70170_p.field_73011_w.field_76574_g == world.field_73011_w.field_76574_g && world.func_72820_D() - e.getValue().lastUpdate <= 10L) continue;
                e.getValue().func_70106_y();
                ite1.remove();
            }
            this.hasScreen = mc.field_71462_r != null;
        }
    }

    public void updateHatPosAndAngle(EntityHat hat, EntityLivingBase parent) {
        hat.field_70142_S = hat.parent.field_70142_S;
        hat.field_70137_T = hat.parent.field_70137_T;
        hat.field_70136_U = hat.parent.field_70136_U;
        hat.field_70169_q = hat.parent.field_70169_q;
        hat.field_70167_r = hat.parent.field_70167_r;
        hat.field_70166_s = hat.parent.field_70166_s;
        hat.field_70165_t = hat.parent.field_70165_t;
        hat.field_70163_u = hat.parent.field_70163_u;
        hat.field_70161_v = hat.parent.field_70161_v;
        RenderOnEntityHelper helper = HatHandler.getRenderHelper(parent.getClass());
        if (helper != null) {
            hat.field_70127_C = helper.getPrevRotationPitch(parent);
            hat.field_70125_A = helper.getRotationPitch(parent);
            hat.field_70126_B = helper.getPrevRotationYaw(parent);
            hat.field_70177_z = helper.getRotationYaw(parent);
        }
    }

    public HatInfo getPlayerHat(String s) {
        HatInfo name = this.playerWornHats.get(s);
        if (name == null) {
            if (Hats.config.getSessionInt("playerHatsMode") == 2) {
                return new HatInfo(Hats.config.getSessionString("lockedHat").toLowerCase());
            }
            return new HatInfo();
        }
        return name;
    }
}

