/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ISuppliesModule;
import vswe.stevescarts.Modules.Workers.ModuleWorker;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotTorch;

public class ModuleTorch
extends ModuleWorker
implements ISuppliesModule {
    private int light;
    private int lightLimit = 8;
    private int[] boxRect = new int[]{12, this.guiHeight() - 10, 46, 9};
    boolean markerMoving = false;

    public ModuleTorch(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotTorch(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 95;
    }

    @Override
    public boolean work() {
        Vec3 next = this.getLastblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        if (this.light <= this.lightLimit) {
            block0: for (int side = -1; side <= 1; side += 2) {
                int xTorch = x + (this.getCart().z() != z ? side : 0);
                int zTorch = z + (this.getCart().x() != x ? side : 0);
                for (int level = 2; level >= -2; --level) {
                    if (this.getCart().field_70170_p.func_147437_c(xTorch, y + level, zTorch) && Blocks.field_150478_aa.func_149742_c(this.getCart().field_70170_p, xTorch, y + level, zTorch)) {
                        for (int i = 0; i < this.getInventorySize(); ++i) {
                            if (this.getStack(i) == null || Block.func_149634_a((Item)this.getStack(i).func_77973_b()) != Blocks.field_150478_aa) continue;
                            if (this.doPreWork()) {
                                this.startWorking(3);
                                return true;
                            }
                            this.getCart().field_70170_p.func_147449_b(xTorch, y + level, zTorch, Blocks.field_150478_aa);
                            if (this.getCart().hasCreativeSupplies()) continue block0;
                            --this.getStack((int)i).field_77994_a;
                            if (this.getStack((int)i).field_77994_a == 0) {
                                this.setStack(i, null);
                            }
                            this.onInventoryChanged();
                            continue block0;
                        }
                        continue block0;
                    }
                    if (this.getCart().field_70170_p.func_147439_a(xTorch, y + level, zTorch) == Blocks.field_150478_aa) continue block0;
                }
            }
        }
        this.stopWorking();
        return false;
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/torch.png");
        int barLength = 3 * this.light;
        if (this.light == 15) {
            --barLength;
        }
        int srcX = 0;
        if (this.inRect(x, y, this.boxRect)) {
            srcX += this.boxRect[2];
        }
        this.drawImage(gui, this.boxRect, srcX, 0);
        this.drawImage(gui, 13, this.guiHeight() - 10 + 1, 0, 9, barLength, 7);
        this.drawImage(gui, 12 + 3 * this.lightLimit, this.guiHeight() - 10, 0, 16, 1, 9);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, "Threshold: " + this.lightLimit + " Current: " + this.light, x, y, this.boxRect);
    }

    @Override
    public int guiHeight() {
        return super.guiHeight() + 10;
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        short data = (short)(this.light & 0xF);
        data = (short)(data | (short)((this.lightLimit & 0xF) << 4));
        this.updateGuiData(info, 0, data);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.light = data & 0xF;
            this.lightLimit = (data & 0xF0) >> 4;
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.lightLimit = data[0];
            if (this.lightLimit < 0) {
                this.lightLimit = 0;
            } else if (this.lightLimit > 15) {
                this.lightLimit = 15;
            }
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.boxRect)) {
            this.generatePacket(x, y);
            this.markerMoving = true;
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.markerMoving) {
            this.generatePacket(x, y);
        }
        if (button != -1) {
            this.markerMoving = false;
        }
    }

    private void generatePacket(int x, int y) {
        int xInBox = x - this.boxRect[0];
        int val = xInBox / 3;
        if (val < 0) {
            val = 0;
        } else if (val > 15) {
            val = 15;
        }
        this.sendPacket(0, (byte)val);
    }

    public void setThreshold(byte val) {
        this.lightLimit = val;
    }

    public int getThreshold() {
        return this.lightLimit;
    }

    public int getLightLevel() {
        return this.light;
    }

    @Override
    public void update() {
        super.update();
        this.light = this.getCart().field_70170_p.func_72957_l(this.getCart().x(), this.getCart().y() + 1, this.getCart().z());
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateTorches();
    }

    private void calculateTorches() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        int val = 0;
        for (int i = 0; i < 3; ++i) {
            val |= (this.getStack(i) != null ? 1 : 0) << i;
        }
        this.updateDw(0, val);
    }

    public int getTorches() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getTorchInfo();
        }
        return this.getDw(0);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74774_a(this.generateNBTName("lightLimit", id), (byte)this.lightLimit);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.lightLimit = tagCompound.func_74771_c(this.generateNBTName("lightLimit", id));
        this.calculateTorches();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || Block.func_149634_a((Item)item.func_77973_b()) != Blocks.field_150478_aa) continue;
            return true;
        }
        return false;
    }
}

