/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.mekanism.gas;

import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.Optional;
import extracells.integration.Integration;
import extracells.integration.mekanism.gas.GasInterfaceBase;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class GasInterfaceBase$class {
    @Optional.Method(modid="MekanismAPI|gas")
    public static int receiveGas(GasInterfaceBase $this, ForgeDirection side, GasStack stack, boolean doTransfer) {
        return $this.getGasTank(side).receive(stack, doTransfer);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static GasStack drawGas(GasInterfaceBase $this, ForgeDirection side, int amount, boolean doTransfer) {
        return $this.getGasTank(side).draw(amount, doTransfer);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static GasStack drawGas(GasInterfaceBase $this, ForgeDirection side, int amount) {
        return $this.drawGas(side, amount, true);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static boolean canDrawGas(GasInterfaceBase $this, ForgeDirection side, Gas gas) {
        return $this.getGasTank(side).canDraw(gas);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static int receiveGas(GasInterfaceBase $this, ForgeDirection side, GasStack stack) {
        return $this.receiveGas(side, stack, true);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static boolean canReceiveGas(GasInterfaceBase $this, ForgeDirection side, Gas gas) {
        return !$this.hasFilter(side) && $this.getGasTank(side).canReceive(gas);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static boolean canTubeConnect(GasInterfaceBase $this, ForgeDirection side) {
        return $this.isMekanismLoaded();
    }

    public static void setFilter(GasInterfaceBase $this, ForgeDirection side, Fluid fluid) {
        if (fluid == null) {
            $this.setFilter(side, -1);
        } else {
            $this.setFilter(side, fluid.getID());
        }
    }

    public static boolean hasFilter(GasInterfaceBase $this, ForgeDirection side) {
        return $this.getFilter(side) != -1;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public static int exportGas(GasInterfaceBase $this, ForgeDirection side, GasStack gas, DimensionalCoord pos) {
        GasTank tank = $this.getGasTank(side);
        int x = pos.x + side.offsetX;
        int y = pos.y + side.offsetY;
        int z = pos.z + side.offsetZ;
        World world = pos.getWorld();
        if (world == null) {
            return 0;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return 0;
        }
        if (tile instanceof IGasHandler) {
            IGasHandler gasHandler = (IGasHandler)tile;
            return gasHandler.canReceiveGas(side.getOpposite(), gas.getGas()) ? gasHandler.receiveGas(side.getOpposite(), gas, true) : 0;
        }
        return 0;
    }

    public static void setFluid(GasInterfaceBase $this, int _index, Fluid _fluid, EntityPlayer _player) {
        $this.setFilter(ForgeDirection.getOrientation((int)_index), _fluid);
    }

    public static void $init$(GasInterfaceBase $this) {
        $this.extracells$integration$mekanism$gas$GasInterfaceBase$_setter_$isMekanismLoaded_$eq(Integration.Mods.MEKANISM.isEnabled());
    }
}

