/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.BeefGuiControlBase;
import erogenousbeef.bigreactors.gui.IBeefListBoxEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;

public class BeefGuiListBox
extends BeefGuiControlBase {
    protected int borderColor = -5592406;
    protected int backgroundColor = -16777216;
    protected int selectedLineColor = -16777216;
    protected int textColor = -3289651;
    protected int selectedTextColor = -1;
    private List<IBeefListBoxEntry> entries = new ArrayList<IBeefListBoxEntry>();
    private int displayTop = 0;
    private int selectedEntryIdx = -1;
    private static final int NO_ENTRY = -1;
    private static final int margin = 2;

    public BeefGuiListBox(BeefGuiBase container, int x, int y, int width, int height) {
        super(container, x, y, width, height);
    }

    public void add(IBeefListBoxEntry entry) {
        this.entries.add(entry);
    }

    public void remove(IBeefListBoxEntry entry) {
        this.entries.remove(entry);
    }

    @Override
    public void drawBackground(TextureManager renderEngine, int mouseX, int mouseY) {
        BeefGuiListBox.drawRect(this.absoluteX, this.absoluteY, this.absoluteX + this.width, this.absoluteY + this.height, this.borderColor);
        BeefGuiListBox.drawRect(this.absoluteX + 2, this.absoluteY + 2, this.absoluteX + this.width - 4, this.absoluteY + this.height - 4, this.backgroundColor);
    }

    @Override
    public void drawForeground(TextureManager renderEngine, int mouseX, int mouseY) {
        IBeefListBoxEntry entry;
        int drawnY = 0;
        for (int i = this.displayTop; i < this.entries.size() && (entry = this.entries.get(i)).getHeight() + drawnY <= this.height; ++i) {
            if (this.selectedEntryIdx == i) {
                entry.draw(this.guiContainer.getFontRenderer(), this.relativeX + 2, this.relativeY + 2 + drawnY, this.selectedLineColor, this.selectedTextColor);
            } else {
                entry.draw(this.guiContainer.getFontRenderer(), this.relativeX + 2, this.relativeY + 2 + drawnY, this.backgroundColor, this.textColor);
            }
            if (drawnY >= this.height) break;
        }
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        int entryHeight;
        int checkedY = 0;
        for (int i = this.displayTop; i < this.entries.size() && checkedY + (entryHeight = this.entries.get(i).getHeight()) <= this.height - 4; ++i) {
            if (this.absoluteY + 2 + checkedY <= mouseY && this.absoluteY + 2 + entryHeight + checkedY >= mouseY) {
                this.setSelectedIndex(i);
                this.onEntryClicked(this.entries.get(i));
                break;
            }
            checkedY += entryHeight;
        }
    }

    protected void setSelectedIndex(int newSelectedIdx) {
        if (newSelectedIdx < 0 || newSelectedIdx >= this.entries.size()) {
            return;
        }
        if (this.selectedEntryIdx == newSelectedIdx) {
            return;
        }
        this.selectedEntryIdx = newSelectedIdx;
        this.guiContainer.onListBoxSelectionChanged(this, this.entries.get(this.selectedEntryIdx));
    }

    public void onEntryClicked(IBeefListBoxEntry entry) {
        this.guiContainer.onListBoxEntryClicked(this, entry);
    }
}

