/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.varia.Logging;
import mcjty.rftools.Achievements;
import mcjty.rftools.ClientInfo;
import mcjty.rftools.CommonProxy;
import mcjty.rftools.apideps.ComputerCraftHelper;
import mcjty.rftools.apideps.OpenComputersCompatibility;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.blocks.logic.RedstoneChannels;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.blocks.shield.ShieldSetup;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.commands.CommandRftCfg;
import mcjty.rftools.commands.CommandRftDb;
import mcjty.rftools.commands.CommandRftDim;
import mcjty.rftools.commands.CommandRftTp;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.ModDimensions;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.dimlets.DimletDropsEvent;
import mcjty.rftools.items.dimlets.DimletMapping;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.manual.GuiRFToolsManual;
import mcjty.rftools.network.DimensionSyncChannelHandler;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.StringUtils;

@Mod(modid="rftools", name="RFTools", dependencies="required-after:Forge@[10.13.2.1291,);required-after:CoFHLib@[1.0.3,);required-after:McJtyLib@[1.8.1,)", version="4.23")
public class RFTools
implements ModBase {
    public static final String MODID = "rftools";
    public static final String VERSION = "4.23";
    public static final String MIN_FORGE_VER = "10.13.2.1291";
    public static final String MIN_COFHLIB_VER = "1.0.3";
    public static final String MIN_MCJTYLIB_VER = "1.8.1";
    @SidedProxy(clientSide="mcjty.rftools.ClientProxy", serverSide="mcjty.rftools.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="rftools")
    public static RFTools instance;
    public boolean enderio = false;
    public boolean mfr = false;
    public boolean jabba = false;
    public boolean mekanism = false;
    public boolean draconicevolution = false;
    public boolean opencomputers = false;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    private static int modGuiIndex;
    public ClientInfo clientInfo = new ClientInfo();
    public static CreativeTabs tabRfTools;
    public static CreativeTabs tabRfToolsDimlets;
    public static final String SHIFT_MESSAGE = "<Press Shift>";
    public static final int GUI_LIST_BLOCKS;
    public static final int GUI_RF_MONITOR;
    public static final int GUI_LIQUID_MONITOR;
    public static final int GUI_CRAFTER;
    public static final int GUI_STORAGE_SCANNER;
    public static final int GUI_RELAY;
    public static final int GUI_MATTER_TRANSMITTER;
    public static final int GUI_MATTER_RECEIVER;
    public static final int GUI_DIALING_DEVICE;
    public static final int GUI_TELEPORTPROBE;
    public static final int GUI_ADVANCEDPORTER;
    public static final int GUI_MANUAL_MAIN;
    public static final int GUI_MANUAL_DIMENSION;
    public static final int GUI_ENDERGENIC;
    public static final int GUI_SEQUENCER;
    public static final int GUI_COUNTER;
    public static final int GUI_PEARL_INJECTOR;
    public static final int GUI_TIMER;
    public static final int GUI_ENDERMONITOR;
    public static final int GUI_SHIELD;
    public static final int GUI_DEVELOPERS_DELIGHT;
    public static final int GUI_DIMLET_RESEARCHER;
    public static final int GUI_DIMENSION_ENSCRIBER;
    public static final int GUI_DIMENSION_BUILDER;
    public static final int GUI_DIMLET_SCRAMBLER;
    public static final int GUI_MACHINE_INFUSER;
    public static final int GUI_DIMENSION_EDITOR;
    public static final int GUI_ITEMFILTER;
    public static final int GUI_SCREEN;
    public static final int GUI_SCREENCONTROLLER;
    public static final int GUI_DIMLET_WORKBENCH;
    public static final int GUI_ENVIRONMENTAL_CONTROLLER;
    public static final int GUI_SPAWNER;
    public static final int GUI_MATTER_BEAMER;
    public static final int GUI_DIMLET_FILTER;
    public static final int GUI_SPACE_PROJECTOR;
    public static final int GUI_BLOCK_PROTECTOR;
    public static final int GUI_MODULAR_STORAGE;
    public static final int GUI_REMOTE_STORAGE_ITEM;
    public static final int GUI_MODULAR_STORAGE_ITEM;
    public static final int GUI_REMOTE_STORAGE;
    public static final int GUI_STORAGE_FILTER;
    public static final int GUI_BUILDER;
    public static final int GUI_CHAMBER_DETAILS;
    public static final int GUI_SECURITY_MANAGER;
    public static final int GUI_SHAPECARD;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new DimletDropsEvent());
        proxy.preInit(e);
        MainCompatHandler.registerWaila();
        FMLInterModComms.sendMessage((String)"JAKJ_RedstoneInMotion", (String)"blacklistSoft", (String)Block.field_149771_c.func_148750_c((Object)ShieldSetup.invisibleShieldBlock));
        FMLInterModComms.sendMessage((String)"JAKJ_RedstoneInMotion", (String)"blacklistSoft", (String)Block.field_149771_c.func_148750_c((Object)ShieldSetup.noTickInvisibleShieldBlock));
        FMLInterModComms.sendMessage((String)"JAKJ_RedstoneInMotion", (String)"blacklistSoft", (String)Block.field_149771_c.func_148750_c((Object)ShieldSetup.solidShieldBlock));
        FMLInterModComms.sendMessage((String)"JAKJ_RedstoneInMotion", (String)"blacklistSoft", (String)Block.field_149771_c.func_148750_c((Object)ShieldSetup.noTickSolidShieldBlock));
        FMLInterModComms.sendMessage((String)"JAKJ_RedstoneInMotion", (String)"blacklistSoft", (String)Block.field_149771_c.func_148750_c((Object)ScreenSetup.screenHitBlock));
        FMLInterModComms.sendMessage((String)"JAKJ_RedstoneInMotion", (String)"blacklistSoft", (String)Block.field_149771_c.func_148750_c((Object)ScreenSetup.screenBlock));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        this.opencomputers = Loader.isModLoaded((String)"OpenComputers");
        if (this.opencomputers) {
            Logging.log((String)"RFTools Detected OpenComputers: enabling support");
            OpenComputersCompatibility.registerOC();
        }
        channels = NetworkRegistry.INSTANCE.newChannel("RFToolsChannel", new ChannelHandler[]{DimensionSyncChannelHandler.instance});
        Achievements.init();
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            String dimletName;
            if (message.key.equalsIgnoreCase("dimlet_blacklist")) {
                dimletName = message.getStringValue();
                KnownDimletConfiguration.blacklistDimlet(dimletName);
                continue;
            }
            if (message.key.equalsIgnoreCase("dimlet_configure")) {
                String value = message.getStringValue();
                String[] splitted = StringUtils.split((String)value, (String)"=");
                if (splitted.length < 2) {
                    Logging.logError((String)"Bad format for configdimlet. Needs <Type>.<Name>=<CreateCost>,<MaintainCost>,<TickCost>,<Rarity>!");
                    continue;
                }
                KnownDimletConfiguration.reconfigureDimlet(splitted[0], splitted[1]);
                continue;
            }
            if (message.key.equalsIgnoreCase("dimlet_preventworldgen")) {
                dimletName = message.getStringValue();
                KnownDimletConfiguration.preventDimletWorldGeneration(dimletName);
                continue;
            }
            if (!message.key.equalsIgnoreCase("dimlet_preventloot")) continue;
            dimletName = message.getStringValue();
            KnownDimletConfiguration.preventDimletLootGeneration(dimletName);
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRftDim());
        event.registerServerCommand((ICommand)new CommandRftTp());
        event.registerServerCommand((ICommand)new CommandRftDb());
        event.registerServerCommand((ICommand)new CommandRftCfg());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Logging.log((String)"RFTools: server is starting");
        ModDimensions.initDimensions();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Logging.log((String)"RFTools: server is stopping. Shutting down gracefully");
        RfToolsDimensionManager.cleanupDimensionInformation();
        TeleportDestinations.clearInstance();
        RfToolsDimensionManager.clearInstance();
        DimensionStorage.clearInstance();
        DimletMapping.clearInstance();
        RedstoneChannels.clearInstance();
        SecurityChannels.clearInstance();
        BlockProtectors.clearInstance();
        RemoteStorageIdRegistry.clearInstance();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
        this.enderio = Loader.isModLoaded((String)"EnderIO");
        if (this.enderio) {
            Logging.log((String)"RFTools Detected EnderIO: enabling support");
        }
        this.mfr = Loader.isModLoaded((String)"MineFactoryReloaded");
        if (this.mfr) {
            Logging.log((String)"RFTools Detected MineFactory Reloaded: enabling support");
        }
        this.jabba = Loader.isModLoaded((String)"JABBA");
        if (this.jabba) {
            Logging.log((String)"RFTools Detected JABBA: enabling support");
        }
        this.mekanism = Loader.isModLoaded((String)"Mekanism");
        if (this.mekanism) {
            Logging.log((String)"RFTools Detected Mekanism: enabling support");
        }
        this.draconicevolution = Loader.isModLoaded((String)"DraconicEvolution");
        if (this.draconicevolution) {
            Logging.log((String)"RFTools Detected Draconic Evolution: enabling support");
        }
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            Logging.log((String)"RFTools Detected ComputerCraft: enabling support");
            ComputerCraftHelper.register();
        }
    }

    public String getModId() {
        return MODID;
    }

    public void openManual(EntityPlayer player, int bookIndex, String page) {
        GuiRFToolsManual.locatePage = page;
        player.openGui((Object)instance, bookIndex, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    static {
        modGuiIndex = 0;
        tabRfTools = new CreativeTabs("RfTools"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return ModItems.rfToolsManualItem;
            }
        };
        tabRfToolsDimlets = new CreativeTabs("RfToolsDimlets"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return DimletSetup.unknownDimlet;
            }
        };
        GUI_LIST_BLOCKS = modGuiIndex++;
        GUI_RF_MONITOR = modGuiIndex++;
        GUI_LIQUID_MONITOR = modGuiIndex++;
        GUI_CRAFTER = modGuiIndex++;
        GUI_STORAGE_SCANNER = modGuiIndex++;
        GUI_RELAY = modGuiIndex++;
        GUI_MATTER_TRANSMITTER = modGuiIndex++;
        GUI_MATTER_RECEIVER = modGuiIndex++;
        GUI_DIALING_DEVICE = modGuiIndex++;
        GUI_TELEPORTPROBE = modGuiIndex++;
        GUI_ADVANCEDPORTER = modGuiIndex++;
        GUI_MANUAL_MAIN = modGuiIndex++;
        GUI_MANUAL_DIMENSION = modGuiIndex++;
        GUI_ENDERGENIC = modGuiIndex++;
        GUI_SEQUENCER = modGuiIndex++;
        GUI_COUNTER = modGuiIndex++;
        GUI_PEARL_INJECTOR = modGuiIndex++;
        GUI_TIMER = modGuiIndex++;
        GUI_ENDERMONITOR = modGuiIndex++;
        GUI_SHIELD = modGuiIndex++;
        GUI_DEVELOPERS_DELIGHT = modGuiIndex++;
        GUI_DIMLET_RESEARCHER = modGuiIndex++;
        GUI_DIMENSION_ENSCRIBER = modGuiIndex++;
        GUI_DIMENSION_BUILDER = modGuiIndex++;
        GUI_DIMLET_SCRAMBLER = modGuiIndex++;
        GUI_MACHINE_INFUSER = modGuiIndex++;
        GUI_DIMENSION_EDITOR = modGuiIndex++;
        GUI_ITEMFILTER = modGuiIndex++;
        GUI_SCREEN = modGuiIndex++;
        GUI_SCREENCONTROLLER = modGuiIndex++;
        GUI_DIMLET_WORKBENCH = modGuiIndex++;
        GUI_ENVIRONMENTAL_CONTROLLER = modGuiIndex++;
        GUI_SPAWNER = modGuiIndex++;
        GUI_MATTER_BEAMER = modGuiIndex++;
        GUI_DIMLET_FILTER = modGuiIndex++;
        GUI_SPACE_PROJECTOR = modGuiIndex++;
        GUI_BLOCK_PROTECTOR = modGuiIndex++;
        GUI_MODULAR_STORAGE = modGuiIndex++;
        GUI_REMOTE_STORAGE_ITEM = modGuiIndex++;
        GUI_MODULAR_STORAGE_ITEM = modGuiIndex++;
        GUI_REMOTE_STORAGE = modGuiIndex++;
        GUI_STORAGE_FILTER = modGuiIndex++;
        GUI_BUILDER = modGuiIndex++;
        GUI_CHAMBER_DETAILS = modGuiIndex++;
        GUI_SECURITY_MANAGER = modGuiIndex++;
        GUI_SHAPECARD = modGuiIndex++;
    }
}

