/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.blockprotector.BlockProtectorContainer;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.blockprotector.GuiBlockProtector;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class BlockProtectorBlock
extends GenericRFToolsBlock
implements Infusable,
IRedstoneConnectable {
    private IIcon iconFrontOn;

    public BlockProtectorBlock() {
        super(Material.field_151573_f, BlockProtectorTileEntity.class, true);
        this.func_149663_c("blockProtectorBlock");
        this.setHorizRotation(true);
        this.func_149647_a(RFTools.tabRfTools);
    }

    public int getGuiID() {
        return RFTools.GUI_BLOCK_PROTECTOR;
    }

    public String getIdentifyingIconName() {
        return "machineBlockProtector";
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconFrontOn = iconRegister.func_94245_a("rftools:machineBlockProtectorOn");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int id = tagCompound.func_74762_e("protectorId");
            list.add(EnumChatFormatting.GREEN + "Id: " + id);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "Use the smart wrench with this block to select");
            list.add(EnumChatFormatting.WHITE + "other blocks to protect them against explosions");
            list.add(EnumChatFormatting.WHITE + "and other breackage.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof BlockProtectorTileEntity) {
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)te;
            int id = blockProtectorTileEntity.getId();
            currenttip.add(EnumChatFormatting.GREEN + "Id: " + id);
            currenttip.add(EnumChatFormatting.GREEN + "Blocks protected: " + blockProtectorTileEntity.getProtectedBlocks().size());
        }
        return currenttip;
    }

    protected boolean wrenchSneakSelect(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            GlobalCoordinate currentBlock = SmartWrenchItem.getCurrentBlock(player.func_70694_bm());
            if (currentBlock == null) {
                SmartWrenchItem.setCurrentBlock(player.func_70694_bm(), new GlobalCoordinate(new Coordinate(x, y, z), world.field_73011_w.field_76574_g));
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Selected block"));
            } else {
                SmartWrenchItem.setCurrentBlock(player.func_70694_bm(), null);
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Cleared selected block"));
            }
        }
        return true;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float sx, float sy, float sz, int meta) {
        int rc = super.func_149660_a(world, x, y, z, side, sx, sy, sz, meta);
        if (world.field_72995_K) {
            return rc;
        }
        BlockProtectors protectors = BlockProtectors.getProtectors(world);
        GlobalCoordinate gc = new GlobalCoordinate(new Coordinate(x, y, z), world.field_73011_w.field_76574_g);
        protectors.getNewId(gc);
        protectors.save(world);
        return rc;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)tileEntity;
        return new GuiBlockProtector(blockProtectorTileEntity, new BlockProtectorContainer(entityPlayer));
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new BlockProtectorContainer(entityPlayer);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstoneWithTE(world, x, y, z);
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
        if (!world.field_72995_K) {
            BlockProtectorTileEntity blockProtectorTileEntity = (BlockProtectorTileEntity)world.func_147438_o(x, y, z);
            blockProtectorTileEntity.getOrCalculateID();
            blockProtectorTileEntity.updateDestination();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        if (world.field_72995_K) {
            return;
        }
        BlockProtectors protectors = BlockProtectors.getProtectors(world);
        protectors.removeDestination(new Coordinate(x, y, z), world.field_73011_w.field_76574_g);
        protectors.save(world);
    }

    public IIcon getIconInd(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        int state = BlockTools.getState((int)meta);
        switch (state) {
            case 0: {
                return this.iconInd;
            }
            case 1: {
                return this.iconFrontOn;
            }
        }
        return this.iconInd;
    }
}

