/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.dimlets.DimensionBuilderContainer;
import mcjty.rftools.blocks.dimlets.DimensionBuilderTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiDimensionBuilder
extends GenericGuiContainer<DimensionBuilderTileEntity> {
    public static final int BUILDER_WIDTH = 180;
    public static final int BUILDER_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageLabel stages;
    private Label percentage;
    private Label error1;
    private Label error2;
    private ImageChoiceLabel redstoneMode;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/dimensionbuilder.png");
    private static final ResourceLocation iconStages = new ResourceLocation("rftools", "textures/gui/dimensionbuilderstages.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiDimensionBuilder(DimensionBuilderTileEntity dimensionBuilderTileEntity, DimensionBuilderContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)dimensionBuilderTileEntity, (Container)container, RFTools.GUI_MANUAL_DIMENSION, "builder");
        DimensionBuilderTileEntity.setCurrentRF((int)dimensionBuilderTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((DimensionBuilderTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        DimensionBuilderTileEntity cfr_ignored_0 = (DimensionBuilderTileEntity)this.tileEntity;
        this.energyBar.setValue(DimensionBuilderTileEntity.getCurrentRF());
        this.stages = new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconStages, 0, 0);
        this.stages.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(61, 9, 48, 48));
        this.percentage = new Label(this.field_146297_k, (Gui)this).setText("0%").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.percentage.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(115, 25, 50, 16));
        this.error1 = new Label(this.field_146297_k, (Gui)this).setText("").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setColor(0xFF0000);
        this.error1.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(115, 15, 60, 16));
        this.error2 = new Label(this.field_146297_k, (Gui)this).setText("").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setColor(0xFF0000);
        this.error2.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(115, 28, 60, 16));
        this.initRedstoneMode();
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.stages)).addChild((Widget)this.percentage)).addChild((Widget)this.error1)).addChild((Widget)this.error2)).addChild((Widget)this.redstoneMode);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((DimensionBuilderTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
        ((DimensionBuilderTileEntity)this.tileEntity).requestBuildingPercentage();
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiDimensionBuilder.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(150, 46, 16, 16));
        this.redstoneMode.setCurrentChoice(((DimensionBuilderTileEntity)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((DimensionBuilderTileEntity)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "rsMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    protected void func_146976_a(float v, int i, int i2) {
        DimensionBuilderTileEntity cfr_ignored_0 = (DimensionBuilderTileEntity)this.tileEntity;
        int pct = DimensionBuilderTileEntity.getBuildPercentage();
        if (pct == DimensionBuilderTileEntity.ERROR_NOOWNER) {
            this.error1.setText("Builder has");
            this.error2.setText("no owner!");
            this.percentage.setText("");
        } else if (pct == DimensionBuilderTileEntity.ERROR_TOOMANYDIMENSIONS) {
            this.error1.setText("Too many");
            this.error2.setText("dimensions!");
            this.percentage.setText("");
        } else {
            int x = (pct - 1) / 4 % 5;
            int y = (pct - 1) / 4 / 5;
            this.stages.setImage(iconStages, x * 48, y * 48);
            this.percentage.setText(pct + "%");
            this.error1.setText("");
            this.error2.setText("");
        }
        this.drawWindow();
        DimensionBuilderTileEntity cfr_ignored_1 = (DimensionBuilderTileEntity)this.tileEntity;
        this.energyBar.setValue(DimensionBuilderTileEntity.getCurrentRF());
        ((DimensionBuilderTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
        ((DimensionBuilderTileEntity)this.tileEntity).requestBuildingPercentage();
    }
}

