/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.lib.varia.Coordinate;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModule;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import mcjty.rftools.varia.EnergyTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EnergyBarScreenModule
implements ScreenModule {
    protected int dim = 0;
    protected Coordinate coordinate = Coordinate.INVALID;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();

    @Override
    public Object[] getData(World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!world.func_72863_F().func_73149_a(this.coordinate.getX() >> 4, this.coordinate.getZ() >> 4)) {
            return null;
        }
        TileEntity te = world.func_147438_o(this.coordinate.getX(), this.coordinate.getY(), this.coordinate.getZ());
        if (!EnergyTools.isEnergyTE(te)) {
            return null;
        }
        EnergyTools.EnergyLevelMulti energyLevel = EnergyTools.getEnergyLevelMulti(te);
        long energy = energyLevel.getEnergy();
        long maxEnergy = energyLevel.getMaxEnergy();
        return this.helper.getContentsValue(millis, energy, maxEnergy);
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        if (tagCompound != null) {
            this.helper.setShowdiff(tagCompound.func_74767_n("showdiff"));
            this.coordinate = Coordinate.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    Coordinate c = new Coordinate(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.getX() - x);
                    int dy = Math.abs(c.getY() - y);
                    int dz = Math.abs(c.getZ() - z);
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.ENERGY_RFPERTICK;
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }
}

