/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import net.minecraftforge.common.config.Configuration;

public class ShieldConfiguration {
    public static final String CATEGORY_SHIELD = "shield";
    public static int MAXENERGY = 200000;
    public static int RECEIVEPERTICK = 5000;
    public static int rfBase = 8;
    public static int rfCamo = 2;
    public static int rfShield = 2;
    public static int rfDamage = 1000;
    public static int rfDamagePlayer = 2000;
    public static float damage = 5.0f;
    public static int maxShieldSize = 256;
    public static int maxShieldOffset = 128;
    public static int maxShieldDimension = 256;
    public static int maxDisjointShieldDistance = 64;
    public static boolean disableShieldBlocksToUncorruptWorld = false;

    public static void init(Configuration cfg) {
        MAXENERGY = cfg.get(CATEGORY_SHIELD, "shieldMaxRF", MAXENERGY, "Maximum RF storage that the shield block can hold").getInt();
        RECEIVEPERTICK = cfg.get(CATEGORY_SHIELD, "shieldRFPerTick", RECEIVEPERTICK, "RF per tick that the shield block can receive").getInt();
        maxShieldSize = cfg.get(CATEGORY_SHIELD, "shieldMaxSize", maxShieldSize, "Maximum size (in blocks) of a tier 1 shield").getInt();
        maxShieldOffset = cfg.get(CATEGORY_SHIELD, "maxShieldOffset", maxShieldOffset, "Maximum offset of the shape when a shape card is used").getInt();
        maxShieldDimension = cfg.get(CATEGORY_SHIELD, "maxShieldDimension", maxShieldDimension, "Maximum dimension of the shape when a shape card is used").getInt();
        maxDisjointShieldDistance = cfg.get(CATEGORY_SHIELD, "maxDisjointShieldDistance", maxDisjointShieldDistance, "Maximum distance at which you can add disjoint shield sections to a composed shield").getInt();
        rfBase = cfg.get(CATEGORY_SHIELD, "shieldRfBase", rfBase, "Base amount of RF/tick for every 10 blocks in the shield (while active)").getInt();
        rfCamo = cfg.get(CATEGORY_SHIELD, "shieldRfCamo", rfCamo, "RF/tick for every 10 blocks added in case of camo mode").getInt();
        rfShield = cfg.get(CATEGORY_SHIELD, "shieldRfShield", rfShield, "RF/tick for every 10 block addeds in case of shield mode").getInt();
        rfDamage = cfg.get(CATEGORY_SHIELD, "shieldRfDamage", rfDamage, "The amount of RF to consume for a single spike of damage for one entity").getInt();
        rfDamagePlayer = cfg.get(CATEGORY_SHIELD, "shieldRfDamagePlayer", rfDamagePlayer, "The amount of RF to consume for a single spike of damage for one entity (used in case of player-type damage)").getInt();
        damage = (float)cfg.get(CATEGORY_SHIELD, "shieldDamage", (double)damage, "The amount of damage to do for a single spike on one entity").getDouble();
        disableShieldBlocksToUncorruptWorld = cfg.get(CATEGORY_SHIELD, "disableShieldBlocksToUncorruptWorld", disableShieldBlocksToUncorruptWorld, "Set this to true if you have a corrupted world due to a bad camo block in the shield system. Load your world, remove the offending block from the shield, exit MC and then set this back to false").getBoolean();
    }
}

